/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LevenshteinDetailedDistance;
import org.apache.commons.text.similarity.LevenshteinResults;
import org.junit.Assert;
import org.junit.Test;

public class LevenshteinDetailedDistanceTest {
    private static final LevenshteinDetailedDistance UNLIMITED_DISTANCE = new LevenshteinDetailedDistance();

    @Test
    public void testGetLevenshteinDetailedDistance_StringString() {
        LevenshteinResults result = UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"");
        Assert.assertEquals((long)0L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"a");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)1L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"aaapppp", (CharSequence)"");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)7L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"frog", (CharSequence)"fog");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"fly", (CharSequence)"ant");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hello", (CharSequence)"hallo");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
    }

    @Test
    public void testEquals() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"hello", (CharSequence)"hallo");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertEquals((Object)actualResult, (Object)expectedResult);
        actualResult = classBeingTested.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        expectedResult = new LevenshteinResults(Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(5));
        Assert.assertEquals((Object)actualResult, (Object)expectedResult);
        Assert.assertEquals((Object)actualResult, (Object)actualResult);
        actualResult = classBeingTested.apply((CharSequence)"", (CharSequence)"");
        expectedResult = new LevenshteinResults(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertEquals((Object)actualResult, (Object)expectedResult);
    }

    @Test
    public void testHashCode() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"aaapppp", (CharSequence)"");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(7), Integer.valueOf(0));
        Assert.assertEquals((long)actualResult.hashCode(), (long)expectedResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
        Assert.assertEquals((long)actualResult.hashCode(), (long)expectedResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(4));
        Assert.assertEquals((long)actualResult.hashCode(), (long)expectedResult.hashCode());
    }

    @Test
    public void testToString() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(3));
        Assert.assertEquals((Object)actualResult.toString(), (Object)expectedResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"hippo", (CharSequence)"elephant");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(4));
        Assert.assertEquals((Object)actualResult.toString(), (Object)expectedResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"", (CharSequence)"a");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertEquals((Object)actualResult.toString(), (Object)expectedResult.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_NullString() throws Exception {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_StringNull() throws Exception {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test
    public void testGetLevenshteinDetailedDistance_StringStringInt() {
        LevenshteinResults result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"", (CharSequence)"");
        Assert.assertEquals((long)0L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)7L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)7L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"b", (CharSequence)"a");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"a", (CharSequence)"b");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assert.assertEquals((long)0L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assert.assertEquals((long)0L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(10)).apply((CharSequence)"aaaaaa", (CharSequence)"b");
        Assert.assertEquals((long)6L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)6L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(4)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)2L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)6L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)2L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"12345", (CharSequence)"1234567");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"1234567", (CharSequence)"12345");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assert.assertEquals((long)-1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assert.assertEquals((long)3L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assert.assertEquals((long)7L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)4L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)3L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assert.assertEquals((long)8L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)3L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)5L, (long)result.getSubstituteCount().intValue());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assert.assertEquals((long)1L, (long)result.getDistance().intValue());
        Assert.assertEquals((long)0L, (long)result.getInsertCount().intValue());
        Assert.assertEquals((long)0L, (long)result.getDeleteCount().intValue());
        Assert.assertEquals((long)1L, (long)result.getSubstituteCount().intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_NullStringInt() throws Exception {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_StringNullInt() throws Exception {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorWithNegativeThreshold() throws Exception {
        new LevenshteinDetailedDistance(Integer.valueOf(-1));
    }
}

