/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LongestCommonSubsequenceTest {
    private static LongestCommonSubsequence subject;

    @BeforeClass
    public static void setup() {
        subject = new LongestCommonSubsequence();
    }

    @Test
    public void testLongestCommonSubsequenceApply() {
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"left", (CharSequence)""));
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"", (CharSequence)"right"));
        Assert.assertEquals((Object)3, (Object)subject.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assert.assertEquals((Object)0, (Object)subject.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assert.assertEquals((Object)1, (Object)subject.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assert.assertEquals((Object)8, (Object)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assert.assertEquals((Object)20, (Object)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assert.assertEquals((Object)24, (Object)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assert.assertEquals((Object)11, (Object)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assert.assertEquals((Object)1, (Object)subject.apply((CharSequence)"left", (CharSequence)"right"));
        Assert.assertEquals((Object)4, (Object)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assert.assertEquals((Object)15, (Object)subject.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyNullNull() throws Exception {
        subject.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyStringNull() throws Exception {
        subject.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyNullString() throws Exception {
        subject.apply(null, (CharSequence)"right");
    }

    @Test
    public void testLongestCommonSubsequence() {
        Assert.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)""));
        Assert.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"right"));
        Assert.assertEquals((Object)"fog", (Object)subject.logestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog"));
        Assert.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant"));
        Assert.assertEquals((Object)"h", (Object)subject.logestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo"));
        Assert.assertEquals((Object)"ABC Corp", (Object)subject.logestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assert.assertEquals((Object)"D  H Enterprises Inc", (Object)subject.logestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assert.assertEquals((Object)"My Gym Childrens Fitness", (Object)subject.logestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assert.assertEquals((Object)"PENNSYLVNIA", (Object)subject.logestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assert.assertEquals((Object)"t", (Object)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"right"));
        Assert.assertEquals((Object)"tttt", (Object)subject.logestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assert.assertEquals((Object)"the same string", (Object)subject.logestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceNullNull() throws Exception {
        subject.logestCommonSubsequence(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceStringNull() throws Exception {
        subject.logestCommonSubsequence((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceNullString() throws Exception {
        subject.logestCommonSubsequence(null, (CharSequence)"right");
    }
}

