/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.UnicodeUnescaper;
import org.junit.Assert;
import org.junit.Test;

public class UnicodeUnescaperTest {
    @Test
    public void testUPlus() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\u+0047";
        Assert.assertEquals((String)"Failed to unescape Unicode characters with 'u+' notation", (Object)"G", (Object)uu.translate((CharSequence)"\\u+0047"));
    }

    @Test
    public void testUuuuu() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\uuuuuuuu0047";
        String result = uu.translate((CharSequence)"\\uuuuuuuu0047");
        Assert.assertEquals((String)"Failed to unescape Unicode characters with many 'u' characters", (Object)"G", (Object)result);
    }

    @Test
    public void testLessThanFour() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\0047\\u006";
        try {
            uu.translate((CharSequence)"\\0047\\u006");
            Assert.fail((String)"A lack of digits in a Unicode escape sequence failed to throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

