/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.numbers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import org.apache.commons.text.numbers.DoubleFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DoubleFormatTest {
    DoubleFormatTest() {
    }

    private static void assertLocalizedFormatsAreEqual(double d, DecimalFormat df, DoubleFunction<String> fmt, Locale loc) {
        String dfStr = DoubleFormatTest.trimFormatChars(df.format(d));
        String fmtStr = DoubleFormatTest.trimFormatChars(fmt.apply(d));
        Assertions.assertEquals((Object)dfStr, (Object)fmtStr, () -> "Unexpected output for locale [" + loc.toLanguageTag() + "] and double value " + d);
    }

    private static void checkDefaultFormatSpecial(DoubleFunction<String> fmt) {
        DoubleFormatTest.checkFormat(fmt, 0.0, "0.0");
        DoubleFormatTest.checkFormat(fmt, -0.0, "-0.0");
        DoubleFormatTest.checkFormat(fmt, Double.NaN, "NaN");
        DoubleFormatTest.checkFormat(fmt, Double.POSITIVE_INFINITY, "Infinity");
        DoubleFormatTest.checkFormat(fmt, Double.NEGATIVE_INFINITY, "-Infinity");
    }

    private static void checkFormat(DoubleFunction<String> fmt, double d, String str) {
        Assertions.assertEquals((Object)str, (Object)fmt.apply(d));
    }

    private static void checkFormatAccuracy(DoubleFunction<String> fmt, double d) {
        String str = fmt.apply(d);
        double parsed = Double.parseDouble(str);
        Assertions.assertEquals((double)d, (double)parsed, () -> "Formatted double string [" + str + "] did not match input value");
    }

    private static void checkFormatAccuracyWithDefaults(DoubleFormat type) {
        DoubleFunction fmt = type.builder().build();
        DoubleFormatTest.checkDefaultFormatSpecial(fmt);
        DoubleFormatTest.checkFormatAccuracy(fmt, Double.MIN_VALUE);
        DoubleFormatTest.checkFormatAccuracy(fmt, -4.9E-324);
        DoubleFormatTest.checkFormatAccuracy(fmt, Double.MIN_NORMAL);
        DoubleFormatTest.checkFormatAccuracy(fmt, -2.2250738585072014E-308);
        DoubleFormatTest.checkFormatAccuracy(fmt, Double.MAX_VALUE);
        DoubleFormatTest.checkFormatAccuracy(fmt, -1.7976931348623157E308);
        DoubleFormatTest.checkFormatAccuracy(fmt, Math.PI);
        DoubleFormatTest.checkFormatAccuracy(fmt, Math.E);
        Random rnd = new Random(10L);
        int cnt = 1000;
        for (int i = 0; i < 1000; ++i) {
            DoubleFormatTest.checkFormatAccuracy(fmt, DoubleFormatTest.randomDouble(rnd));
        }
    }

    private static void checkLocalizedFormat(Locale loc, String pattern, Function<Locale, DoubleFunction<String>> factory) {
        DecimalFormat df = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(loc));
        DoubleFunction<String> fmt = factory.apply(loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(0.0, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(Double.POSITIVE_INFINITY, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(Double.NEGATIVE_INFINITY, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(Double.NaN, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(1.0, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(-1.0, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(Math.PI, df, fmt, loc);
        DoubleFormatTest.assertLocalizedFormatsAreEqual(Math.E, df, fmt, loc);
        Random rnd = new Random(12L);
        int minExp = -100;
        int maxExp = 100;
        int cnt = 1000;
        for (int i = 0; i < 1000; ++i) {
            DoubleFormatTest.assertLocalizedFormatsAreEqual(DoubleFormatTest.randomDouble(-100, 100, rnd), df, fmt, loc);
        }
    }

    private static void checkLocalizedFormats(String pattern, Function<Locale, DoubleFunction<String>> factory) {
        for (Locale loc : Locale.getAvailableLocales()) {
            DoubleFormatTest.checkLocalizedFormat(loc, pattern, factory);
        }
    }

    private static double randomDouble(int minExp, int maxExp, Random rnd) {
        long mask = -9218868437227405313L;
        long bits = rnd.nextLong() & 0x800FFFFFFFFFFFFFL;
        long exp = rnd.nextInt(maxExp - minExp + 1) + minExp + 1023;
        return Double.longBitsToDouble(bits | exp << 52);
    }

    private static double randomDouble(Random rnd) {
        return DoubleFormatTest.randomDouble(-1022, 1023, rnd);
    }

    private static String trimFormatChars(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.getType(c) == 16) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Test
    void testBuilder_illegalArgs() {
        DoubleFormat.Builder builder = DoubleFormat.PLAIN.builder();
        Assertions.assertThrows(NullPointerException.class, () -> builder.digits(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.digits("a"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.digits("0123456789a"));
        Assertions.assertThrows(NullPointerException.class, () -> builder.exponentSeparator(null));
        Assertions.assertThrows(NullPointerException.class, () -> builder.infinity(null));
        Assertions.assertThrows(NullPointerException.class, () -> builder.nan(null));
        Assertions.assertThrows(NullPointerException.class, () -> builder.formatSymbols(null));
    }

    @Test
    void testCustomDigitString() {
        String digits = "abcdefghij";
        DoubleFunction plain = DoubleFormat.PLAIN.builder().digits("abcdefghij").build();
        DoubleFunction sci = DoubleFormat.SCIENTIFIC.builder().digits("abcdefghij").build();
        DoubleFunction eng = DoubleFormat.ENGINEERING.builder().digits("abcdefghij").build();
        DoubleFunction mixed = DoubleFormat.MIXED.builder().digits("abcdefghij").build();
        DoubleFormatTest.checkFormat(plain, 9.87654321E9, "jihgfedcba.a");
        DoubleFormatTest.checkFormat(sci, 9.87654321E9, "j.ihgfedcbEj");
        DoubleFormatTest.checkFormat(eng, 9.87654321E9, "j.ihgfedcbEj");
        DoubleFormatTest.checkFormat(mixed, 9.87654321E9, "j.ihgfedcbEj");
    }

    @Test
    void testEngineering_custom() {
        DoubleFunction fmt = DoubleFormat.ENGINEERING.builder().maxPrecision(3).minDecimalExponent(-3).allowSignedZero(false).includeFractionPlaceholder(false).decimalSeparator(',').exponentSeparator("e").infinity("inf").nan("nan").minusSign('!').build();
        DoubleFormatTest.checkFormat(fmt, Double.NaN, "nan");
        DoubleFormatTest.checkFormat(fmt, Double.POSITIVE_INFINITY, "inf");
        DoubleFormatTest.checkFormat(fmt, Double.NEGATIVE_INFINITY, "!inf");
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "0");
        DoubleFormatTest.checkFormat(fmt, 0.001, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -0.01, "!10e!3");
        DoubleFormatTest.checkFormat(fmt, 0.1, "100e!3");
        DoubleFormatTest.checkFormat(fmt, -0.0, "0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "!1");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10");
        DoubleFormatTest.checkFormat(fmt, -100.0, "!100");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1e3");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "!10e3");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "100e3");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "!1e6");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "10e6");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "!100e6");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "!1e!3");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12,3e3");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "!10e6");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "10e6");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "180e306");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "0");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "0");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3,14");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2,72");
    }

    @Test
    void testEngineering_defaults() {
        DoubleFunction fmt = DoubleFormat.ENGINEERING.builder().build();
        DoubleFormatTest.checkDefaultFormatSpecial(fmt);
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "10.0E-6");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "-100.0E-6");
        DoubleFormatTest.checkFormat(fmt, 0.001, "1.0E-3");
        DoubleFormatTest.checkFormat(fmt, -0.01, "-10.0E-3");
        DoubleFormatTest.checkFormat(fmt, 0.1, "100.0E-3");
        DoubleFormatTest.checkFormat(fmt, -0.0, "-0.0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0.0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "-1.0");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10.0");
        DoubleFormatTest.checkFormat(fmt, -100.0, "-100.0");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1.0E3");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "-10.0E3");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "100.0E3");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "-1.0E6");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "10.0E6");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "-100.0E6");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "1.25E-3");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "-997.5E-6");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12.345E3");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "-9.999999E6");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "10.0001E6");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "179.76931348623157E306");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "4.9E-324");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "22.250738585072014E-309");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3.141592653589793");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2.718281828459045");
    }

    @Test
    void testEngineering_localeFormatComparison() {
        DoubleFormatTest.checkLocalizedFormats("##0.0##E0", loc -> DoubleFormat.ENGINEERING.builder().maxPrecision(6).alwaysIncludeExponent(true).formatSymbols(DecimalFormatSymbols.getInstance(loc)).build());
    }

    @Test
    void testFormatAccuracy() {
        DoubleFormatTest.checkFormatAccuracyWithDefaults(DoubleFormat.PLAIN);
        DoubleFormatTest.checkFormatAccuracyWithDefaults(DoubleFormat.MIXED);
        DoubleFormatTest.checkFormatAccuracyWithDefaults(DoubleFormat.SCIENTIFIC);
        DoubleFormatTest.checkFormatAccuracyWithDefaults(DoubleFormat.ENGINEERING);
    }

    @Test
    void testMixed_custom() {
        DoubleFunction fmt = DoubleFormat.MIXED.builder().maxPrecision(3).minDecimalExponent(-3).allowSignedZero(false).includeFractionPlaceholder(false).decimalSeparator(',').plainFormatMaxDecimalExponent(4).plainFormatMinDecimalExponent(-1).exponentSeparator("e").infinity("inf").nan("nan").minusSign('!').build();
        DoubleFormatTest.checkFormat(fmt, Double.NaN, "nan");
        DoubleFormatTest.checkFormat(fmt, Double.POSITIVE_INFINITY, "inf");
        DoubleFormatTest.checkFormat(fmt, Double.NEGATIVE_INFINITY, "!inf");
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "0");
        DoubleFormatTest.checkFormat(fmt, 0.001, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -0.01, "!1e!2");
        DoubleFormatTest.checkFormat(fmt, 0.1, "0,1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "!1");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10");
        DoubleFormatTest.checkFormat(fmt, -100.0, "!100");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1000");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "!10000");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "1e5");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "!1e6");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "1e7");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "!1e8");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "!1e!3");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12300");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "!1e7");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "1e7");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "1,8e308");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "0");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "0");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3,14");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2,72");
    }

    @Test
    void testMixed_defaults() {
        DoubleFunction fmt = DoubleFormat.MIXED.builder().build();
        DoubleFormatTest.checkDefaultFormatSpecial(fmt);
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "1.0E-5");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "-1.0E-4");
        DoubleFormatTest.checkFormat(fmt, 0.001, "0.001");
        DoubleFormatTest.checkFormat(fmt, -0.01, "-0.01");
        DoubleFormatTest.checkFormat(fmt, 0.1, "0.1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "-0.0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0.0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "-1.0");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10.0");
        DoubleFormatTest.checkFormat(fmt, -100.0, "-100.0");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1000.0");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "-10000.0");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "100000.0");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "-1000000.0");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "1.0E7");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "-1.0E8");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "0.00125");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "-9.975E-4");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12345.0");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "-9999999.0");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "1.00001E7");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "1.7976931348623157E308");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "4.9E-324");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "2.2250738585072014E-308");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3.141592653589793");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2.718281828459045");
    }

    @Test
    void testPlain_custom() {
        DoubleFunction fmt = DoubleFormat.PLAIN.builder().maxPrecision(3).minDecimalExponent(-3).allowSignedZero(false).includeFractionPlaceholder(false).decimalSeparator(',').exponentSeparator("e").infinity("inf").nan("nan").minusSign('!').build();
        DoubleFormatTest.checkFormat(fmt, Double.NaN, "nan");
        DoubleFormatTest.checkFormat(fmt, Double.POSITIVE_INFINITY, "inf");
        DoubleFormatTest.checkFormat(fmt, Double.NEGATIVE_INFINITY, "!inf");
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "0");
        DoubleFormatTest.checkFormat(fmt, 0.001, "0,001");
        DoubleFormatTest.checkFormat(fmt, -0.01, "!0,01");
        DoubleFormatTest.checkFormat(fmt, 0.1, "0,1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "!1");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10");
        DoubleFormatTest.checkFormat(fmt, -100.0, "!100");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1000");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "!10000");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "100000");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "!1000000");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "10000000");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "!100000000");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "0,001");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "!0,001");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12300");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "!10000000");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "10000000");
        DoubleFormatTest.checkFormat(fmt, 3.4028234663852886E38, "340000000000000000000000000000000000000");
        DoubleFormatTest.checkFormat(fmt, -1.4E-45f, "0");
        DoubleFormatTest.checkFormat(fmt, 1.1754943508222875E-38, "0");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3,14");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2,72");
    }

    @Test
    void testPlain_defaults() {
        DoubleFunction fmt = DoubleFormat.PLAIN.builder().build();
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "0.00001");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "-0.0001");
        DoubleFormatTest.checkFormat(fmt, 0.001, "0.001");
        DoubleFormatTest.checkFormat(fmt, -0.01, "-0.01");
        DoubleFormatTest.checkFormat(fmt, 0.1, "0.1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "-0.0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0.0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "-1.0");
        DoubleFormatTest.checkFormat(fmt, 10.0, "10.0");
        DoubleFormatTest.checkFormat(fmt, -100.0, "-100.0");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1000.0");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "-10000.0");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "100000.0");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "-1000000.0");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "10000000.0");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "-100000000.0");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "0.00125");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "-0.0009975");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "12345.0");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "-9999999.0");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "10000100.0");
        DoubleFormatTest.checkFormat(fmt, 3.4028234663852886E38, "340282346638528860000000000000000000000.0");
        DoubleFormatTest.checkFormat(fmt, -1.4E-45f, "-0.000000000000000000000000000000000000000000001401298464324817");
        DoubleFormatTest.checkFormat(fmt, 1.1754943508222875E-38, "0.000000000000000000000000000000000000011754943508222875");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3.141592653589793");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2.718281828459045");
    }

    @Test
    void testPlain_localeFormatComparison() {
        DoubleFormatTest.checkLocalizedFormats("0.0##", loc -> DoubleFormat.PLAIN.builder().minDecimalExponent(-3).formatSymbols(DecimalFormatSymbols.getInstance(loc)).build());
        DoubleFormatTest.checkLocalizedFormats("#,##0.0##", loc -> DoubleFormat.PLAIN.builder().minDecimalExponent(-3).groupThousands(true).formatSymbols(DecimalFormatSymbols.getInstance(loc)).build());
    }

    @Test
    void testScientific_custom() {
        DoubleFunction fmt = DoubleFormat.SCIENTIFIC.builder().maxPrecision(3).minDecimalExponent(-3).allowSignedZero(false).includeFractionPlaceholder(false).decimalSeparator(',').exponentSeparator("e").infinity("inf").nan("nan").minusSign('!').build();
        DoubleFormatTest.checkFormat(fmt, Double.NaN, "nan");
        DoubleFormatTest.checkFormat(fmt, Double.POSITIVE_INFINITY, "inf");
        DoubleFormatTest.checkFormat(fmt, Double.NEGATIVE_INFINITY, "!inf");
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "0");
        DoubleFormatTest.checkFormat(fmt, 0.001, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -0.01, "!1e!2");
        DoubleFormatTest.checkFormat(fmt, 0.1, "1e!1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "!1");
        DoubleFormatTest.checkFormat(fmt, 10.0, "1e1");
        DoubleFormatTest.checkFormat(fmt, -100.0, "!1e2");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1e3");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "!1e4");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "1e5");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "!1e6");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "1e7");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "!1e8");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "1e!3");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "!1e!3");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "1,23e4");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "!1e7");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "1e7");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "1,8e308");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "0");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "0");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3,14");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2,72");
    }

    @Test
    void testScientific_defaults() {
        DoubleFunction fmt = DoubleFormat.SCIENTIFIC.builder().build();
        DoubleFormatTest.checkDefaultFormatSpecial(fmt);
        DoubleFormatTest.checkFormat(fmt, 1.0E-5, "1.0E-5");
        DoubleFormatTest.checkFormat(fmt, -1.0E-4, "-1.0E-4");
        DoubleFormatTest.checkFormat(fmt, 0.001, "1.0E-3");
        DoubleFormatTest.checkFormat(fmt, -0.01, "-1.0E-2");
        DoubleFormatTest.checkFormat(fmt, 0.1, "1.0E-1");
        DoubleFormatTest.checkFormat(fmt, -0.0, "-0.0");
        DoubleFormatTest.checkFormat(fmt, 0.0, "0.0");
        DoubleFormatTest.checkFormat(fmt, -1.0, "-1.0");
        DoubleFormatTest.checkFormat(fmt, 10.0, "1.0E1");
        DoubleFormatTest.checkFormat(fmt, -100.0, "-1.0E2");
        DoubleFormatTest.checkFormat(fmt, 1000.0, "1.0E3");
        DoubleFormatTest.checkFormat(fmt, -10000.0, "-1.0E4");
        DoubleFormatTest.checkFormat(fmt, 100000.0, "1.0E5");
        DoubleFormatTest.checkFormat(fmt, -1000000.0, "-1.0E6");
        DoubleFormatTest.checkFormat(fmt, 1.0E7, "1.0E7");
        DoubleFormatTest.checkFormat(fmt, -1.0E8, "-1.0E8");
        DoubleFormatTest.checkFormat(fmt, 0.00125, "1.25E-3");
        DoubleFormatTest.checkFormat(fmt, -9.975E-4, "-9.975E-4");
        DoubleFormatTest.checkFormat(fmt, 12345.0, "1.2345E4");
        DoubleFormatTest.checkFormat(fmt, -9999999.0, "-9.999999E6");
        DoubleFormatTest.checkFormat(fmt, 1.00001E7, "1.00001E7");
        DoubleFormatTest.checkFormat(fmt, Double.MAX_VALUE, "1.7976931348623157E308");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_VALUE, "4.9E-324");
        DoubleFormatTest.checkFormat(fmt, Double.MIN_NORMAL, "2.2250738585072014E-308");
        DoubleFormatTest.checkFormat(fmt, Math.PI, "3.141592653589793");
        DoubleFormatTest.checkFormat(fmt, Math.E, "2.718281828459045");
    }

    @Test
    void testScientific_localeFormatComparison() {
        DoubleFormatTest.checkLocalizedFormats("0.0##E0", loc -> DoubleFormat.SCIENTIFIC.builder().maxPrecision(4).alwaysIncludeExponent(true).formatSymbols(DecimalFormatSymbols.getInstance(loc)).build());
    }
}

