/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrTokenizer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class StrBuilderTest {
    static final StrMatcher A_NUMBER_MATCHER = new StrMatcher(){

        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            if (buffer[pos] == 'A' && ++pos < bufferEnd && buffer[pos] >= '0' && buffer[pos] <= '9') {
                return 2;
            }
            return 0;
        }
    };

    @Test
    public void test_LANG_1131_EqualsWithNullStrBuilder() throws Exception {
        StrBuilder sb = new StrBuilder();
        StrBuilder other = null;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.equals(other));
    }

    @Test
    public void testAppendCharBuffer() {
        StrBuilder sb1 = new StrBuilder();
        CharBuffer buf = CharBuffer.allocate(10);
        buf.append("0123456789");
        buf.flip();
        sb1.append(buf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0123456789", (Object)sb1.toString());
        StrBuilder sb2 = new StrBuilder();
        sb2.append(buf, 1, 8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12345678", (Object)sb2.toString());
    }

    @Test
    public void testAppendCharBufferException() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        String text = "Test";
        CharBuffer buffer = CharBuffer.allocate(sb.size() + "Test".length());
        buffer.put("Test");
        buffer.flip();
        try {
            sb.append(buffer, -1, 12);
        }
        catch (StringIndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"startIndex must be valid", (Object)e.getMessage());
        }
        try {
            sb.append(buffer, 0, -1);
        }
        catch (StringIndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"length must be valid", (Object)e.getMessage());
        }
        sb.append(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890Test", (Object)sb.toString());
    }

    @Test
    public void testAppendCharBufferNull() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        CharBuffer buffer = null;
        sb.append(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890", (Object)sb.toString());
        StrBuilder sb1 = new StrBuilder("1234567890");
        CharBuffer buffer1 = null;
        sb.append(buffer1, 0, 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890", (Object)sb1.toString());
    }

    @Test
    public void testAppendCharSequence() {
        CharSequence obj0 = null;
        StrBuilder obj1 = new StrBuilder("test1");
        StringBuilder obj2 = new StringBuilder("test2");
        StringBuffer obj3 = new StringBuffer("test3");
        CharBuffer obj4 = CharBuffer.wrap("test4".toCharArray());
        StrBuilder sb0 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb0.append(obj0).toString());
        StrBuilder sb1 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test1", (Object)sb1.append((CharSequence)obj1).toString());
        StrBuilder sb2 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test2", (Object)sb2.append((CharSequence)obj2).toString());
        StrBuilder sb3 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test3", (Object)sb3.append((CharSequence)obj3).toString());
        StrBuilder sb4 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test4", (Object)sb4.append(obj4).toString());
        StrBuilder sb5 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb5.append(obj0, 0, 0).toString());
    }

    @Test
    public void testAppendln() {
        StrBuilder sb1 = new StrBuilder();
        int ch = 99;
        org.junit.jupiter.api.Assertions.assertEquals((Object)("c" + System.lineSeparator()), (Object)sb1.appendln('c').toString());
    }

    @Test
    public void testAppendStringBuilderNull() {
        StrBuilder sb1 = new StrBuilder();
        StringBuilder b = null;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb1.append(b).toString());
        StrBuilder sb2 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb2.append(b, 0, 0).toString());
    }

    @Test
    public void testAppendTakingTwoIntsWithIndexOutOfBoundsThrowsStringIndexOutOfBoundsExceptionTwo() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> {
            Charset charset = Charset.defaultCharset();
            ByteBuffer byteBuffer = charset.encode("asdf");
            CharBuffer charBuffer = charset.decode(byteBuffer);
            new StrBuilder().append(charBuffer, 933, 654);
        });
    }

    @Test
    public void testAppendTakingTwoIntsWithZeroThrowsStringIndexOutOfBoundsException() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> {
            Charset charset = Charset.defaultCharset();
            ByteBuffer byteBuffer = charset.encode("end < start");
            CharBuffer charBuffer = charset.decode(byteBuffer);
            new StrBuilder(630).append(charBuffer, 0, 630);
        });
    }

    @Test
    public void testAppendToCharBuffer() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        String text = "Test ";
        CharBuffer buffer = CharBuffer.allocate(sb.size() + "Test ".length());
        buffer.put("Test ");
        sb.appendTo((Appendable)buffer);
        buffer.flip();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    @Test
    public void testAppendToStringBuffer() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringBuilder buffer = new StringBuilder("Test ");
        sb.appendTo((Appendable)buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    @Test
    public void testAppendToStringBuilder() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringBuilder builder = new StringBuilder("Test ");
        sb.appendTo((Appendable)builder);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)builder.toString());
    }

    @Test
    public void testAppendToWriter() throws Exception {
        StrBuilder sb = new StrBuilder("1234567890");
        StringWriter writer = new StringWriter();
        writer.append("Test ");
        sb.appendTo((Appendable)writer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)writer.toString());
    }

    @Test
    public void testAsBuilder() {
        StrBuilder sb = new StrBuilder().appendAll((Object[])new String[]{"Lorem", " ", "ipsum", " ", "dolor"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)sb.toString(), (Object)sb.build());
    }

    @Test
    public void testAsReader() throws Exception {
        char[] array;
        StrBuilder sb = new StrBuilder("some text");
        try (Reader reader = sb.asReader();){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
            char[] buf = new char[40];
            org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)reader.read(buf));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"some text", (Object)new String(buf, 0, 9));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)reader.read());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.ready());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)reader.skip(2L));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)reader.skip(-1L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.markSupported());
        }
        reader = sb.asReader();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)115, (int)reader.read());
            reader.mark(-1);
            array = new char[3];
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)reader.read(array, 0, 3));
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array[0]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'m', (char)array[1]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'e', (char)array[2]);
            reader.reset();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.read(array, 1, 1));
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array[0]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array[1]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'e', (char)array[2]);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)reader.skip(2L));
            org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)reader.read());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
            reader.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = sb.asReader();
        try {
            array = new char[3];
            try {
                reader.read(array, -1, 0);
                Assertions.fail((String)"Exception expected!");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                reader.read(array, 0, -1);
                Assertions.fail((String)"Exception expected!");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                reader.read(array, 100, 1);
                Assertions.fail((String)"Exception expected!");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                reader.read(array, 0, 100);
                Assertions.fail((String)"Exception expected!");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                reader.read(array, Integer.MAX_VALUE, Integer.MAX_VALUE);
                Assertions.fail((String)"Exception expected!");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.read(array, 0, 0));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array[0]);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array[1]);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array[2]);
            reader.skip(9L);
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)reader.read(array, 0, 1));
            reader.reset();
            array = new char[30];
            org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)reader.read(array, 0, 30));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testAsTokenizer() throws Exception {
        StrBuilder b = new StrBuilder();
        b.append("a b ");
        StrTokenizer t = b.asTokenizer();
        String[] tokens1 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tokens1.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens1[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens1[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)t.size());
        b.append("c d ");
        String[] tokens2 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tokens2.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens2[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens2[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)t.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)t.next());
        t.reset();
        String[] tokens3 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)tokens3.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens3[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens3[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c", (Object)tokens3[2]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", (Object)tokens3[3]);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)t.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c d ", (Object)t.getContent());
    }

    @Test
    public void testAsWriter() throws Exception {
        StrBuilder sb = new StrBuilder("base");
        try (Writer writer = sb.asWriter();){
            writer.write(108);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"basel", (Object)sb.toString());
            writer.write(new char[]{'i', 'n'});
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baselin", (Object)sb.toString());
            writer.write(new char[]{'n', 'e', 'r'}, 1, 2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner", (Object)sb.toString());
            writer.write(" rout");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner rout", (Object)sb.toString());
            writer.write("ping that server", 1, 3);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.flush();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.write(" hi");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing hi", (Object)sb.toString());
            sb.setLength(4);
            writer.write(100);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"based", (Object)sb.toString());
        }
    }

    @Test
    public void testCapacity() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)sb.buffer.length, (int)sb.capacity());
        sb.append("HelloWorldHelloWorldHelloWorldHelloWorld");
        org.junit.jupiter.api.Assertions.assertEquals((int)sb.buffer.length, (int)sb.capacity());
    }

    @Test
    public void testCapacityAndLength() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.ensureCapacity(32);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("foo");
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.clear();
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("123456789012345678901234567890123");
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() > 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.ensureCapacity(16);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() > 16 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setLength(-1));
        sb.setLength(33);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(16);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 16 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890123456", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(32);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890123456\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(0);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testChaining() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setNewLineText(null));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setNullText(null));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setLength(1));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setCharAt(0, 'a'));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.ensureCapacity(0));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.minimizeCapacity());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.clear());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.reverse());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.trim());
    }

    @Test
    public void testCharAt() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(-1));
        sb.append("foo");
        org.junit.jupiter.api.Assertions.assertEquals((char)'f', (char)sb.charAt(0));
        org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)sb.charAt(1));
        org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)sb.charAt(2));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(-1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(3));
    }

    @Test
    public void testClear() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertTrue((sb.buffer.length >= 5 ? 1 : 0) != 0);
    }

    @Test
    public void testConstructors() {
        StrBuilder sb0 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb0.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb0.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb0.size());
        StrBuilder sb1 = new StrBuilder(32);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb1.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb1.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb1.size());
        StrBuilder sb2 = new StrBuilder(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb2.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb2.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb2.size());
        StrBuilder sb3 = new StrBuilder(-1);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb3.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb3.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb3.size());
        StrBuilder sb4 = new StrBuilder(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb4.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb4.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb4.size());
        StrBuilder sb5 = new StrBuilder((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb5.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb5.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb5.size());
        StrBuilder sb6 = new StrBuilder("");
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb6.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb6.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb6.size());
        StrBuilder sb7 = new StrBuilder("foo");
        org.junit.jupiter.api.Assertions.assertEquals((int)35, (int)sb7.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb7.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb7.size());
    }

    @Test
    public void testContains_char() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('a'));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('o'));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('z'));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains('1'));
    }

    @Test
    public void testContains_String() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("pq"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("z"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains("zyx"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains((String)null));
    }

    @Test
    public void testContains_StrMatcher() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StrMatcher.charMatcher((char)'a')));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StrMatcher.stringMatcher((String)"pq")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StrMatcher.charMatcher((char)'z')));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains(StrMatcher.stringMatcher((String)"zy")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains((StrMatcher)null));
        sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains(A_NUMBER_MATCHER));
        sb.append("B A1 C");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(A_NUMBER_MATCHER));
    }

    @Test
    public void testDeleteAll_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll('X');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll('a');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll('c');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("X");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("a");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll("c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll("b");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteAll("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"acba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteAll((StrMatcher)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xy", (Object)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteCharAt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.deleteCharAt(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.deleteCharAt(1000));
    }

    @Test
    public void testDeleteCharAtWithNegative() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> new StrBuilder().deleteCharAt(-1258));
    }

    @Test
    public void testDeleteFirst_char() {
        StrBuilder sb = new StrBuilder("abcba");
        sb.deleteFirst('X');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcba", (Object)sb.toString());
        sb.deleteFirst('a');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcba", (Object)sb.toString());
        sb.deleteFirst('c');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bba", (Object)sb.toString());
        sb.deleteFirst('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteFirst((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("X");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("a");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.deleteFirst("c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbccba", (Object)sb.toString());
        sb.deleteFirst("b");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bccba", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteFirst("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abccba", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteFirst((StrMatcher)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xA1A2yA3", (Object)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteIntInt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.delete(0, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb.toString());
        sb.delete(1, 2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)sb.toString());
        sb.delete(0, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.delete(0, 1000);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.delete(1, 2));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.delete(-1, 1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> new StrBuilder("anything").delete(2, 1));
    }

    @Test
    public void testEndsWith() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("a"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("c"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith(""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith(null));
        sb.append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("c"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("bc"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("cba"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("abcd"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith(" abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("abc "));
    }

    @Test
    public void testEnsureCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.ensureCapacity(2);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 2 ? 1 : 0) != 0);
        sb.ensureCapacity(-1);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 0 ? 1 : 0) != 0);
        sb.append("HelloWorld");
        sb.ensureCapacity(40);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 40 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equals(sb2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)sb1, (Object)sb2);
        sb1.append("abc");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)sb1, (Object)sb2);
        sb2.append("ABC");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)sb1, (Object)sb2);
        sb2.clear().append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)sb1, (Object)sb2);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)sb1, (Object)1);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"abc", (Object)sb1);
    }

    @Test
    public void testEqualsIgnoreCase() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb1.append("abc");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.append("ABC");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.clear().append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb2.clear().append("aBc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
    }

    @Test
    public void testGetChars() {
        StrBuilder sb = new StrBuilder();
        char[] input = new char[10];
        char[] a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[10], (char[])a);
        sb.append("junit");
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'j', 'u', 'n', 'i', 't', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, (char[])a);
        a = sb.getChars(null);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a);
        input = new char[5];
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        input = new char[4];
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)input, (Object)a);
    }

    @Test
    public void testGetCharsIntIntCharArrayInt() {
        StrBuilder sb = new StrBuilder();
        sb.append("junit");
        char[] a = new char[5];
        sb.getChars(0, 5, a, 0);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'j', 'u', 'n', 'i', 't'}, (char[])a);
        a = new char[5];
        sb.getChars(0, 2, a, 3);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\u0000', '\u0000', 'j', 'u'}, (char[])a);
        try {
            sb.getChars(-1, 0, a, 0);
            Assertions.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(0, -1, a, 0);
            Assertions.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(0, 20, a, 0);
            Assertions.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.getChars(4, 2, a, 0);
            Assertions.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetNewLineText() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNewLineText());
        sb.setNewLineText("#");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"#", (Object)sb.getNewLineText());
        sb.setNewLineText("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.getNewLineText());
        sb.setNewLineText((String)null);
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNewLineText());
    }

    @Test
    public void testGetSetNullText() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
        sb.setNullText("null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"null", (Object)sb.getNullText());
        sb.setNullText("");
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
        sb.setNullText("NULL");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"NULL", (Object)sb.getNullText());
        sb.setNullText((String)null);
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
    }

    @Test
    public void testHashCode() {
        StrBuilder sb = new StrBuilder();
        int hc1a = sb.hashCode();
        int hc1b = sb.hashCode();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)hc1a);
        org.junit.jupiter.api.Assertions.assertEquals((int)hc1a, (int)hc1b);
        sb.append("abc");
        int hc2a = sb.hashCode();
        int hc2b = sb.hashCode();
        org.junit.jupiter.api.Assertions.assertTrue((hc2a != 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)hc2a, (int)hc2b);
    }

    @Test
    public void testIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(97), (int)sb.indexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(98), (int)sb.indexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z'));
    }

    @Test
    public void testIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a', -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('a', 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('a', 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(97, 1), (int)sb.indexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(98, 2), (int)sb.indexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf('z', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z', 3));
    }

    @Test
    public void testIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("a"), (int)sb.indexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ab"), (int)sb.indexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("b"), (int)sb.indexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ba"), (int)sb.indexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("z"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((String)null));
    }

    @Test
    public void testIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a", -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("a", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("abcdef", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("a", 1), (int)sb.indexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ab", 1), (int)sb.indexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("b", 2), (int)sb.indexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("ba", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ba", 2), (int)sb.indexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("za", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("za", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((String)null, 2));
    }

    @Test
    public void testIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b')));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)sb.indexOf(StrMatcher.charMatcher((char)'d')));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.noneMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null));
        sb.append(" A1 junction");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.spaceMatcher(), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.spaceMatcher(), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.noneMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 22));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 23));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testIndexOfLang294() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("three"));
    }

    @Test
    public void testIsEmpty() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.clear();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testLang294() {
        StrBuilder sb = new StrBuilder("\n%BLAH%\nDo more stuff\neven more stuff\n%BLAH%\n");
        sb.deleteAll("\n%BLAH%");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\nDo more stuff\neven more stuff\n", (Object)sb.toString());
    }

    @Test
    public void testLang295() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains('h'), (String)"The contains(char) method is looking beyond the end of the string");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('h'), (String)"The indexOf(char) method is looking beyond the end of the string");
    }

    @Test
    public void testLang412Left() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(null, 10, '*');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"**********", (Object)sb.toString(), (String)"Failed to invoke appendFixedWidthPadLeft correctly");
    }

    @Test
    public void testLang412Right() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(null, 10, '*');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"**********", (Object)sb.toString(), (String)"Failed to invoke appendFixedWidthPadRight correctly");
    }

    @Test
    public void testLastIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(97), (int)sb.lastIndexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(98), (int)sb.lastIndexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z'));
    }

    @Test
    public void testLastIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('a', -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf('a', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(97, 1), (int)sb.lastIndexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(98, 2), (int)sb.lastIndexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf('z', sb.length()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z', 1));
    }

    @Test
    public void testLastIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("a"), (int)sb.lastIndexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ab"), (int)sb.lastIndexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("b"), (int)sb.lastIndexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ba"), (int)sb.lastIndexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("z"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((String)null));
    }

    @Test
    public void testLastIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("a", -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("a", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("abcdef", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("", 3), (int)sb.lastIndexOf("", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("", 1), (int)sb.lastIndexOf("", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("a", 1), (int)sb.lastIndexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ab", 1), (int)sb.lastIndexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("b", 2), (int)sb.lastIndexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ba", 2), (int)sb.lastIndexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("za", sb.length()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("za", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((String)null, 2));
    }

    @Test
    public void testLastIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b')));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'d')));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.noneMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null));
        sb.append(" A1 junction");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testLastIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -1));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.noneMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 22));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 23));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testLeftString() {
        StrBuilder sb = new StrBuilder("left right");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left", (Object)sb.leftString(4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.leftString(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.leftString(-5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left right", (Object)sb.leftString(15));
    }

    @Test
    public void testLength() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)sb.length());
    }

    @Test
    public void testMidString() {
        StrBuilder sb = new StrBuilder("hello goodbye hello");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.midString(6, 7));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(-5, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.midString(0, -1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.midString(20, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(14, 22));
    }

    @Test
    public void testMinimizeCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.capacity());
        sb.append("HelloWorld");
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)sb.capacity());
    }

    @Test
    public void testReadFromCharBuffer() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)CharBuffer.wrap(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromCharBufferAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)CharBuffer.wrap(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReadable() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)new MockReadable(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReadableAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)new MockReadable(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReader() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            StrBuilder sb = new StrBuilder();
            int len = sb.readFrom((Readable)new StringReader(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReaderAppendsToEnd() throws Exception {
        StrBuilder sb = new StrBuilder("Test");
        sb.readFrom((Readable)new StringReader(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReplace_int_int_String() {
        StrBuilder sb = new StrBuilder("abc");
        sb.replace(0, 1, "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbc", (Object)sb.toString());
        sb.replace(0, 1, "aaa");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaabc", (Object)sb.toString());
        sb.replace(0, 3, "");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb.toString());
        sb.replace(1, 2, (String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)sb.toString());
        sb.replace(1, 1000, "text");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"btext", (Object)sb.toString());
        sb.replace(0, 1000, "text");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"text", (Object)sb.toString());
        sb = new StrBuilder("atext");
        sb.replace(1, 1, "ny");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"anytext", (Object)sb.toString());
        try {
            sb.replace(2, 1, "anything");
            Assertions.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb = new StrBuilder();
        try {
            sb.replace(1, 2, "anything");
            Assertions.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.replace(-1, 1, "anything");
            Assertions.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryCount() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 5);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryEndIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 0, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 2, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 3, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 4, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 5, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 6, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 7, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 8, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 9, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 1000, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, 1, -1);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryMatcher() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace((StrMatcher)null, "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replace(StrMatcher.charMatcher((char)'a'), "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbcbccbx", (Object)sb.toString());
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxcxx", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new StrBuilder();
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryReplace() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "cb", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "-", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab-c-a", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "+++", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab+++c+++a", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abca", (Object)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), null, 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abca", (Object)sb.toString());
    }

    @Test
    public void testReplace_StrMatcher_String_int_int_int_VaryStartIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 1, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 3, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 4, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxa-ay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 5, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaa-y-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 6, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 7, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 8, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 9, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 10, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 11, sb.length(), -1);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", -1, sb.length(), -1);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll('x', 'y');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll('a', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll('b', 'e');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dececced", (Object)sb.toString());
        sb.replaceAll('c', 'f');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defeffed", (Object)sb.toString());
        sb.replaceAll('d', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defeffed", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((String)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((String)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("x", "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("a", "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll("d", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll("cb", "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxxbx", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((StrMatcher)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((StrMatcher)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'x'), "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'a'), "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'d'), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll(StrMatcher.stringMatcher((String)"cb"), "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxxbx", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceAll(A_NUMBER_MATCHER, "***");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new StrBuilder("Dear X, hello X.");
        sb.replaceAll(StrMatcher.stringMatcher((String)"X"), "012345678901234567");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Dear 012345678901234567, hello 012345678901234567.", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst('x', 'y');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst('a', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst('b', 'e');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"decbccba", (Object)sb.toString());
        sb.replaceFirst('c', 'f');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defbccba", (Object)sb.toString());
        sb.replaceFirst('d', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defbccba", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((String)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((String)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("x", "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("a", "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst("d", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst("cb", "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxb", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((StrMatcher)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((StrMatcher)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'x'), "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'a'), "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'d'), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst(StrMatcher.stringMatcher((String)"cb"), "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxb", (Object)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceFirst(A_NUMBER_MATCHER, "***");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-A2A3-A4", (Object)sb.toString());
    }

    @Test
    public void testReverse() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.clear().append(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eurt", (Object)sb.reverse().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)sb.reverse().toString());
    }

    @Test
    public void testRightString() {
        StrBuilder sb = new StrBuilder("left right");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"right", (Object)sb.rightString(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.rightString(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.rightString(-5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left right", (Object)sb.rightString(15));
    }

    @Test
    public void testSetCharAt() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(0, 'f'));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(-1, 'f'));
        sb.append("foo");
        sb.setCharAt(0, 'b');
        sb.setCharAt(1, 'a');
        sb.setCharAt(2, 'r');
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(3, '!'));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)sb.toString());
    }

    @Test
    public void testSetLength() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.setLength(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He\u0000", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setLength(-1));
    }

    @Test
    public void testSize() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)sb.size());
    }

    @Test
    public void testStartsWith() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith("a"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith(null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith(""));
        sb.append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("ab"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith("cba"));
    }

    @Test
    public void testSubSequenceIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(2, -1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(2, sb.length() + 1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(3, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.subSequence(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".subSequence(0, 6), (Object)sb.subSequence(0, 6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.subSequence(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".subSequence(6, 13), (Object)sb.subSequence(6, 13));
    }

    @Test
    public void testSubstringInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(6), (Object)sb.substring(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye", (Object)sb.substring(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(0), (Object)sb.substring(0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(-1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(15));
    }

    @Test
    public void testSubstringIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.substring(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(0, 6), (Object)sb.substring(0, 6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(6, 13), (Object)sb.substring(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6, 20));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(15, 20));
    }

    @Test
    public void testToCharArray() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.toCharArray().length);
        char[] a = sb.toCharArray();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)a, (String)"toCharArray() result is null");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)a.length, (String)"toCharArray() result is too large");
        sb.append("junit");
        a = sb.toCharArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length, (String)"toCharArray() result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a, (String)"toCharArray() result does not match");
    }

    @Test
    public void testToCharArrayIntInt() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.toCharArray(0, 0).length);
        sb.append("junit");
        char[] a = sb.toCharArray(0, 20);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"juni".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"juni".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)a, (String)"toCharArray(int,int) result is null");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.toCharArray(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.toCharArray(6, 5));
    }

    @Test
    public void testToString() {
        StrBuilder sb = new StrBuilder("abc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)sb.toString());
    }

    @Test
    public void testToStringBuffer() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StringBuffer().toString(), (Object)sb.toStringBuffer().toString());
        sb.append("junit");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StringBuffer("junit").toString(), (Object)sb.toStringBuffer().toString());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testToStringBuilder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.genStringConcat(StringBuilderRewriter.java:193)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.testAppendChain(StringBuilderRewriter.java:180)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:43)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:786)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testTrim() {
        StrBuilder sb = new StrBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.clear().append(" \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.trim().toString());
        sb.clear().append(" \u0000 a b c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append("a b c \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append(" \u0000 a b c \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.clear().append("a b c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
    }

    private static final class MockReadable
    implements Readable {
        private final CharBuffer src;

        MockReadable(String src) {
            this.src = CharBuffer.wrap(src);
        }

        @Override
        public int read(CharBuffer cb) throws IOException {
            return this.src.read(cb);
        }
    }
}

