/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.text.translate.CsvTranslators;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CsvTranslatorsTest {
    @Test
    public void testCsvEscaperCommaTest() throws IOException {
        CsvTranslators.CsvEscaper escaper = new CsvTranslators.CsvEscaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,a,test";
        escaper.translateWhole((CharSequence)"hi,this,is,a,test", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("\"hi,this,is,a,test\"");
    }

    @Test
    public void testCsvEscaperCRTest() throws IOException {
        CsvTranslators.CsvEscaper escaper = new CsvTranslators.CsvEscaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,a,CR,test" + String.valueOf('\r');
        escaper.translateWhole((CharSequence)input, (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("\"hi,this,is,a,CR,test" + String.valueOf('\r') + "\"");
    }

    @Test
    public void testCsvEscaperLFTest() throws IOException {
        CsvTranslators.CsvEscaper escaper = new CsvTranslators.CsvEscaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,a,LF,test" + String.valueOf('\n');
        escaper.translateWhole((CharSequence)input, (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("\"hi,this,is,a,LF,test" + String.valueOf('\n') + "\"");
    }

    @Test
    public void testCsvEscaperPlaneTextTest() throws IOException {
        CsvTranslators.CsvEscaper escaper = new CsvTranslators.CsvEscaper();
        StringWriter writer = new StringWriter();
        String input = "hi this is just a plane text nothing to do with csv!";
        escaper.translateWhole((CharSequence)"hi this is just a plane text nothing to do with csv!", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)"hi this is just a plane text nothing to do with csv!").isEqualTo(data);
    }

    @Test
    public void testCsvEscaperQuoteTest() throws IOException {
        CsvTranslators.CsvEscaper escaper = new CsvTranslators.CsvEscaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,a,\"quote,test";
        escaper.translateWhole((CharSequence)"hi,this,is,a,\"quote,test", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("\"hi,this,is,a,\"\"quote,test\"");
    }

    @Test
    public void testCsvUnEscaperPlaneTextTest() throws IOException {
        CsvTranslators.CsvUnescaper escaper = new CsvTranslators.CsvUnescaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,unescape,test";
        escaper.translateWhole((CharSequence)"hi,this,is,unescape,test", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("hi,this,is,unescape,test");
    }

    @Test
    public void testCsvUnEscaperTest1() throws IOException {
        CsvTranslators.CsvUnescaper escaper = new CsvTranslators.CsvUnescaper();
        StringWriter writer = new StringWriter();
        String input = "\"hi,this,is,unescape,test\"";
        escaper.translateWhole((CharSequence)"\"hi,this,is,unescape,test\"", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("hi,this,is,unescape,test");
    }

    @Test
    public void testCsvUnEscaperTest2() throws IOException {
        CsvTranslators.CsvUnescaper escaper = new CsvTranslators.CsvUnescaper();
        StringWriter writer = new StringWriter();
        String input = "\"hi,this,is,unescape,test";
        escaper.translateWhole((CharSequence)"\"hi,this,is,unescape,test", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)"\"hi,this,is,unescape,test").isEqualTo(data);
    }

    @Test
    public void testCsvUnEscaperTest3() throws IOException {
        CsvTranslators.CsvUnescaper escaper = new CsvTranslators.CsvUnescaper();
        StringWriter writer = new StringWriter();
        String input = "hi,this,is,unescape,test\"";
        escaper.translateWhole((CharSequence)"hi,this,is,unescape,test\"", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)"hi,this,is,unescape,test\"").isEqualTo(data);
    }

    @Test
    public void testCsvUnEscaperTest4() throws IOException {
        CsvTranslators.CsvUnescaper escaper = new CsvTranslators.CsvUnescaper();
        StringWriter writer = new StringWriter();
        String input = "\"hi,this,is,\"unescape,test\"";
        escaper.translateWhole((CharSequence)"\"hi,this,is,\"unescape,test\"", (Writer)writer);
        String data = ((Object)writer).toString();
        Assertions.assertThat((String)data).isEqualTo("hi,this,is,\"unescape,test");
    }
}

