/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Locale;
import org.apache.commons.text.similarity.FuzzyScore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FuzzyScoreTest {
    private static final FuzzyScore ENGLISH_SCORE = new FuzzyScore(Locale.ENGLISH);

    @Test
    public void testGetFuzzyScore() {
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"b")).isEqualTo(0);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Room", (CharSequence)"o")).isEqualTo(1);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"w")).isEqualTo(1);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"ws")).isEqualTo(2);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Workshop", (CharSequence)"wo")).isEqualTo(4);
        Assertions.assertThat((Integer)ENGLISH_SCORE.fuzzyScore((CharSequence)"Apache Software Foundation", (CharSequence)"asf")).isEqualTo(3);
    }

    @Test
    public void testGetFuzzyScore_NullNullLocale() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ENGLISH_SCORE.fuzzyScore(null, null));
    }

    @Test
    public void testGetFuzzyScore_NullStringLocale() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ENGLISH_SCORE.fuzzyScore(null, (CharSequence)"not null"));
    }

    @Test
    public void testGetFuzzyScore_StringNullLocale() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ENGLISH_SCORE.fuzzyScore((CharSequence)"not null", null));
    }

    @Test
    public void testGetLocale() {
        Locale locale = Locale.CANADA_FRENCH;
        FuzzyScore fuzzyScore = new FuzzyScore(locale);
        Locale localeTwo = fuzzyScore.getLocale();
        Assertions.assertThat((Object)localeTwo).isSameAs((Object)locale);
    }

    @Test
    public void testMissingLocale() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new FuzzyScore((Locale)null));
    }
}

