/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.text.translate.SinglePassTranslator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SinglePassTranslatorTest {
    private final SinglePassTranslator dummyTranslator = new SinglePassTranslator(){

        void translateWhole(CharSequence input, Writer out) throws IOException {
        }
    };
    private StringWriter out;

    @Before
    public void before() {
        this.out = new StringWriter();
    }

    @Test
    public void codePointsAreReturned() throws Exception {
        Assertions.assertThat((int)this.dummyTranslator.translate((CharSequence)"", 0, (Writer)this.out)).isEqualTo(0);
        Assertions.assertThat((int)this.dummyTranslator.translate((CharSequence)"abc", 0, (Writer)this.out)).isEqualTo(3);
        Assertions.assertThat((int)this.dummyTranslator.translate((CharSequence)"abcdefg", 0, (Writer)this.out)).isEqualTo(7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void indexIsValidated() throws Exception {
        this.dummyTranslator.translate((CharSequence)"abc", 1, (Writer)this.out);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTranslateThrowsIllegalArgumentException() throws IOException {
        this.dummyTranslator.translate((CharSequence)"(,Fk", 647, null);
    }
}

