/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.text.CaseUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CaseUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertThat((Object)new CaseUtils()).isNotNull();
        Constructor<?>[] cons = CaseUtils.class.getDeclaredConstructors();
        Assertions.assertThat((int)cons.length).isEqualTo(1);
        Assertions.assertThat((boolean)Modifier.isPublic(cons[0].getModifiers())).isTrue();
        Assertions.assertThat((boolean)Modifier.isPublic(CaseUtils.class.getModifiers())).isTrue();
        Assertions.assertThat((boolean)Modifier.isFinal(CaseUtils.class.getModifiers())).isFalse();
    }

    @Test
    public void testToCamelCase() {
        Assertions.assertThat((String)CaseUtils.toCamelCase(null, (boolean)false, null)).isNull();
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"", (boolean)true, null)).isEqualTo((Object)"");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"  ", (boolean)false, null)).isEqualTo((Object)"  ");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"a  b  c  @def", (boolean)false, null)).isEqualTo((Object)"aBC@def");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[0])).isEqualTo((Object)"ABC@def");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[]{'-'})).isEqualTo((Object)"ABC@def");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"a b c @def", (boolean)true, (char[])new char[]{'-'})).isEqualTo((Object)"ABC@def");
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"-+@ ", (boolean)true, (char[])chars)).isEqualTo((Object)"-+@ ");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"   to-CAMEL-cASE", (boolean)false, (char[])chars)).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"@@@@   to+CAMEL@cASE ", (boolean)true, (char[])chars)).isEqualTo((Object)"ToCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"To+CA+ME L@cASE", (boolean)true, (char[])chars)).isEqualTo((Object)"ToCaMeLCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"To.Camel.Case", (boolean)false, (char[])new char[]{'.'})).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"To.Camel-Case", (boolean)false, (char[])new char[]{'-', '.'})).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)" to @ Camel case", (boolean)false, (char[])new char[]{'-', '@'})).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)" @to @ Camel case", (boolean)true, (char[])new char[]{'-', '@'})).isEqualTo((Object)"ToCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)true, null)).isEqualTo((Object)"ToCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)false, null)).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"TO CAMEL CASE", (boolean)false, null)).isEqualTo((Object)"toCamelCase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)false, null)).isEqualTo((Object)"tocamelcase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)true, null)).isEqualTo((Object)"Tocamelcase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"Tocamelcase", (boolean)false, null)).isEqualTo((Object)"tocamelcase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)true, (char[])new char[0])).isEqualTo((Object)"Tocamelcase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"tocamelcase", (boolean)false, (char[])new char[0])).isEqualTo((Object)"tocamelcase");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"\ud800\udf00 \ud800\udf02", (boolean)true, (char[])new char[0])).isEqualTo((Object)"\ud800\udf00\ud800\udf02");
        Assertions.assertThat((String)CaseUtils.toCamelCase((String)"\ud800\udf00\ud800\udf01\ud800\udf14\ud800\udf02\ud800\udf03", (boolean)true, (char[])new char[]{'\ud800', '\udf14'})).isEqualTo((Object)"\ud800\udf00\ud800\udf01\ud800\udf02\ud800\udf03");
    }
}

