/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.HashMap;
import org.apache.commons.text.translate.LookupTranslator;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LookupTranslatorTest {
    @Test
    public void testBasicLookup() throws IOException {
        HashMap<String, String> translatorMap = new HashMap<String, String>();
        translatorMap.put("one", "two");
        LookupTranslator lt = new LookupTranslator(translatorMap);
        StringWriter out = new StringWriter();
        int result = lt.translate((CharSequence)"one", 0, (Writer)out);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result).as("Incorrect codepoint consumption", new Object[0])).isEqualTo(3);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)out.toString()).as("Incorrect value", new Object[0])).isEqualTo((Object)"two");
    }

    @Test
    public void testLang882() throws IOException {
        HashMap<StringBuffer, StringBuffer> translatorMap = new HashMap<StringBuffer, StringBuffer>();
        translatorMap.put(new StringBuffer("one"), new StringBuffer("two"));
        LookupTranslator lt = new LookupTranslator(translatorMap);
        StringWriter out = new StringWriter();
        int result = lt.translate((CharSequence)new StringBuffer("one"), 0, (Writer)out);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result).as("Incorrect codepoint consumption", new Object[0])).isEqualTo(3);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)out.toString()).as("Incorrect value", new Object[0])).isEqualTo((Object)"two");
    }

    @Test(expected=InvalidParameterException.class)
    public void testFailsToCreateLookupTranslatorThrowsInvalidParameterException() {
        new LookupTranslator(null);
    }
}

