/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.text.StrLookup;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class StrLookupTest {
    @Test
    public void testNoneLookup() {
        Assert.assertNull((Object)StrLookup.noneLookup().lookup(null));
        Assert.assertNull((Object)StrLookup.noneLookup().lookup(""));
        Assert.assertNull((Object)StrLookup.noneLookup().lookup("any"));
    }

    @Test
    public void testSystemProperiesLookup() {
        Assert.assertEquals((Object)System.getProperty("os.name"), (Object)StrLookup.systemPropertiesLookup().lookup("os.name"));
        Assert.assertNull((Object)StrLookup.systemPropertiesLookup().lookup(""));
        Assert.assertNull((Object)StrLookup.systemPropertiesLookup().lookup("other"));
        try {
            StrLookup.systemPropertiesLookup().lookup(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemPropertiesLookupReplacedProperties() {
        Properties oldProperties = System.getProperties();
        String osName = "os.name";
        String newOsName = oldProperties.getProperty("os.name") + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        Properties newProps = new Properties();
        newProps.setProperty("os.name", newOsName);
        System.setProperties(newProps);
        try {
            Assert.assertEquals((String)"Changed properties not detected", (Object)newOsName, (Object)sysLookup.lookup("os.name"));
        }
        finally {
            System.setProperties(oldProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemPropertiesLookupUpdatedProperty() {
        String osName = "os.name";
        String oldOs = System.getProperty("os.name");
        String newOsName = oldOs + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        System.setProperty("os.name", newOsName);
        try {
            Assert.assertEquals((String)"Changed properties not detected", (Object)newOsName, (Object)sysLookup.lookup("os.name"));
        }
        finally {
            System.setProperty("os.name", oldOs);
        }
    }

    @Test
    public void testMapLookup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", "value");
        map.put("number", 2);
        Assert.assertEquals((Object)"value", (Object)StrLookup.mapLookup(map).lookup("key"));
        Assert.assertEquals((Object)"2", (Object)StrLookup.mapLookup(map).lookup("number"));
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup(null));
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup(""));
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup("other"));
    }

    @Test
    public void testResourceBundleLookup() {
        ResourceBundle map = ResourceBundle.getBundle("testResourceBundleLookup");
        Assert.assertEquals((Object)"value", (Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup("key"));
        Assert.assertEquals((Object)"2", (Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup("number"));
        Assert.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup(null));
        Assert.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup(""));
        Assert.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup("other"));
    }

    @Test
    public void testResourceBundleLookup_nullMap() {
        ResourceBundle resourceBundle = null;
        Assert.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).lookup(null));
        Assert.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).lookup(""));
        Assert.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).lookup("any"));
    }

    @Test
    public void testMapLookup_nullMap() {
        Map map = null;
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup(null));
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup(""));
        Assert.assertNull((Object)StrLookup.mapLookup(map).lookup("any"));
    }
}

