/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrTokenizer;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class StrTokenizerTest {
    private static final String CSV_SIMPLE_FIXTURE = "A,b,c";
    private static final String TSV_SIMPLE_FIXTURE = "A\tb\tc";

    private void checkClone(StrTokenizer tokenizer) {
        Assert.assertFalse((StrTokenizer.getCSVInstance() == tokenizer ? 1 : 0) != 0);
        Assert.assertFalse((StrTokenizer.getTSVInstance() == tokenizer ? 1 : 0) != 0);
    }

    @Test
    public void test1() {
        String input = "a;b;c;\"d;\"\"e\";f; ; ;  ";
        StrTokenizer tok = new StrTokenizer("a;b;c;\"d;\"\"e\";f; ; ;  ");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", "", "", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test2() {
        String input = "a;b;c ;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b;c ;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c ", "d;\"e", "f", " ", " ", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test3() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", " ", " ", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test4() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f"};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test5() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", null, null, null};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test6() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", null, null, null};
        int nextCount = 0;
        while (tok.hasNext()) {
            tok.next();
            ++nextCount;
        }
        int prevCount = 0;
        while (tok.hasPrevious()) {
            tok.previous();
            ++prevCount;
        }
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        Assert.assertTrue((String)"could not cycle through entire token list using the 'hasNext' and 'next' methods", (nextCount == expected.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"could not cycle through entire token list using the 'hasPrevious' and 'previous' methods", (prevCount == expected.length ? 1 : 0) != 0);
    }

    @Test
    public void test7() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "", "", "b", "c", "d e", "f", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test8() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d e", "f"};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void testBasic1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic2() {
        String input = "a \nb\fc";
        StrTokenizer tok = new StrTokenizer("a \nb\fc");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic3() {
        String input = "a \nb\u0001\fc";
        StrTokenizer tok = new StrTokenizer("a \nb\u0001\fc");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b\u0001", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic4() {
        String input = "a \"b\" c";
        StrTokenizer tok = new StrTokenizer("a \"b\" c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"\"b\"", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic5() {
        String input = "a:b':c";
        StrTokenizer tok = new StrTokenizer("a:b':c", ':', '\'');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b'", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim1() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer("a:b:c", ':');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim2() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer("a:b:c", ',');
        Assert.assertEquals((Object)"a:b:c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimString() {
        String input = "a##b##c";
        StrTokenizer tok = new StrTokenizer("a##b##c", "##");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcher() {
        String input = "a/b\\c";
        StrMatcher.CharSetMatcher delimMatcher = new StrMatcher.CharSetMatcher(new char[]{'/', '\\'});
        StrTokenizer tok = new StrTokenizer("a/b\\c", (StrMatcher)delimMatcher);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcherQuoteMatcher() {
        String input = "`a`;`b`;`c`";
        StrMatcher.CharSetMatcher delimMatcher = new StrMatcher.CharSetMatcher(new char[]{';'});
        StrMatcher.CharSetMatcher quoteMatcher = new StrMatcher.CharSetMatcher(new char[]{'`'});
        StrTokenizer tok = new StrTokenizer("`a`;`b`;`c`", (StrMatcher)delimMatcher, (StrMatcher)quoteMatcher);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty2() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted1() {
        String input = "a 'b' c";
        StrTokenizer tok = new StrTokenizer("a 'b' c", ' ', '\'');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted2() {
        String input = "a:'b':";
        StrTokenizer tok = new StrTokenizer("a:'b':", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted3() {
        String input = "a:'b''c'";
        StrTokenizer tok = new StrTokenizer("a:'b''c'", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b'c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted4() {
        String input = "a: 'b' 'c' :d";
        StrTokenizer tok = new StrTokenizer("a: 'b' 'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b c", (Object)tok.next());
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted5() {
        String input = "a: 'b'x'c' :d";
        StrTokenizer tok = new StrTokenizer("a: 'b'x'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bxc", (Object)tok.next());
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted6() {
        String input = "a:'b'\"c':d";
        StrTokenizer tok = new StrTokenizer("a:'b'\"c':d", ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b\"c:d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted7() {
        String input = "a:\"There's a reason here\":b";
        StrTokenizer tok = new StrTokenizer("a:\"There's a reason here\":b", ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"There's a reason here", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuotedTrimmed1() {
        String input = "a: 'b' :";
        StrTokenizer tok = new StrTokenizer("a: 'b' :", ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed1() {
        String input = "a: b :  ";
        StrTokenizer tok = new StrTokenizer("a: b :  ", ':');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed2() {
        String input = "a:  b  :";
        StrTokenizer tok = new StrTokenizer("a:  b  :", ':');
        tok.setTrimmerMatcher(StrMatcher.stringMatcher((String)"  "));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed1() {
        String input = "a: bIGNOREc : ";
        StrTokenizer tok = new StrTokenizer("a: bIGNOREc : ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bc", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed2() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bc", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed3() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"  bc  ", (Object)tok.next());
        Assert.assertEquals((Object)"  ", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed4() {
        String input = "IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer("IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ", ':', '\'');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bIGNOREcd", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testListArray() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer("a  b c");
        String[] array = tok.getTokenArray();
        List list = tok.getTokenList();
        Assert.assertEquals(Arrays.asList(array), (Object)list);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    private void testCSV(String data) {
        this.testXSVAbc(StrTokenizer.getCSVInstance((String)data));
        this.testXSVAbc(StrTokenizer.getCSVInstance((char[])data.toCharArray()));
    }

    @Test
    public void testCSVEmpty() {
        this.testEmpty(StrTokenizer.getCSVInstance());
        this.testEmpty(StrTokenizer.getCSVInstance((String)""));
    }

    @Test
    public void testCSVSimple() {
        this.testCSV(CSV_SIMPLE_FIXTURE);
    }

    @Test
    public void testCSVSimpleNeedsTrim() {
        this.testCSV("   A,b,c");
        this.testCSV("   \n\t  A,b,c");
        this.testCSV("   \n  A,b,c\n\n\r");
    }

    void testEmpty(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assert.assertFalse((boolean)tokenizer.hasNext());
        Assert.assertFalse((boolean)tokenizer.hasPrevious());
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertEquals((long)0L, (long)tokenizer.size());
        try {
            tokenizer.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContent() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer("a   b c \"d e\" f ");
        Assert.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StrTokenizer("a   b c \"d e\" f ".toCharArray());
        Assert.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StrTokenizer();
        Assert.assertNull((Object)tok.getContent());
    }

    @Test
    public void testChaining() {
        StrTokenizer tok = new StrTokenizer();
        Assert.assertEquals((Object)tok, (Object)tok.reset());
        Assert.assertEquals((Object)tok, (Object)tok.reset(""));
        Assert.assertEquals((Object)tok, (Object)tok.reset(new char[0]));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterString(" "));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setQuoteChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setQuoteMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoredChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoredMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setTrimmerMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setEmptyTokenAsNull(false));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoreEmptyTokens(false));
    }

    @Test
    public void testCloneNotSupportedException() {
        Object notCloned = new StrTokenizer(){

            Object cloneReset() throws CloneNotSupportedException {
                throw new CloneNotSupportedException("test");
            }
        }.clone();
        Assert.assertNull((Object)notCloned);
    }

    @Test
    public void testCloneNull() {
        StrTokenizer tokenizer = new StrTokenizer((char[])null);
        Assert.assertNull((Object)tokenizer.nextToken());
        tokenizer.reset();
        Assert.assertNull((Object)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        tokenizer.reset();
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertNull((Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testCloneReset() {
        char[] input = new char[]{'a'};
        StrTokenizer tokenizer = new StrTokenizer(input);
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        tokenizer.reset(input);
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        input[0] = 98;
        tokenizer.reset(input);
        Assert.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"a", (Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testConstructor_String() {
        StrTokenizer tok = new StrTokenizer("a b");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("");
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ', '\"');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((long)1L, (long)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0]);
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0], ' ');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ', '\"');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((long)1L, (long)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0], ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset() {
        StrTokenizer tok = new StrTokenizer("a b c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset();
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_String() {
        StrTokenizer tok = new StrTokenizer("x x x");
        tok.reset("d e");
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertEquals((Object)"e", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset((String)null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_charArray() {
        StrTokenizer tok = new StrTokenizer("x x x");
        char[] array = new char[]{'a', 'b', 'c'};
        tok.reset(array);
        Assert.assertEquals((Object)"abc", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset((char[])null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testTSV() {
        this.testXSVAbc(StrTokenizer.getTSVInstance((String)TSV_SIMPLE_FIXTURE));
        this.testXSVAbc(StrTokenizer.getTSVInstance((char[])TSV_SIMPLE_FIXTURE.toCharArray()));
    }

    @Test
    public void testTSVEmpty() {
        this.testEmpty(StrTokenizer.getTSVInstance());
        this.testEmpty(StrTokenizer.getTSVInstance((String)""));
    }

    void testXSVAbc(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assert.assertEquals((long)-1L, (long)tokenizer.previousIndex());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.previousToken());
        Assert.assertEquals((Object)"A", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)1L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)2L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"c", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)3L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertEquals((long)3L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"c", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)2L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"b", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)1L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"A", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.previousToken());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertEquals((long)-1L, (long)tokenizer.previousIndex());
        Assert.assertEquals((long)3L, (long)tokenizer.size());
    }

    @Test
    public void testIteration() {
        StrTokenizer tkn = new StrTokenizer("a b c");
        Assert.assertFalse((boolean)tkn.hasPrevious());
        try {
            tkn.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"a", (Object)tkn.next());
        try {
            tkn.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            tkn.set("x");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            tkn.add("y");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"b", (Object)tkn.next());
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"c", (Object)tkn.next());
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertFalse((boolean)tkn.hasNext());
        try {
            tkn.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertFalse((boolean)tkn.hasNext());
    }

    @Test
    public void testTokenizeSubclassInputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c d e"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                return super.tokenize("w x y z".toCharArray(), 2, 5);
            }
        };
        Assert.assertEquals((Object)"x", (Object)tkn.next());
        Assert.assertEquals((Object)"y", (Object)tkn.next());
    }

    @Test
    public void testTokenizeSubclassOutputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                List list = super.tokenize(chars, offset, count);
                Collections.reverse(list);
                return list;
            }
        };
        Assert.assertEquals((Object)"c", (Object)tkn.next());
        Assert.assertEquals((Object)"b", (Object)tkn.next());
        Assert.assertEquals((Object)"a", (Object)tkn.next());
    }

    @Test
    public void testToString() {
        StrTokenizer tkn = new StrTokenizer("a b c d e");
        Assert.assertEquals((Object)"StrTokenizer[not tokenized yet]", (Object)tkn.toString());
        tkn.next();
        Assert.assertEquals((Object)"StrTokenizer[a, b, c, d, e]", (Object)tkn.toString());
    }

    @Test
    public void testStringTokenizerStringMatcher() {
        char[] chars = new char[]{'a', 'b', 'c', 'd'};
        StrTokenizer tokens = new StrTokenizer(chars, "bc");
        Assert.assertEquals((Object)"a", (Object)tokens.next());
        Assert.assertEquals((Object)"d", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStrMatcher() {
        char[] chars = new char[]{'a', ',', 'c'};
        StrTokenizer tokens = new StrTokenizer(chars, StrMatcher.commaMatcher());
        Assert.assertEquals((Object)"a", (Object)tokens.next());
        Assert.assertEquals((Object)"c", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerQuoteMatcher() {
        char[] chars = new char[]{'\'', 'a', 'c', '\'', 'd'};
        StrTokenizer tokens = new StrTokenizer(chars, StrMatcher.commaMatcher(), StrMatcher.quoteMatcher());
        Assert.assertEquals((Object)"acd", (Object)tokens.next());
    }

    @Test
    public void testPreviousTokenAndSetEmptyTokenAsNull() {
        StrTokenizer strTokenizer = StrTokenizer.getTSVInstance((String)" \t\n\r\f");
        strTokenizer.setEmptyTokenAsNull(true);
        Assert.assertNull((Object)strTokenizer.previousToken());
    }
}

