/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.ReplacementsFinder;
import org.apache.commons.text.diff.ReplacementsHandler;
import org.apache.commons.text.diff.StringsComparator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReplacementsFinderTest {
    private SimpleHandler handler = null;
    private final String left;
    private final String right;
    private final int skipped;
    private final Character[] from;
    private final Character[] to;

    @Before
    public void setUp() {
        this.handler = new SimpleHandler();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"branco", "blanco", 1, new Character[]{Character.valueOf('r')}, new Character[]{Character.valueOf('l')}}, {"test the blocks before you use it", "try the blocks before you put it", 25, new Character[]{Character.valueOf('e'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('s'), Character.valueOf('e')}, new Character[]{Character.valueOf('r'), Character.valueOf('y'), Character.valueOf('p'), Character.valueOf('t')}});
    }

    public ReplacementsFinderTest(String left, String right, int skipped, Character[] from, Character[] to) {
        this.left = left;
        this.right = right;
        this.skipped = skipped;
        this.from = from;
        this.to = to;
    }

    @Test
    public void testReplacementsHandler() {
        StringsComparator sc = new StringsComparator(this.left, this.right);
        ReplacementsFinder replacementFinder = new ReplacementsFinder((ReplacementsHandler)this.handler);
        sc.getScript().visit((CommandVisitor)replacementFinder);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.handler.getSkipped()).as("Skipped characters do not match", new Object[0])).isEqualTo(this.skipped);
        Assert.assertArrayEquals((String)"From characters do not match", (Object[])this.from, (Object[])this.handler.getFrom().toArray(new Character[0]));
        Assert.assertArrayEquals((String)"To characters do not match", (Object[])this.to, (Object[])this.handler.getTo().toArray(new Character[0]));
    }

    private class SimpleHandler
    implements ReplacementsHandler<Character> {
        private int skipped = 0;
        private final List<Character> from = new ArrayList<Character>();
        private final List<Character> to = new ArrayList<Character>();

        SimpleHandler() {
        }

        public int getSkipped() {
            return this.skipped;
        }

        public List<Character> getFrom() {
            return this.from;
        }

        public List<Character> getTo() {
            return this.to;
        }

        public void handleReplacement(int skipped, List<Character> from, List<Character> to) {
            this.skipped += skipped;
            this.from.addAll(from);
            this.to.addAll(to);
        }
    }
}

