/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.HammingDistance;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class HammingDistanceTest {
    private static HammingDistance distance;

    @BeforeClass
    public static void setUp() {
        distance = new HammingDistance();
    }

    @Test
    public void testHammingDistance() {
        Assertions.assertThat((Integer)distance.apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"pappa", (CharSequence)"pappa")).isEqualTo(0);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"papaa", (CharSequence)"pappa")).isEqualTo(1);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"karolin", (CharSequence)"kathrin")).isEqualTo(3);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"karolin", (CharSequence)"kerstin")).isEqualTo(3);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"1011101", (CharSequence)"1001001")).isEqualTo(2);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"2173896", (CharSequence)"2233796")).isEqualTo(3);
        Assertions.assertThat((Integer)distance.apply((CharSequence)"ATCG", (CharSequence)"ACCC")).isEqualTo(2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHammingDistance_nullLeftValue() {
        distance.apply(null, (CharSequence)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHammingDistance_nullRightValue() {
        distance.apply((CharSequence)"", null);
    }
}

