/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashMap;
import org.apache.commons.text.similarity.CosineSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CosineSimilarityTest {
    @Test
    public void testCosineSimilarityWithNonEmptyMap() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer integer = -397;
        hashMap.put("3J/$3.L", integer);
        HashMap hashMapTwo = new HashMap();
        Assertions.assertThat((Double)cosineSimilarity.cosineSimilarity(hashMap, hashMapTwo)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCosineSimilarityThrowsIllegalArgumentException() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        HashMap map = new HashMap();
        cosineSimilarity.cosineSimilarity(map, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCosineSimilarityWithNull() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        cosineSimilarity.cosineSimilarity(null, null);
    }

    @Test
    public void testCosineSimilarityReturningDoubleWhereByteValueIsZero() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        HashMap hashMap = new HashMap();
        Assertions.assertThat((Double)cosineSimilarity.cosineSimilarity(hashMap, hashMap)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }
}

