/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class LongestCommonSubsequenceTest {
    private static LongestCommonSubsequence subject;

    @BeforeClass
    public static void setup() {
        subject = new LongestCommonSubsequence();
    }

    @Test
    public void testLongestCommonSubsequenceApply() {
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"right")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(3);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(1);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo(8);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo(20);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo(24);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo(11);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"right")).isEqualTo(1);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo(4);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo(15);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyNullNull() {
        subject.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyStringNull() {
        subject.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceApplyNullString() {
        subject.apply(null, (CharSequence)"right");
    }

    @Test
    public void testLongestCommonSubsequence() {
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)"right")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog")).isEqualTo((Object)"fog");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo((Object)"h");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo((Object)"ABC Corp");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo((Object)"D  H Enterprises Inc");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo((Object)"My Gym Childrens Fitness");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo((Object)"PENNSYLVNIA");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)"right")).isEqualTo((Object)"t");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo((Object)"tttt");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo((Object)"the same string");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceNullNull() {
        subject.longestCommonSubsequence(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceStringNull() {
        subject.longestCommonSubsequence((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingLongestCommonSubsequenceNullString() {
        subject.longestCommonSubsequence(null, (CharSequence)"right");
    }

    @Test
    @Deprecated
    public void testLogestCommonSubsequence() {
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"right")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog")).isEqualTo((Object)"fog");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo((Object)"h");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo((Object)"ABC Corp");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo((Object)"D  H Enterprises Inc");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo((Object)"My Gym Childrens Fitness");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo((Object)"PENNSYLVNIA");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"right")).isEqualTo((Object)"t");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo((Object)"tttt");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo((Object)"the same string");
    }

    @Test(expected=IllegalArgumentException.class)
    @Deprecated
    public void testGettingLogestCommonSubsequenceNullNull() {
        subject.logestCommonSubsequence(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    @Deprecated
    public void testGettingLogestCommonSubsequenceStringNull() {
        subject.logestCommonSubsequence((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    @Deprecated
    public void testGettingLogestCommonSubsequenceNullString() {
        subject.logestCommonSubsequence(null, (CharSequence)"right");
    }
}

