/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.SimilarityScore;
import org.apache.commons.text.similarity.SimilarityScoreFrom;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedSimilarityScoreFromTest<R> {
    private final SimilarityScore<R> similarityScore;
    private final CharSequence left;
    private final CharSequence right;
    private final R distance;

    public ParameterizedSimilarityScoreFromTest(SimilarityScore<R> similarityScore, CharSequence left, CharSequence right, R distance) {
        this.similarityScore = similarityScore;
        this.left = left;
        this.right = right;
        this.distance = distance;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({new LevenshteinDistance(), "elephant", "hippo", 7}, {new LevenshteinDistance(), "hippo", "elephant", 7}, {new LevenshteinDistance(), "hippo", "zzzzzzzz", 8}, {new SimilarityScore<Boolean>(){

            public Boolean apply(CharSequence left, CharSequence right) {
                return left == right || left != null && left.equals(right);
            }
        }, "Bob's your uncle.", "Every good boy does fine.", false});
    }

    @Test
    public void test() {
        SimilarityScoreFrom similarityScoreFrom = new SimilarityScoreFrom(this.similarityScore, this.left);
        Assert.assertThat((Object)similarityScoreFrom.apply(this.right), (Matcher)IsEqual.equalTo(this.distance));
    }
}

