/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.UnsupportedEncodingException;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaUnicodeEscaperTest {
    @Test
    public void testBelow() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the below method", new Object[0])).isEqualTo((Object)"\\u0041\\u0044FGZ");
    }

    @Test
    public void testBetween() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the between method", new Object[0])).isEqualTo((Object)"AD\\u0046\\u0047Z");
    }

    @Test
    public void testAbove() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.above((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the above method", new Object[0])).isEqualTo((Object)"ADF\\u0047\\u005A");
    }

    @Test
    public void testToUtf16Escape() throws UnsupportedEncodingException {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String encoding = jue.toUtf16Escape(Integer.parseInt("024B62", 16));
        Assertions.assertThat((String)encoding).isEqualTo((Object)"\\uD852\\uDF62");
    }
}

