/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringEscapeUtilsTest {
    private static final String FOO = "foo";
    private static final String[][] HTML_ESCAPES = new String[][]{{"no escaping", "plain text", "plain text"}, {"no escaping", "plain text", "plain text"}, {"empty string", "", ""}, {"null", null, null}, {"ampersand", "bread &amp; butter", "bread & butter"}, {"quotes", "&quot;bread&quot; &amp; butter", "\"bread\" & butter"}, {"final character only", "greater than &gt;", "greater than >"}, {"first character only", "&lt; less than", "< less than"}, {"apostrophe", "Huntington's chorea", "Huntington's chorea"}, {"languages", "English,Fran&ccedil;ais,\u65e5\u672c\u8a9e (nihongo)", "English,Fran\u00e7ais,\u65e5\u672c\u8a9e (nihongo)"}, {"8-bit ascii shouldn't number-escape", "\u0080\u009f", "\u0080\u009f"}};

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new StringEscapeUtils());
        Constructor<?>[] cons = StringEscapeUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(StringEscapeUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(StringEscapeUtils.class.getModifiers()));
    }

    @Test
    public void testEscapeJava() throws IOException {
        Assertions.assertNull((Object)StringEscapeUtils.escapeJava(null));
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate(null, null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)"", null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEscapeJava("", "", "empty string");
        this.assertEscapeJava(FOO, FOO);
        this.assertEscapeJava("\\t", "\t", "tab");
        this.assertEscapeJava("\\\\", "\\", "backslash");
        this.assertEscapeJava("'", "'", "single quote should not be escaped");
        this.assertEscapeJava("\\\\\\b\\t\\r", "\\\b\t\r");
        this.assertEscapeJava("\\u1234", "\u1234");
        this.assertEscapeJava("\\u0234", "\u0234");
        this.assertEscapeJava("\\u00EF", "\u00ef");
        this.assertEscapeJava("\\u0001", "\u0001");
        this.assertEscapeJava("\\uABCD", "\uabcd", "Should use capitalized Unicode hex");
        this.assertEscapeJava("He didn't say, \\\"stop!\\\"", "He didn't say, \"stop!\"");
        this.assertEscapeJava("This space is non-breaking:\\u00A0", "This space is non-breaking:\u00a0", "non-breaking space");
        this.assertEscapeJava("\\uABCD\\u1234\\u012C", "\uabcd\u1234\u012c");
    }

    @Test
    public void testEscapeJavaWithSlash() {
        String input = "String with a slash (/) in it";
        String expected = "String with a slash (/) in it";
        String actual = StringEscapeUtils.escapeJava((String)"String with a slash (/) in it");
        Assertions.assertEquals((Object)"String with a slash (/) in it", (Object)actual);
    }

    private void assertEscapeJava(String escaped, String original) throws IOException {
        this.assertEscapeJava(escaped, original, null);
    }

    private void assertEscapeJava(String expected, String original, String message) throws IOException {
        String converted = StringEscapeUtils.escapeJava((String)original);
        message = "escapeJava(String) failed" + (message == null ? "" : ": " + message);
        Assertions.assertEquals((Object)expected, (Object)converted, (String)message);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    @Test
    public void testUnescapeJava() throws IOException {
        Assertions.assertNull((Object)StringEscapeUtils.unescapeJava(null));
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate(null, null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)"", null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringEscapeUtils.unescapeJava((String)"\\u02-3");
            Assertions.fail((String)"Exception expected!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertUnescapeJava("", "");
        this.assertUnescapeJava("test", "test");
        this.assertUnescapeJava("\ntest\b", "\\ntest\\b");
        this.assertUnescapeJava("\u123425foo\ntest\b", "\\u123425foo\\ntest\\b");
        this.assertUnescapeJava("'\foo\teste\r", "\\'\\foo\\teste\\r");
        this.assertUnescapeJava("", "\\");
        this.assertUnescapeJava("\uabcdx", "\\uabcdx", "lowercase Unicode");
        this.assertUnescapeJava("\uabcdx", "\\uABCDx", "uppercase Unicode");
        this.assertUnescapeJava("\uabcd", "\\uabcd", "Unicode as final character");
    }

    private void assertUnescapeJava(String unescaped, String original) throws IOException {
        this.assertUnescapeJava(unescaped, original, null);
    }

    private void assertUnescapeJava(String unescaped, String original, String message) throws IOException {
        String expected = unescaped;
        String actual = StringEscapeUtils.unescapeJava((String)original);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("unescape(String) failed" + (message == null ? "" : ": " + message) + ": expected '" + StringEscapeUtils.escapeJava((String)expected) + "' actual '" + StringEscapeUtils.escapeJava((String)actual) + "'"));
        StringWriter writer = new StringWriter();
        StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assertions.assertEquals((Object)unescaped, (Object)writer.toString());
    }

    @Test
    public void testEscapeEcmaScript() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeEcmaScript(null));
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate(null, null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate((CharSequence)"", null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"He didn\\'t say, \\\"stop!\\\"", (Object)StringEscapeUtils.escapeEcmaScript((String)"He didn't say, \"stop!\""));
        Assertions.assertEquals((Object)"document.getElementById(\\\"test\\\").value = \\'<script>alert(\\'aaa\\');<\\/script>\\';", (Object)StringEscapeUtils.escapeEcmaScript((String)"document.getElementById(\"test\").value = '<script>alert('aaa');</script>';"));
    }

    @Test
    public void testEscapeHtml3() {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[1];
            String original = element[2];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.escapeHtml4((String)original), (String)message);
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.ESCAPE_HTML3.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
    }

    @Test
    public void testUnescapeHtml3() {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[2];
            String original = element[1];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.unescapeHtml3((String)original), (String)message);
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.UNESCAPE_HTML3.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
        Assertions.assertEquals((Object)"Fran\u00e7ais", (Object)StringEscapeUtils.unescapeHtml3((String)"Fran\u00e7ais"), (String)"funny chars pass through OK");
        Assertions.assertEquals((Object)"Hello&;World", (Object)StringEscapeUtils.unescapeHtml3((String)"Hello&;World"));
        Assertions.assertEquals((Object)"Hello&#;World", (Object)StringEscapeUtils.unescapeHtml3((String)"Hello&#;World"));
        Assertions.assertEquals((Object)"Hello&# ;World", (Object)StringEscapeUtils.unescapeHtml3((String)"Hello&# ;World"));
        Assertions.assertEquals((Object)"Hello&##;World", (Object)StringEscapeUtils.unescapeHtml3((String)"Hello&##;World"));
    }

    @Test
    public void testEscapeHtml4() {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[1];
            String original = element[2];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.escapeHtml4((String)original), (String)message);
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
    }

    @Test
    public void testUnescapeHtml4() {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[2];
            String original = element[1];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)original), (String)message);
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.UNESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
        Assertions.assertEquals((Object)"Fran\u00e7ais", (Object)StringEscapeUtils.unescapeHtml4((String)"Fran\u00e7ais"), (String)"funny chars pass through OK");
        Assertions.assertEquals((Object)"Hello&;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&;World"));
        Assertions.assertEquals((Object)"Hello&#;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&#;World"));
        Assertions.assertEquals((Object)"Hello&# ;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&# ;World"));
        Assertions.assertEquals((Object)"Hello&##;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&##;World"));
    }

    @Test
    public void testUnescapeHexCharsHtml() {
        Assertions.assertEquals((Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#x80;&#x9F;"), (String)"hex number unescape");
        Assertions.assertEquals((Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#X80;&#X9F;"), (String)"hex number unescape");
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            Character c1 = Character.valueOf(i);
            Character c2 = Character.valueOf((char)(i + '\u0001'));
            String expected = c1.toString() + c2.toString();
            String escapedC1 = "&#x" + Integer.toHexString(c1.charValue()) + ";";
            String escapedC2 = "&#x" + Integer.toHexString(c2.charValue()) + ";";
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)(escapedC1 + escapedC2)), (String)("hex number unescape index " + i));
        }
    }

    @Test
    public void testUnescapeUnknownEntity() {
        Assertions.assertEquals((Object)"&zzzz;", (Object)StringEscapeUtils.unescapeHtml4((String)"&zzzz;"));
    }

    @Test
    public void testEscapeHtmlVersions() {
        Assertions.assertEquals((Object)"&Beta;", (Object)StringEscapeUtils.escapeHtml4((String)"\u0392"));
        Assertions.assertEquals((Object)"\u0392", (Object)StringEscapeUtils.unescapeHtml4((String)"&Beta;"));
    }

    @Test
    public void testEscapeXml10() {
        Assertions.assertEquals((Object)"a&lt;b&gt;c&quot;d&apos;e&amp;f", (Object)StringEscapeUtils.escapeXml10((String)"a<b>c\"d'e&f"));
        Assertions.assertEquals((Object)"a\tb\rc\nd", (Object)StringEscapeUtils.escapeXml10((String)"a\tb\rc\nd"), (String)"XML 1.0 should not escape \t \n \r");
        Assertions.assertEquals((Object)"ab", (Object)StringEscapeUtils.escapeXml10((String)"a\u0000\u0001\b\u000b\f\u000e\u001fb"), (String)"XML 1.0 should omit most #x0-x8 | #xb | #xc | #xe-#x19");
        Assertions.assertEquals((Object)"a\ud7ff  \ue000b", (Object)StringEscapeUtils.escapeXml10((String)"a\ud7ff\ud800 \udfff \ue000b"), (String)"XML 1.0 should omit #xd800-#xdfff");
        Assertions.assertEquals((Object)"a\ufffdb", (Object)StringEscapeUtils.escapeXml10((String)"a\ufffd\ufffe\uffffb"), (String)"XML 1.0 should omit #xfffe | #xffff");
        Assertions.assertEquals((Object)"a~&#127;&#132;\u0085&#134;&#159;\u00a0b", (Object)StringEscapeUtils.escapeXml10((String)"a~\u007f\u0084\u0085\u0086\u009f\u00a0b"), (String)"XML 1.0 should escape #x7f-#x84 | #x86 - #x9f, for XML 1.1 compatibility");
    }

    @Test
    public void testEscapeXml11() {
        Assertions.assertEquals((Object)"a&lt;b&gt;c&quot;d&apos;e&amp;f", (Object)StringEscapeUtils.escapeXml11((String)"a<b>c\"d'e&f"));
        Assertions.assertEquals((Object)"a\tb\rc\nd", (Object)StringEscapeUtils.escapeXml11((String)"a\tb\rc\nd"), (String)"XML 1.1 should not escape \t \n \r");
        Assertions.assertEquals((Object)"ab", (Object)StringEscapeUtils.escapeXml11((String)"a\u0000b"), (String)"XML 1.1 should omit #x0");
        Assertions.assertEquals((Object)"a&#1;&#8;&#11;&#12;&#14;&#31;b", (Object)StringEscapeUtils.escapeXml11((String)"a\u0001\b\u000b\f\u000e\u001fb"), (String)"XML 1.1 should escape #x1-x8 | #xb | #xc | #xe-#x19");
        Assertions.assertEquals((Object)"a~&#127;&#132;\u0085&#134;&#159;\u00a0b", (Object)StringEscapeUtils.escapeXml11((String)"a~\u007f\u0084\u0085\u0086\u009f\u00a0b"), (String)"XML 1.1 should escape #x7F-#x84 | #x86-#x9F");
        Assertions.assertEquals((Object)"a\ud7ff  \ue000b", (Object)StringEscapeUtils.escapeXml11((String)"a\ud7ff\ud800 \udfff \ue000b"), (String)"XML 1.1 should omit #xd800-#xdfff");
        Assertions.assertEquals((Object)"a\ufffdb", (Object)StringEscapeUtils.escapeXml11((String)"a\ufffd\ufffe\uffffb"), (String)"XML 1.1 should omit #xfffe | #xffff");
    }

    @Test
    public void testUnescapeXmlSupplementaryCharacters() {
        Assertions.assertEquals((Object)"\ud84c\udfb4", (Object)StringEscapeUtils.unescapeXml((String)"&#144308;"), (String)"Supplementary character must be represented using a single escape");
        Assertions.assertEquals((Object)"a b c \ud84c\udfb4", (Object)StringEscapeUtils.unescapeXml((String)"a b c &#144308;"), (String)"Supplementary characters mixed with basic characters should be decoded correctly");
    }

    @Test
    public void testStandaloneAmphersand() {
        Assertions.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeHtml4((String)"&lt;P&O&gt;"));
        Assertions.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeHtml4((String)"test & &lt;"));
        Assertions.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeXml((String)"&lt;P&O&gt;"));
        Assertions.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeXml((String)"test & &lt;"));
    }

    @Test
    public void testLang313() {
        Assertions.assertEquals((Object)"& &", (Object)StringEscapeUtils.unescapeHtml4((String)"& &amp;"));
    }

    @Test
    public void testEscapeCsvString() {
        Assertions.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.escapeCsv((String)"foo.bar"));
        Assertions.assertEquals((Object)"\"foo,bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo,bar"));
        Assertions.assertEquals((Object)"\"foo\nbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\nbar"));
        Assertions.assertEquals((Object)"\"foo\rbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\rbar"));
        Assertions.assertEquals((Object)"\"foo\"\"bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\"bar"));
        Assertions.assertEquals((Object)"foo\ud84c\udfb4bar", (Object)StringEscapeUtils.escapeCsv((String)"foo\ud84c\udfb4bar"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.escapeCsv((String)""));
        Assertions.assertNull((Object)StringEscapeUtils.escapeCsv(null));
    }

    @Test
    public void testEscapeCsvWriter() {
        this.checkCsvEscapeWriter("foo.bar", "foo.bar");
        this.checkCsvEscapeWriter("\"foo,bar\"", "foo,bar");
        this.checkCsvEscapeWriter("\"foo\nbar\"", "foo\nbar");
        this.checkCsvEscapeWriter("\"foo\rbar\"", "foo\rbar");
        this.checkCsvEscapeWriter("\"foo\"\"bar\"", "foo\"bar");
        this.checkCsvEscapeWriter("foo\ud84c\udfb4bar", "foo\ud84c\udfb4bar");
        this.checkCsvEscapeWriter("", null);
        this.checkCsvEscapeWriter("", "");
    }

    private void checkCsvEscapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            Assertions.assertEquals((Object)expected, (Object)writer.toString());
        }
        catch (IOException e) {
            Assertions.fail((String)("Threw: " + e));
        }
    }

    @Test
    public void testUnescapeCsvString() {
        Assertions.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.unescapeCsv((String)"foo.bar"));
        Assertions.assertEquals((Object)"foo,bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo,bar\""));
        Assertions.assertEquals((Object)"foo\nbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\nbar\""));
        Assertions.assertEquals((Object)"foo\rbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\rbar\""));
        Assertions.assertEquals((Object)"foo\"bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\"\"bar\""));
        Assertions.assertEquals((Object)"foo\ud84c\udfb4bar", (Object)StringEscapeUtils.unescapeCsv((String)"foo\ud84c\udfb4bar"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.unescapeCsv((String)""));
        Assertions.assertNull((Object)StringEscapeUtils.unescapeCsv(null));
        Assertions.assertEquals((Object)"\"foo.bar\"", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo.bar\""));
    }

    @Test
    public void testUnescapeCsvWriter() {
        this.checkCsvUnescapeWriter("foo.bar", "foo.bar");
        this.checkCsvUnescapeWriter("foo,bar", "\"foo,bar\"");
        this.checkCsvUnescapeWriter("foo\nbar", "\"foo\nbar\"");
        this.checkCsvUnescapeWriter("foo\rbar", "\"foo\rbar\"");
        this.checkCsvUnescapeWriter("foo\"bar", "\"foo\"\"bar\"");
        this.checkCsvUnescapeWriter("foo\ud84c\udfb4bar", "foo\ud84c\udfb4bar");
        this.checkCsvUnescapeWriter("", null);
        this.checkCsvUnescapeWriter("", "");
        this.checkCsvUnescapeWriter("\"foo.bar\"", "\"foo.bar\"");
    }

    private void checkCsvUnescapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.UNESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            Assertions.assertEquals((Object)expected, (Object)writer.toString());
        }
        catch (IOException e) {
            Assertions.fail((String)("Threw: " + e));
        }
    }

    @Test
    public void testEscapeHtmlHighUnicode() {
        byte[] data = new byte[]{-16, -99, -115, -94};
        String original = new String(data, Charset.forName("UTF8"));
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        Assertions.assertEquals((Object)original, (Object)escaped, (String)"High Unicode should not have been escaped");
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assertions.assertEquals((Object)original, (Object)unescaped, (String)"High Unicode should have been unchanged");
    }

    @Test
    public void testEscapeHiragana() {
        String original = "\u304b\u304c\u3068";
        String escaped = StringEscapeUtils.escapeHtml4((String)"\u304b\u304c\u3068");
        Assertions.assertEquals((Object)"\u304b\u304c\u3068", (Object)escaped, (String)"Hiragana character Unicode behaviour should not be being escaped by escapeHtml4");
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assertions.assertEquals((Object)escaped, (Object)unescaped, (String)"Hiragana character Unicode behaviour has changed - expected no unescaping");
    }

    @Test
    public void testLang708() throws IOException {
        byte[] inputBytes = Files.readAllBytes(Paths.get("src/test/resources/stringEscapeUtilsTestData.txt", new String[0]));
        String input = new String(inputBytes, StandardCharsets.UTF_8);
        String escaped = StringEscapeUtils.escapeEcmaScript((String)input);
        Assertions.assertTrue((boolean)escaped.endsWith("}]"), (String)escaped);
        Assertions.assertTrue((boolean)escaped.endsWith("\"valueCode\\\":\\\"\\\"}]"), (String)escaped);
    }

    @Test
    public void testLang911() {
        String bellsTest = "\ud83d\udc80\ud83d\udd14";
        String value = StringEscapeUtils.escapeJava((String)"\ud83d\udc80\ud83d\udd14");
        String valueTest = StringEscapeUtils.unescapeJava((String)value);
        Assertions.assertEquals((Object)"\ud83d\udc80\ud83d\udd14", (Object)valueTest);
    }

    @Test
    public void testEscapeJson() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeJson(null));
        try {
            StringEscapeUtils.ESCAPE_JSON.translate(null, null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_JSON.translate((CharSequence)"", null);
            Assertions.fail((String)"Exception expected!");
        }
        catch (IOException ex) {
            Assertions.fail((String)"Exception expected!");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"He didn't say, \\\"stop!\\\"", (Object)StringEscapeUtils.escapeJson((String)"He didn't say, \"stop!\""));
        String expected = "\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/";
        String input = "\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/";
        Assertions.assertEquals((Object)"\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/", (Object)StringEscapeUtils.escapeJson((String)"\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/"));
    }

    @Test
    public void testBuilder() {
        String result = StringEscapeUtils.builder((CharSequenceTranslator)StringEscapeUtils.ESCAPE_XML10).escape("<").append(">").toString();
        Assertions.assertEquals((Object)"&lt;>", (Object)result);
    }

    @Test
    public void testEscapeXSI() {
        Assertions.assertNull(null, (String)StringEscapeUtils.escapeXSI(null));
        Assertions.assertEquals((Object)"He\\ didn\\'t\\ say,\\ \\\"Stop!\\\"", (Object)StringEscapeUtils.escapeXSI((String)"He didn't say, \"Stop!\""));
        Assertions.assertEquals((Object)"\\\\", (Object)StringEscapeUtils.escapeXSI((String)"\\"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.escapeXSI((String)"\n"));
    }

    @Test
    public void testUnscapeXSI() {
        Assertions.assertNull(null, (String)StringEscapeUtils.unescapeXSI(null));
        Assertions.assertEquals((Object)"\"", (Object)StringEscapeUtils.unescapeXSI((String)"\\\""));
        Assertions.assertEquals((Object)"He didn't say, \"Stop!\"", (Object)StringEscapeUtils.unescapeXSI((String)"He\\ didn\\'t\\ say,\\ \\\"Stop!\\\""));
        Assertions.assertEquals((Object)"\\", (Object)StringEscapeUtils.unescapeXSI((String)"\\\\"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.unescapeXSI((String)"\\"));
    }

    @Test
    public void testUnescapeEcmaScript() {
        Assertions.assertNull((Object)StringEscapeUtils.unescapeEcmaScript(null));
        Assertions.assertEquals((Object)"8lvc1u+6B#-I", (Object)StringEscapeUtils.unescapeEcmaScript((String)"8lvc1u+6B#-I"));
        Assertions.assertEquals((Object)"<script src=\"build/main.bundle.js\"></script>", (Object)StringEscapeUtils.unescapeEcmaScript((String)"<script src=\"build/main.bundle.js\"></script>"));
        Assertions.assertEquals((Object)"<script src=\"build/main.bundle.js\"></script>>", (Object)StringEscapeUtils.unescapeEcmaScript((String)"<script src=\"build/main.bundle.js\"></script>>"));
    }

    @Test
    public void testEscapeHtmlThree() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeHtml3(null));
        Assertions.assertEquals((Object)"a", (Object)StringEscapeUtils.escapeHtml3((String)"a"));
        Assertions.assertEquals((Object)"&lt;b&gt;a", (Object)StringEscapeUtils.escapeHtml3((String)"<b>a"));
    }

    @Test
    public void testUnescapeJson() {
        String jsonString = "{\"age\":100,\"name\":\"kyong.com\n\",\"messages\":[\"msg 1\",\"msg 2\",\"msg 3\"]}";
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.unescapeJson((String)""));
        Assertions.assertEquals((Object)" ", (Object)StringEscapeUtils.unescapeJson((String)" "));
        Assertions.assertEquals((Object)"a:b", (Object)StringEscapeUtils.unescapeJson((String)"a:b"));
        Assertions.assertEquals((Object)"{\"age\":100,\"name\":\"kyong.com\n\",\"messages\":[\"msg 1\",\"msg 2\",\"msg 3\"]}", (Object)StringEscapeUtils.unescapeJson((String)"{\"age\":100,\"name\":\"kyong.com\n\",\"messages\":[\"msg 1\",\"msg 2\",\"msg 3\"]}"));
    }

    @Test
    public void testUnescapeJsonDoubleQuoteAndForwardSlash() {
        String escapedJsonString = "double quote: \\\" and a forward slash: \\/";
        String jsonString = "double quote: \" and a forward slash: /";
        Assertions.assertEquals((Object)"double quote: \" and a forward slash: /", (Object)StringEscapeUtils.unescapeJson((String)"double quote: \\\" and a forward slash: \\/"));
    }

    @Test
    public void testDeleteCharacter() {
        String deleteString = "Delete: \u007f";
        Assertions.assertEquals((Object)"Delete: \\u007F", (Object)StringEscapeUtils.escapeJson((String)"Delete: \u007f"));
    }
}

