/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.text.lookup.UrlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlStringLookupTest {
    @Test
    public void testBadCharsetName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.lookup("BAD_CHARSET_NAME:BAD_URL"));
    }

    @Test
    public void testBadUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.lookup("UTF-8:BAD_URL"));
    }

    @Test
    public void testFileScheme() throws Exception {
        Path path = Paths.get("src/test/resources/document.properties", new String[0]);
        URI uri = path.toUri();
        System.out.println(uri);
        byte[] expectedBytes = Files.readAllBytes(path);
        String expectedString = new String(expectedBytes, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expectedString, (Object)UrlStringLookup.INSTANCE.lookup("UTF-8:" + uri.toString()));
    }

    @Test
    public void testHttpScheme() throws Exception {
        Assertions.assertNotNull((Object)UrlStringLookup.INSTANCE.lookup("UTF-8:http://www.google.com"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)UrlStringLookup.INSTANCE.lookup(null));
    }
}

