/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaroWinklerDistanceTest {
    private static JaroWinklerDistance distance;

    @BeforeAll
    public static void setUp() {
        distance = new JaroWinklerDistance();
    }

    @Test
    public void testGetJaroWinklerDistance_StringString() {
        org.junit.jupiter.api.Assertions.assertEquals((double)0.92499, (double)distance.apply((CharSequence)"frog", (CharSequence)"fog"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)distance.apply((CharSequence)"fly", (CharSequence)"ant"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.44166, (double)distance.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.90666, (double)distance.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.95251, (double)distance.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.942, (double)distance.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.898018, (double)distance.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.971428, (double)distance.apply((CharSequence)"/opt/software1", (CharSequence)"/opt/software2"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.941666, (double)distance.apply((CharSequence)"aaabcd", (CharSequence)"aaacdb"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.911111, (double)distance.apply((CharSequence)"John Horn", (CharSequence)"John Hopkins"), (double)1.0E-5);
    }

    @Test
    public void testGetJaroWinklerDistance_NullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distance.apply(null, null));
    }

    @Test
    public void testGetJaroWinklerDistance_StringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distance.apply((CharSequence)" ", null));
    }

    @Test
    public void testGetJaroWinklerDistance_NullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> distance.apply(null, (CharSequence)"clear"));
    }
}

