/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSubstitutorWithInterpolatorStringLookupTest {
    @Test
    public void testCustomMapWithDefaults() {
        this.testCustomMapWithDefaults(true);
    }

    private void testCustomMapWithDefaults(boolean addDefaultLookups) {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.mapStringLookup(map);
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        stringLookupMap.put("customLookup", mapStringLookup);
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(stringLookupMap, null, addDefaultLookups));
        if (addDefaultLookups) {
            String spKey = "user.name";
            Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        }
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${customLookup:key}"));
    }

    @Test
    public void testCustomMapWithoutDefaults() {
        this.testCustomMapWithDefaults(false);
    }

    @Test
    public void testDefaultValueForMissingKeyInResourceBundle() {
        StringLookup interpolatorStringLookup = StringLookupFactory.INSTANCE.interpolatorStringLookup(StringLookupFactory.INSTANCE.resourceBundleStringLookup("testResourceBundleLookup"));
        Assertions.assertEquals((Object)"${missingKey:-defaultValue}", (Object)interpolatorStringLookup.lookup("keyWithMissingKey"));
        StringSubstitutor stringSubstitutor = new StringSubstitutor(interpolatorStringLookup);
        Assertions.assertEquals((Object)"defaultValue", (Object)stringSubstitutor.replace("${keyWithMissingKey}"));
    }

    @Test
    public void testLocalHostLookup_Address() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)strSubst.replace("${localhost:address}"));
    }

    @Test
    public void testLocalHostLookup_CanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)strSubst.replace("${localhost:canonical-name}"));
    }

    @Test
    public void testLocalHostLookup_Name() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)strSubst.replace("${localhost:name}"));
    }

    @Test
    public void testMapAndSystemProperty() {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${key}"));
    }

    @Test
    public void testSystemProperty() {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
    }
}

