/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StringSubstitutorTest {
    private Map<String, String> values;

    private void doTestNoReplace(String replaceTemplate) {
        StringSubstitutor sub = new StringSubstitutor(this.values);
        if (replaceTemplate == null) {
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((String)null));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((String)null, 0, 100));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((char[])null));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((char[])null, 0, 100));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((StringBuffer)null));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((StringBuffer)null, 0, 100));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((TextStringBuilder)null));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace((TextStringBuilder)null, 0, 100));
            org.junit.jupiter.api.Assertions.assertNull((Object)sub.replace(null));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.replaceIn((StringBuffer)null));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.replaceIn((StringBuffer)null, 0, 100));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.replaceIn((TextStringBuilder)null));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.replaceIn((TextStringBuilder)null, 0, 100));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)replaceTemplate, (Object)sub.replace(replaceTemplate));
            TextStringBuilder bld = new TextStringBuilder(replaceTemplate);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.replaceIn(bld));
            org.junit.jupiter.api.Assertions.assertEquals((Object)replaceTemplate, (Object)bld.toString());
        }
    }

    private void doTestReplace(String expectedResult, String replaceTemplate, boolean substring) {
        StringSubstitutor sub = new StringSubstitutor(this.values);
        this.doTestReplace(sub, expectedResult, replaceTemplate, substring);
    }

    private void doTestReplace(StringSubstitutor sub, String expectedResult, String replaceTemplate, boolean substring) {
        String expectedShortResult = expectedResult.substring(1, expectedResult.length() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(replaceTemplate));
        if (substring) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(replaceTemplate, 1, replaceTemplate.length() - 2));
        }
        char[] chars = replaceTemplate.toCharArray();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(chars));
        if (substring) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(chars, 1, chars.length - 2));
        }
        StringBuffer buf = new StringBuffer(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(buf));
        if (substring) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(buf, 1, buf.length() - 2));
        }
        StringBuilder builder = new StringBuilder(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((CharSequence)builder));
        if (substring) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace((CharSequence)builder, 1, builder.length() - 2));
        }
        TextStringBuilder bld = new TextStringBuilder(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(bld));
        if (substring) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(bld, 1, bld.length() - 2));
        }
        MutableObject obj = new MutableObject((Object)replaceTemplate);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((Object)obj));
        buf = new StringBuffer(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(buf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        if (substring) {
            buf = new StringBuffer(replaceTemplate);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(buf, 1, buf.length() - 2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        }
        builder = new StringBuilder(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(builder));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        if (substring) {
            builder = new StringBuilder(replaceTemplate);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(builder, 1, builder.length() - 2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        }
        bld = new TextStringBuilder(replaceTemplate);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(bld));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        if (substring) {
            bld = new TextStringBuilder(replaceTemplate);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.replaceIn(bld, 1, bld.length() - 2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.values = new HashMap<String, String>();
        this.values.put("animal", "quick brown fox");
        this.values.put("target", "lazy dog");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.values = null;
    }

    @Test
    public void testGetSetEscape() {
        StringSubstitutor sub = new StringSubstitutor();
        org.junit.jupiter.api.Assertions.assertEquals((char)'$', (char)sub.getEscapeChar());
        sub.setEscapeChar('<');
        org.junit.jupiter.api.Assertions.assertEquals((char)'<', (char)sub.getEscapeChar());
    }

    @Test
    public void testLANG1055() {
        System.setProperty("test_key", "test_value");
        String expected = StringSubstitutor.replace((Object)"test_key=${test_key}", (Properties)System.getProperties());
        String actual = StringSubstitutor.replaceSystemProperties((Object)"test_key=${test_key}");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReplaceAdjacentAtEnd() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Amount is GBP12.50", (Object)sub.replace("Amount is ${code}${amount}"));
    }

    @Test
    public void testReplaceAdjacentAtStart() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GBP12.50 charged", (Object)sub.replace("${code}${amount} charged"));
    }

    @Test
    public void testReplaceChangedMap() {
        StringSubstitutor sub = new StringSubstitutor(this.values);
        this.values.put("target", "moon");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The quick brown fox jumps over the moon.", (Object)sub.replace("The ${animal} jumps over the ${target}."));
    }

    @Test
    public void testReplaceComplexEscaping() {
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog.", "The $${${animal}} jumps over the ${target}.", true);
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog. ${1234567890}.", "The $${${animal}} jumps over the ${target}. $${${undefined.number:-1234567890}}.", true);
    }

    @Test
    public void testReplaceEmpty() {
        this.doTestNoReplace("");
    }

    @Test
    public void testReplaceEmptyKeys() {
        this.doTestReplace("The ${} jumps over the lazy dog.", "The ${} jumps over the ${target}.", true);
        this.doTestReplace("The animal jumps over the lazy dog.", "The ${:-animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceEscaping() {
        this.doTestReplace("The ${animal} jumps over the lazy dog.", "The $${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceIncompletePrefix() {
        this.doTestReplace("The {animal} jumps over the lazy dog.", "The {animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceInTakingStringBufferWithNonNull() {
        StringSubstitutor strSubstitutor = new StringSubstitutor(new HashMap(), "WV@i#y?N*[", "WV@i#y?N*[", '*');
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.replaceIn(new StringBuffer("WV@i#y?N*[")));
        org.junit.jupiter.api.Assertions.assertEquals((char)'*', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    public void testReplaceInTakingStringBuilderWithNonNull() {
        StringLookup strLookup = StringLookupFactory.INSTANCE.systemPropertyStringLookup();
        StringSubstitutor strSubstitutor = new StringSubstitutor(strLookup, "b<H", "b<H", '\'');
        StringBuilder stringBuilder = new StringBuilder((CharSequence)"b<H");
        org.junit.jupiter.api.Assertions.assertEquals((char)'\'', (char)strSubstitutor.getEscapeChar());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.replaceIn(stringBuilder));
    }

    @Test
    public void testReplaceInTakingStringBuilderWithNull() {
        HashMap map = new HashMap();
        StringSubstitutor strSubstitutor = new StringSubstitutor(map, "", "", 'T', "K+<'f");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null));
    }

    @Test
    public void testReplaceInTakingTwoAndThreeIntsReturningFalse() {
        HashMap hashMap = new HashMap();
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.mapStringLookup(hashMap);
        StringMatcher strMatcher = StringMatcherFactory.INSTANCE.tabMatcher();
        StringSubstitutor strSubstitutor = new StringSubstitutor(mapStringLookup, strMatcher, strMatcher, 'b', strMatcher);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null, 1315, -1369));
        org.junit.jupiter.api.Assertions.assertEquals((char)'b', (char)strSubstitutor.getEscapeChar());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
    }

    @Test
    public void testReplaceInVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${unknown.animal.${unknown.species:-1}:-fox} jumps over the ${unknow.target:-lazy dog}."));
    }

    @Test
    public void testReplaceInVariableDisabled() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The ${animal.${species}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The ${animal.${species:-1}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species:-1}} jumps over the ${target}."));
    }

    @Test
    public void testReplaceFailOnUndefinedVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableUndefinedVariableException(true);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> sub.replace("The ${animal.${species}} jumps over the ${target}.")).withMessage("Cannot resolve variable 'animal.${species' (enableSubstitutionInVariables=false).");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> sub.replace("The ${animal.${species:-1}} jumps over the ${target}.")).withMessage("Cannot resolve variable 'animal.${species:-1' (enableSubstitutionInVariables=false).");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> sub.replace("The ${test:-statement} is a sample for missing ${unknown}.")).withMessage("Cannot resolve variable 'unknown' (enableSubstitutionInVariables=false).");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The statement is a sample for missing variable.", (Object)sub.replace("The ${test:-statement} is a sample for missing ${unknown:-variable}."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.1} jumps over the ${target}."));
    }

    @Test
    public void testReplaceFailOnUndefinedVariableWithReplaceInVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        this.values.put("statement.1", "2");
        this.values.put("recursive", "1");
        this.values.put("word", "variable");
        this.values.put("testok.2", "statement");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableUndefinedVariableException(true);
        sub.setEnableSubstitutionInVariables(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> sub.replace("The ${test.${statement}} is a sample for missing ${word}.")).withMessage("Cannot resolve variable 'statement' (enableSubstitutionInVariables=true).");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> sub.replace("The ${test.${statement.${recursive}}} is a sample for missing ${word}.")).withMessage("Cannot resolve variable 'test.2' (enableSubstitutionInVariables=true).");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The statement is a sample for missing variable.", (Object)sub.replace("The ${testok.${statement.${recursive}}} is a sample for missing ${word}."));
    }

    @Test
    public void testReplaceInVariableRecursive() {
        this.values.put("animal.2", "brown fox");
        this.values.put("animal.1", "white mouse");
        this.values.put("color", "white");
        this.values.put("species.white", "1");
        this.values.put("species.brown", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The white mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${color}}} jumps over the ${target}."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The brown fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${unknownColor:-brown}}} jumps over the ${target}."));
    }

    @Test
    public void testReplaceNoPrefixNoSuffix() {
        this.doTestReplace("The animal jumps over the lazy dog.", "The animal jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceNoPrefixSuffix() {
        this.doTestReplace("The animal} jumps over the lazy dog.", "The animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceNoVariables() {
        this.doTestNoReplace("The balloon arrived.");
    }

    @Test
    public void testReplaceNull() {
        this.doTestNoReplace(null);
    }

    @Test
    public void testReplacePartialString_noReplace() {
        StringSubstitutor sub = new StringSubstitutor();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"${animal} jumps", (Object)sub.replace("The ${animal} jumps over the ${target}.", 4, 15));
    }

    @Test
    public void testReplacePrefixNoSuffix() {
        this.doTestReplace("The ${animal jumps over the ${target} lazy dog.", "The ${animal jumps over the ${target} ${target}.", true);
    }

    @Test
    public void testReplaceRecursive() {
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
        this.values.put("pet", "${petCharacteristicUnknown:-lazy} dog");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceSimple() {
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceSolo() {
        this.doTestReplace("quick brown fox", "${animal}", false);
    }

    @Test
    public void testReplaceSoloEscaping() {
        this.doTestReplace("${animal}", "$${animal}", false);
    }

    @Test
    public void testReplaceTakingCharSequenceReturningNull() {
        StringSubstitutor strSubstitutor = new StringSubstitutor((StringLookup)null);
        org.junit.jupiter.api.Assertions.assertNull((Object)strSubstitutor.replace((CharSequence)null));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        org.junit.jupiter.api.Assertions.assertEquals((char)'$', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    public void testReplaceTakingThreeArgumentsThrowsNullPointerException() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> StringSubstitutor.replace(null, (Properties)null));
    }

    @Test
    public void testReplaceToIdentical() {
        this.values.put("animal", "$${${thing}}");
        this.values.put("thing", "animal");
        this.doTestReplace("The ${animal} jumps.", "The ${animal} jumps.", true);
    }

    @Test
    public void testReplaceUnknownKey() {
        this.doTestReplace("The ${person} jumps over the lazy dog.", "The ${person} jumps over the ${target}.", true);
        this.doTestReplace("The ${person} jumps over the lazy dog. 1234567890.", "The ${person} jumps over the ${target}. ${undefined.number:-1234567890}.", true);
    }

    @Test
    public void testReplaceWeirdPattens() {
        this.doTestNoReplace("");
        this.doTestNoReplace("${}");
        this.doTestNoReplace("${ }");
        this.doTestNoReplace("${\t}");
        this.doTestNoReplace("${\n}");
        this.doTestNoReplace("${\b}");
        this.doTestNoReplace("${");
        this.doTestNoReplace("$}");
        this.doTestNoReplace("}");
        this.doTestNoReplace("${}$");
        this.doTestNoReplace("${${");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${$${}}");
        this.doTestNoReplace("${$$${}}");
        this.doTestNoReplace("${$$${$}}");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${${ }}");
    }

    @Test
    public void testResolveVariable() {
        final TextStringBuilder builder = new TextStringBuilder("Hi ${name}!");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StringSubstitutor sub = new StringSubstitutor(map){

            protected String resolveVariable(String variableName, TextStringBuilder buf, int startPos, int endPos) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)variableName);
                org.junit.jupiter.api.Assertions.assertSame((Object)builder, (Object)buf);
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)startPos);
                org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)endPos);
                return "jakarta";
            }
        };
        sub.replaceIn(builder);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi jakarta!", (Object)builder.toString());
    }

    @Test
    public void testSamePrefixAndSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("greeting", "Hello");
        map.put(" there ", "XXX");
        map.put("name", "commons");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi commons!", (Object)StringSubstitutor.replace((Object)"Hi @name@!", map, (String)"@", (String)"@"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello there commons!", (Object)StringSubstitutor.replace((Object)"@greeting@ there @name@!", map, (String)"@", (String)"@"));
    }

    @Test
    public void testStaticReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi commons!", (Object)StringSubstitutor.replace((Object)"Hi ${name}!", map));
    }

    @Test
    public void testStaticReplacePrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi commons!", (Object)StringSubstitutor.replace((Object)"Hi <name>!", map, (String)"<", (String)">"));
    }

    @Test
    public void testStaticReplaceSystemProperties() {
        TextStringBuilder buf = new TextStringBuilder();
        buf.append("Hi ").append(System.getProperty("user.name"));
        buf.append(", you are working with ");
        buf.append(System.getProperty("os.name"));
        buf.append(", your home directory is ");
        buf.append(System.getProperty("user.home")).append('.');
        org.junit.jupiter.api.Assertions.assertEquals((Object)buf.toString(), (Object)StringSubstitutor.replaceSystemProperties((Object)"Hi ${user.name}, you are working with ${os.name}, your home directory is ${user.home}."));
    }

    @Test
    public void testSubstituteDefaultProperties() {
        String org = "${doesnotwork}";
        System.setProperty("doesnotwork", "It works!");
        Properties props = new Properties(System.getProperties());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"It works!", (Object)StringSubstitutor.replace((Object)"${doesnotwork}", (Properties)props));
    }

    @Test
    public void testSubstitutePreserveEscape() {
        String org = "${not-escaped} $${escaped}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("not-escaped", "value");
        StringSubstitutor sub = new StringSubstitutor(map, "${", "}", '$');
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sub.isPreserveEscapes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value ${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
        sub.setPreserveEscapes(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sub.isPreserveEscapes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value $${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
    }
}

