/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.commons.text.TextRandomProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomStringGeneratorTest {
    private static final CharacterPredicate A_FILTER = new CharacterPredicate(){

        public boolean test(int codePoint) {
            return codePoint == 97;
        }
    };
    private static final CharacterPredicate B_FILTER = new CharacterPredicate(){

        public boolean test(int codePoint) {
            return codePoint == 98;
        }
    };

    @Test
    public void testInvalidLength() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
            generator.generate(-1);
        });
    }

    @Test
    public void testGenerateMinMaxLengthInvalidLength() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
            generator.generate(-1, 0);
        });
    }

    @Test
    public void testGenerateMinMaxLengthMinGreaterThanMax() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
            generator.generate(1, 0);
        });
    }

    private static int codePointLength(String s) {
        return s.codePointCount(0, s.length());
    }

    @Test
    public void testSetLength() {
        int length = 99;
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        String str = generator.generate(99);
        Assertions.assertThat((int)RandomStringGeneratorTest.codePointLength(str)).isEqualTo(99);
    }

    @Test
    public void testGenerateMinMaxLength() {
        boolean minLength = false;
        int maxLength = 3;
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        String str = generator.generate(0, 3);
        Assertions.assertThat((int)RandomStringGeneratorTest.codePointLength(str)).isBetween(Integer.valueOf(0), Integer.valueOf(3));
    }

    @Test
    public void testBadMinimumCodePoint() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RandomStringGenerator.Builder().withinRange(-1, 1));
    }

    @Test
    public void testBadMaximumCodePoint() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RandomStringGenerator.Builder().withinRange(0, 0x110000));
    }

    @Test
    public void testWithinRange() {
        int codePoint;
        int length = 5000;
        int minimumCodePoint = 97;
        int maximumCodePoint = 122;
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange(97, 122).build();
        String str = generator.generate(5000);
        int i = 0;
        do {
            Assertions.assertThat(((codePoint = str.codePointAt(i)) >= 97 && codePoint <= 122 ? 1 : 0) != 0).isTrue();
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testWithinMultipleRanges() {
        int codePoint;
        int length = 5000;
        char[][] pairs = new char[][]{{'a', 'z'}, {'0', '9'}};
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange((char[][])pairs).build();
        String str = generator.generate(5000);
        int minimumCodePoint = 0;
        int maximumCodePoint = 0;
        for (char[] pair : pairs) {
            minimumCodePoint = Math.min(minimumCodePoint, pair[0]);
            maximumCodePoint = Math.max(maximumCodePoint, pair[1]);
        }
        int i = 0;
        do {
            Assertions.assertThat(((codePoint = str.codePointAt(i)) >= minimumCodePoint && codePoint <= maximumCodePoint ? 1 : 0) != 0).isTrue();
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testNoLoneSurrogates() {
        int length = 5000;
        String str = new RandomStringGenerator.Builder().build().generate(5000);
        char lastChar = str.charAt(0);
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLowSurrogate(c)) {
                Assertions.assertThat((boolean)Character.isHighSurrogate(lastChar)).isTrue();
            }
            if (Character.isHighSurrogate(lastChar)) {
                Assertions.assertThat((boolean)Character.isLowSurrogate(c)).isTrue();
            }
            if (Character.isHighSurrogate(c)) {
                Assertions.assertThat((i + 1 < str.length() ? 1 : 0) != 0).isTrue();
            }
            lastChar = c;
        }
    }

    @Test
    public void testUsingRandom() {
        int testChar = 97;
        TextRandomProvider testRandom = new TextRandomProvider(){

            public int nextInt(int n) {
                return 97;
            }
        };
        String str = new RandomStringGenerator.Builder().usingRandom(testRandom).build().generate(10);
        for (char c : str.toCharArray()) {
            Assertions.assertThat((char)c).isEqualTo('a');
        }
    }

    @Test
    public void testMultipleFilters() {
        String str = new RandomStringGenerator.Builder().withinRange(97, 100).filteredBy(new CharacterPredicate[]{A_FILTER, B_FILTER}).build().generate(5000);
        boolean aFound = false;
        boolean bFound = false;
        for (char c : str.toCharArray()) {
            if (c == 'a') {
                aFound = true;
                continue;
            }
            if (c == 'b') {
                bFound = true;
                continue;
            }
            Assertions.fail((String)"Invalid character");
        }
        Assertions.assertThat((aFound && bFound ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testNoPrivateCharacters() {
        int codePoint;
        int startOfPrivateBMPChars = 57344;
        String str = new RandomStringGenerator.Builder().withinRange(57344, 65535).build().generate(5000);
        int i = 0;
        do {
            Assertions.assertThat((Character.getType(codePoint = str.codePointAt(i)) == 18 ? 1 : 0) != 0).isFalse();
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testBadMinAndMax() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RandomStringGenerator.Builder().withinRange(2, 1));
    }

    @Test
    public void testRemoveFilters() {
        RandomStringGenerator.Builder builder = new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        builder.filteredBy(new CharacterPredicate[0]);
        String str = builder.build().generate(100);
        for (char c : str.toCharArray()) {
            if (c == 'a') continue;
            return;
        }
        Assertions.fail((String)"Filter appears to have remained in place");
    }

    @Test
    public void testChangeOfFilter() {
        RandomStringGenerator.Builder builder = new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        String str = builder.filteredBy(new CharacterPredicate[]{B_FILTER}).build().generate(100);
        for (char c : str.toCharArray()) {
            Assertions.assertThat((c == 'b' ? 1 : 0) != 0).isTrue();
        }
    }

    @Test
    public void testZeroLength() {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().build();
        Assertions.assertThat((String)generator.generate(0)).isEqualTo("");
    }

    @Test
    public void testSelectFromCharArray() {
        String str = "abc";
        char[] charArray = "abc".toCharArray();
        RandomStringGenerator generator = new RandomStringGenerator.Builder().selectFrom(charArray).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertThat(("abc".indexOf(c) != -1 ? 1 : 0) != 0).isTrue();
        }
    }

    @Test
    public void testSelectFromCharVarargs() {
        String str = "abc";
        RandomStringGenerator generator = new RandomStringGenerator.Builder().selectFrom(new char[]{'a', 'b', 'c'}).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertThat(("abc".indexOf(c) != -1 ? 1 : 0) != 0).isTrue();
        }
    }

    @Test
    public void testGenerateTakingIntThrowsNullPointerException() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> {
            RandomStringGenerator.Builder randomStringGeneratorBuilder = new RandomStringGenerator.Builder();
            CharacterPredicate[] characterPredicateArray = new CharacterPredicate[2];
            randomStringGeneratorBuilder.filteredBy(characterPredicateArray);
            RandomStringGenerator randomStringGenerator = randomStringGeneratorBuilder.build();
            randomStringGenerator.generate(18);
        });
    }
}

