/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.text.lookup.DnsStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsStringLookupTest {
    @Test
    public void testAddressFromHostAddress() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getHostAddress(), (Object)DnsStringLookup.INSTANCE.lookup("address|" + localHost.getHostAddress()));
    }

    @Test
    public void testAddressFromHostName() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getHostAddress(), (Object)DnsStringLookup.INSTANCE.lookup("address|" + localHost.getHostName()));
    }

    @Test
    public void testCanonicalNameFromHostAddress() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getCanonicalHostName(), (Object)DnsStringLookup.INSTANCE.lookup("canonical-name|" + localHost.getHostAddress()));
    }

    @Test
    public void testCanonicalNameFromHostName() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getCanonicalHostName(), (Object)DnsStringLookup.INSTANCE.lookup("canonical-name|" + localHost.getHostName()));
    }

    @Test
    public void testName() throws UnknownHostException {
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress[] localHostAll = InetAddress.getAllByName(address);
        boolean matched = false;
        for (InetAddress localHost : localHostAll) {
            if (!localHost.getHostName().equals(DnsStringLookup.INSTANCE.lookup("name|" + address + ""))) continue;
            matched = true;
        }
        Assertions.assertTrue((boolean)matched);
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)DnsStringLookup.INSTANCE.lookup(null));
    }
}

