/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.PropertiesStringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesStringLookupTest {
    private static final String DOC_PATH = "src/test/resources/document.properties";
    private static final String KEY = "mykey";
    private static final String KEY_PATH = "src/test/resources/document.properties::mykey";

    @Test
    public void testInterpolator() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:src/test/resources/document.properties::mykey}"));
    }

    @Test
    public void testInterpolatorNestedColon() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/src/test/resources/document.properties::mykey}");
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/src/test/resources/document.properties::mykey}"), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testInterpolatorWithParameterizedKey() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:src/test/resources/document.properties::${KeyIsHere}}");
        Assertions.assertEquals((Object)"${properties:src/test/resources/document.properties::mykey}", (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testInterpolatorWithParameterizedKey2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/src/test/resources/document.properties::${KeyIsHere}}");
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/" + DOC_PATH + "::mykey}"), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)PropertiesStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        Assertions.assertEquals((Object)"Hello World!", (Object)PropertiesStringLookup.INSTANCE.lookup(KEY_PATH));
    }
}

