/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StrBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class StrBuilderAppendInsertTest {
    private static final String SEP = System.lineSeparator();
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    @Test
    public void testAppend_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.append(true);
        Assertions.assertThat((String)sb.toString()).isEqualTo("true");
        sb.append(false);
        Assertions.assertThat((String)sb.toString()).isEqualTo("truefalse");
        sb.append('!');
        Assertions.assertThat((String)sb.toString()).isEqualTo("truefalse!");
    }

    @Test
    public void testAppend_CharArray() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append(new char[]{'f', 'o', 'o'});
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
    }

    @Test
    public void testAppend_CharArray_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_FormattedString() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hi", (Object[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("Hi");
        sb = new StrBuilder();
        sb.append("Hi", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo("Hi");
        sb = new StrBuilder();
        sb.append("Hi %s", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo("Hi Alice");
        sb = new StrBuilder();
        sb.append("Hi %s %,d", new Object[]{"Alice", 5000});
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        String expected = "Hi Alice 5" + groupingSeparator + "000";
        Assertions.assertThat((String)sb.toString()).isEqualTo(expected);
    }

    @Test
    public void testAppend_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendNull();
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuffer("baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobaz");
        sb.append(new StrBuilder("yes"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobazyes");
        sb.append((CharSequence)"Seq");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobazyesSeq");
        sb.append(new StringBuilder("bld"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobazyesSeqbld");
    }

    @Test
    public void testAppend_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.append(0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("0");
        sb.append(1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo("01");
        sb.append(2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo("012.3");
        sb.append(4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo("012.34.5");
    }

    @Test
    public void testAppend_StrBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StrBuilder(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StrBuilder("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_StrBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        try {
            sb.append(new StrBuilder("bar"), -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StrBuilder("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StrBuilder("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_String() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append("");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append("bar");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_String_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append("foo", 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        try {
            sb.append("bar", -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append("bar", 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("bar", 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append("abcbardef", 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
        sb.append((CharSequence)"abcbardef", 4, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarard");
    }

    @Test
    public void testAppend_StringBuffer() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuffer(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuffer("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_StringBuffer_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        try {
            sb.append(new StringBuffer("bar"), -1, 1);
            Assertions.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 3, 1);
            Assertions.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, -1);
            Assertions.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, 3);
            Assertions.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), -1, 3);
            Assertions.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 4, 0);
            Assertions.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuffer("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_StringBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuilder(""));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuilder("bar"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
    }

    @Test
    public void testAppend_StringBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        try {
            sb.append(new StringBuilder("bar"), -1, 1);
            Assertions.fail((String)"append(StringBuilder, -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 3, 1);
            Assertions.fail((String)"append(StringBuilder, 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, -1);
            Assertions.fail((String)"append(StringBuilder,, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 1, 3);
            Assertions.fail((String)"append(StringBuilder, 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), -1, 3);
            Assertions.fail((String)"append(StringBuilder, -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            sb.append(new StringBuilder("bar"), 4, 0);
            Assertions.fail((String)"append(StringBuilder, 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuilder("bar"), 3, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.append(new StringBuilder("abcbardef"), 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobar");
        sb.append(new StringBuilder("abcbardef"), 4, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarard");
    }

    @Test
    public void testAppendAll_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Object[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll(new Object[0]);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
    }

    @Test
    public void testAppendAll_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterable)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
    }

    @Test
    public void testAppendAll_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterator)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
    }

    @Test
    public void testAppendFixedWidthPadLeft() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("o");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("oo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("-foo");
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo("-------foo");
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("-null");
    }

    @Test
    public void testAppendFixedWidthPadLeft_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("3");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("23");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("123");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("-123");
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo("-------123");
    }

    @Test
    public void testAppendFixedWidthPadRight() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("f");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("fo");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo-");
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo-------");
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("null-");
    }

    @Test
    public void testAppendFixedWidthPadRight_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("1");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("12");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("123");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("123-");
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(10);
        Assertions.assertThat((String)sb.toString()).isEqualTo("123-------");
    }

    @Test
    public void testAppendln_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(true);
        Assertions.assertThat((String)sb.toString()).isEqualTo("true" + SEP);
        sb.clear();
        sb.appendln(false);
        Assertions.assertThat((String)sb.toString()).isEqualTo("false" + SEP);
    }

    @Test
    public void testAppendln_CharArray() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(char[] str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray());
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_CharArray_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(char[] str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray(), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_FormattedString() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("Hello %s", new Object[]{"Alice"});
        Assertions.assertThat((String)sb.toString()).isEqualTo("Hello Alice" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(2);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("" + SEP);
        sb.appendln(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo(SEP + "foo" + SEP);
        sb.appendln((Object)6);
        Assertions.assertThat((String)sb.toString()).isEqualTo(SEP + "foo" + SEP + "6" + SEP);
    }

    @Test
    public void testAppendln_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("0" + SEP);
        sb.clear();
        sb.appendln(1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo("1" + SEP);
        sb.clear();
        sb.appendln(2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo("2.3" + SEP);
        sb.clear();
        sb.appendln(4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo("4.5" + SEP);
    }

    @Test
    public void testAppendln_StrBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StrBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StrBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StrBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_String() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(2);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_String_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(String str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo", 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuffer() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuffer str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuffer_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuffer str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendln_StringBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){
            private static final long serialVersionUID = 1L;

            public StrBuilder append(StringBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"), 0, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo" + SEP);
        Assertions.assertThat((int)count[0]).isEqualTo(1);
        Assertions.assertThat((int)count[1]).isEqualTo(1);
    }

    @Test
    public void testAppendNewLine() {
        StrBuilder sb = new StrBuilder("---");
        sb.appendNewLine().append("+++");
        Assertions.assertThat((String)sb.toString()).isEqualTo("---" + SEP + "+++");
        sb = new StrBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        Assertions.assertThat((String)sb.toString()).isEqualTo("---#" + SEP);
    }

    @Test
    public void testAppendPadding() {
        StrBuilder sb = new StrBuilder();
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendPadding(-1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendPadding(0, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendPadding(1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo-");
        sb.appendPadding(16, '-');
        Assertions.assertThat((int)sb.length()).isEqualTo(20);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo-----------------");
    }

    @Test
    public void testAppendSeparator_char() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',');
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendSeparator(',');
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
    }

    @Test
    public void testAppendSeparator_char_char() {
        StrBuilder sb = new StrBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        Assertions.assertThat((String)sb.toString()).isEqualTo(String.valueOf(':'));
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo(String.valueOf(':') + "foo");
        sb.appendSeparator(',', ':');
        Assertions.assertThat((String)sb.toString()).isEqualTo(String.valueOf(':') + "foo" + ',');
    }

    @Test
    public void testAppendSeparator_char_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',', 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendSeparator(',', 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
        sb.appendSeparator(',', -1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
    }

    @Test
    public void testAppendSeparator_String() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendSeparator(",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
    }

    @Test
    public void testAppendSeparator_String_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",", 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo");
        sb.appendSeparator(",", 1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
        sb.appendSeparator(",", -1);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,");
    }

    @Test
    public void testAppendSeparator_String_String() {
        StrBuilder sb = new StrBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.appendSeparator(",", null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.appendSeparator(",", "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo("order by ");
        sb.appendSeparator(null, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("order by ");
        sb.appendSeparator(null, "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo("order by ");
        sb.append("foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("order by foo");
        sb.appendSeparator(",", "order by ");
        Assertions.assertThat((String)sb.toString()).isEqualTo("order by foo,");
    }

    @Test
    public void testAppendWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.appendNull();
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULL");
        sb.append(null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULL");
        sb.append(FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfoo");
        sb.append((String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfooNULL");
        sb.append("");
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfooNULL");
        sb.append("bar");
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfooNULLbar");
        sb.append((StringBuffer)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfooNULLbarNULL");
        sb.append(new StringBuffer("baz"));
        Assertions.assertThat((String)sb.toString()).isEqualTo("NULLNULLfooNULLbarNULLbaz");
    }

    @Test
    public void testAppendWithSeparators_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators(new Object[0], ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,,baz");
    }

    @Test
    public void testAppendWithSeparators_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,,baz");
    }

    @Test
    public void testAppendWithSeparators_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,bar,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,,baz");
    }

    @Test
    public void testAppendWithSeparatorsWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,null,baz");
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foo,null,baz");
    }

    @Test
    public void testInsert() {
        StrBuilder sb = new StrBuilder();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, FOO));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, FOO));
        sb.insert(0, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, "foo"));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, "foo"));
        sb.insert(0, (String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, "foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'f', 'o', 'o'}));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, new char[]{'f', 'o', 'o'}));
        sb.insert(0, (char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, new char[]{'f', 'o', 'o'});
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3));
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, ArrayUtils.EMPTY_CHAR_ARRAY, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10));
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foobarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, true));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, true));
        sb.insert(0, true);
        Assertions.assertThat((String)sb.toString()).isEqualTo("truebarbaz");
        sb.insert(0, false);
        Assertions.assertThat((String)sb.toString()).isEqualTo("falsetruebarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, '!'));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, '!'));
        sb.insert(0, '!');
        Assertions.assertThat((String)sb.toString()).isEqualTo("!barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 0));
        sb.insert(0, '0');
        Assertions.assertThat((String)sb.toString()).isEqualTo("0barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 1L));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 1L));
        sb.insert(0, 1L);
        Assertions.assertThat((String)sb.toString()).isEqualTo("1barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 2.3f));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 2.3f));
        sb.insert(0, 2.3f);
        Assertions.assertThat((String)sb.toString()).isEqualTo("2.3barbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 4.5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 4.5));
        sb.insert(0, 4.5);
        Assertions.assertThat((String)sb.toString()).isEqualTo("4.5barbaz");
    }

    @Test
    public void testInsertWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, FOO));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, FOO));
        sb.insert(0, null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("nullbarbaz");
        sb.insert(0, FOO);
        Assertions.assertThat((String)sb.toString()).isEqualTo("foonullbarbaz");
        sb.clear();
        sb.append("barbaz");
        Assertions.assertThat((String)sb.toString()).isEqualTo("barbaz");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, "foo"));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, "foo"));
        sb.insert(0, (String)null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("nullbarbaz");
        sb.insert(0, "foo");
        Assertions.assertThat((String)sb.toString()).isEqualTo("foonullbarbaz");
        sb.insert(0, (char[])null);
        Assertions.assertThat((String)sb.toString()).isEqualTo("nullfoonullbarbaz");
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertThat((String)sb.toString()).isEqualTo("nullnullfoonullbarbaz");
    }

    @Test
    public void testLang299() {
        StrBuilder sb = new StrBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertThat((String)sb.toString()).isEqualTo("f");
    }
}

