/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSubstitutorWithInterpolatorStringLookupTest {
    @Test
    public void testCustomFunctionWithDefaults() {
        this.testCustomFunctionWithDefaults(true);
    }

    private void testCustomFunctionWithDefaults(boolean addDefaultLookups) {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.functionStringLookup(k -> (String)map.get(k));
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        stringLookupMap.put("customLookup", mapStringLookup);
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(stringLookupMap, null, addDefaultLookups));
        if (addDefaultLookups) {
            String spKey = "user.name";
            Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        }
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${customLookup:key}"));
    }

    @Test
    public void testCustomFunctionWithoutDefaults() {
        this.testCustomFunctionWithDefaults(false);
    }

    @Test
    public void testCustomMapWithDefaults() {
        this.testCustomMapWithDefaults(true);
    }

    private void testCustomMapWithDefaults(boolean addDefaultLookups) {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.mapStringLookup(map);
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        stringLookupMap.put("customLookup", mapStringLookup);
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(stringLookupMap, null, addDefaultLookups));
        if (addDefaultLookups) {
            String spKey = "user.name";
            Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        }
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${customLookup:key}"));
        Assertions.assertEquals((Object)"${UnknownLookup:key}", (Object)strSubst.replace("${UnknownLookup:key}"));
    }

    @Test
    public void testCustomMapWithoutDefaults() {
        this.testCustomMapWithDefaults(false);
    }

    @Test
    public void testDefaultInterpolator() {
        StringSubstitutor interpolator = StringSubstitutor.createInterpolator();
        interpolator.setEnableSubstitutionInVariables(true);
        String text = interpolator.replace("Base64 Decoder:        ${base64Decoder:SGVsbG9Xb3JsZCE=}\nBase64 Encoder:        ${base64Encoder:HelloWorld!}\nJava Constant:         ${const:java.awt.event.KeyEvent.VK_ESCAPE}\nDate:                  ${date:yyyy-MM-dd}\nDNS:                   ${dns:address|apache.org}\nEnvironment Variable:  ${env:USERNAME}\nFile Content:          ${file:UTF-8:src/test/resources/document.properties}\nJava:                  ${java:version}\nLocalhost:             ${localhost:canonical-name}\nProperties File:       ${properties:src/test/resources/document.properties::mykey}\nResource Bundle:       ${resourceBundle:org.example.testResourceBundleLookup:mykey}\nScript:                ${script:javascript:3 + 4}\nSystem Property:       ${sys:user.dir}\nURL Decoder:           ${urlDecoder:Hello%20World%21}\nURL Encoder:           ${urlEncoder:Hello World!}\nURL Content (HTTP):    ${url:UTF-8:http://www.apache.org}\nURL Content (HTTPS):   ${url:UTF-8:https://www.apache.org}\nURL Content (File):    ${url:UTF-8:file:///${sys:user.dir}/src/test/resources/document.properties}\nXML XPath:             ${xml:src/test/resources/document.xml:/root/path/to/node}\n");
        Assertions.assertNotNull((Object)text);
        Assertions.assertFalse((boolean)text.contains("${base64Decoder:SGVsbG9Xb3JsZCE=}"));
        Assertions.assertFalse((boolean)text.contains("${base64Encoder:HelloWorld!}"));
        Assertions.assertFalse((boolean)text.contains("${urlDecoder:Hello%20World%21}"));
        Assertions.assertFalse((boolean)text.contains("${urlEncoder:Hello World!}"));
        Assertions.assertFalse((boolean)text.contains("${resourceBundle:org.example.testResourceBundleLookup:mykey}"));
    }

    @Test
    public void testDefaultValueForMissingKeyInResourceBundle() {
        StringLookup interpolatorStringLookup = StringLookupFactory.INSTANCE.interpolatorStringLookup(StringLookupFactory.INSTANCE.resourceBundleStringLookup("org.example.testResourceBundleLookup"));
        Assertions.assertEquals((Object)"${missingKey:-defaultValue}", (Object)interpolatorStringLookup.lookup("keyWithMissingKey"));
        StringSubstitutor stringSubstitutor = new StringSubstitutor(interpolatorStringLookup);
        Assertions.assertEquals((Object)"defaultValue", (Object)stringSubstitutor.replace("${keyWithMissingKey}"));
    }

    @Test
    public void testDnsLookup() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String hostName = InetAddress.getLocalHost().getHostName();
        Assertions.assertEquals((Object)InetAddress.getByName(hostName).getHostAddress(), (Object)strSubst.replace("${dns:" + hostName + "}"));
    }

    @Test
    public void testDnsLookupAddress() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getByName("apache.org").getHostAddress(), (Object)strSubst.replace("${dns:address|apache.org}"));
    }

    @Test
    public void testDnsLookupCanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getCanonicalHostName(), (Object)strSubst.replace("${dns:canonical-name|" + address + "}"));
    }

    @Test
    public void testDnsLookupName() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getHostName(), (Object)strSubst.replace("${dns:name|" + address + "}"));
    }

    @Test
    public void testDnsLookupNameUntrimmed() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getHostName(), (Object)strSubst.replace("${dns:name| " + address + " }"));
    }

    @Test
    public void testDnsLookupUnknown() {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String unknown = "${dns: u n k n o w n}";
        Assertions.assertEquals((Object)"${dns: u n k n o w n}", (Object)strSubst.replace("${dns: u n k n o w n}"));
    }

    @Test
    public void testJavaScript() {
        Assertions.assertEquals((Object)"Hello World!", (Object)StringSubstitutor.createInterpolator().replace("${script:javascript:\"Hello World!\"}"));
        Assertions.assertEquals((Object)"7", (Object)StringSubstitutor.createInterpolator().replace("${script:javascript:3 + 4}"));
    }

    @Test
    public void testLocalHostLookup_Address() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)strSubst.replace("${localhost:address}"));
    }

    @Test
    public void testLocalHostLookup_CanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)strSubst.replace("${localhost:canonical-name}"));
    }

    @Test
    public void testLocalHostLookup_Name() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)strSubst.replace("${localhost:name}"));
    }

    @Test
    public void testMapAndSystemProperty() {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${key}"));
    }

    @Test
    public void testSystemProperty() {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
    }
}

