/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.ResourceBundle;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ResourceBundleStringLookupTest {
    private static final String KEY = "key";
    private static final String TEST_RESOURCE_BUNDLE = "org.example.testResourceBundleLookup";

    @Test
    public void testAny() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = KEY;
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString(KEY), (Object)ResourceBundleStringLookup.INSTANCE.lookup(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)KEY)));
    }

    @Test
    public void testBadKey() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = "bad_key";
        Assertions.assertNull((Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).lookup("bad_key"));
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)"bad_key")));
    }

    @Test
    public void testBadNames() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup(AbstractStringLookup.toLookupKey((String)"BAD_RESOURCE_BUNDLE_NAME", (String)"KEY")));
    }

    @Test
    public void testDoubleBundle() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).lookup(AbstractStringLookup.toLookupKey((String)"OtherBundle", (String)KEY)));
    }

    @Test
    public void testExceptionGettingString() {
        ResourceBundleStringLookup mockLookup = (ResourceBundleStringLookup)Mockito.spy(ResourceBundleStringLookup.class);
        Mockito.when((Object)mockLookup.getString(TEST_RESOURCE_BUNDLE, KEY)).thenThrow(ClassCastException.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mockLookup.lookup(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)KEY)));
    }

    @Test
    public void testMissingKeyInSpec() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ResourceBundleStringLookup.INSTANCE.lookup("org.example.testResourceBundleLookup:"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString(KEY), (Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).lookup(KEY));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)ResourceBundleStringLookup.INSTANCE.toString().isEmpty());
    }
}

