/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextStringBuilderTest {
    static final StringMatcher A_NUMBER_MATCHER = (buffer, start, bufferStart, bufferEnd) -> {
        if (buffer[start] == 'A' && ++start < bufferEnd && buffer[start] >= '0' && buffer[start] <= '9') {
            return 2;
        }
        return 0;
    };

    @Test
    public void test_LANG_1131_EqualsWithNullTextStringBuilder() throws Exception {
        TextStringBuilder sb = new TextStringBuilder();
        TextStringBuilder other = null;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.equals(other));
    }

    @Test
    public void testAppendCharBuffer() {
        TextStringBuilder sb1 = new TextStringBuilder();
        CharBuffer buf = CharBuffer.allocate(10);
        buf.append("0123456789");
        buf.flip();
        sb1.append(buf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0123456789", (Object)sb1.toString());
        TextStringBuilder sb2 = new TextStringBuilder();
        sb2.append(buf, 1, 8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12345678", (Object)sb2.toString());
    }

    @Test
    public void testAppendCharBufferException() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        String text = "Test";
        CharBuffer buffer = CharBuffer.allocate(sb.size() + "Test".length());
        buffer.put("Test");
        buffer.flip();
        try {
            sb.append(buffer, -1, 12);
        }
        catch (StringIndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"startIndex must be valid", (Object)e.getMessage());
        }
        try {
            sb.append(buffer, 0, -1);
        }
        catch (StringIndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"length must be valid", (Object)e.getMessage());
        }
        sb.append(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890Test", (Object)sb.toString());
    }

    @Test
    public void testAppendCharBufferNull() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        CharBuffer buffer = null;
        sb.append(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890", (Object)sb.toString());
        TextStringBuilder sb1 = new TextStringBuilder("1234567890");
        CharBuffer buffer1 = null;
        sb.append(buffer1, 0, 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890", (Object)sb1.toString());
    }

    @Test
    public void testAppendCharSequence() {
        CharSequence obj0 = null;
        TextStringBuilder obj1 = new TextStringBuilder("test1");
        StringBuilder obj2 = new StringBuilder("test2");
        StringBuffer obj3 = new StringBuffer("test3");
        CharBuffer obj4 = CharBuffer.wrap("test4".toCharArray());
        TextStringBuilder sb0 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb0.append(obj0).toString());
        TextStringBuilder sb1 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test1", (Object)sb1.append((CharSequence)obj1).toString());
        TextStringBuilder sb2 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test2", (Object)sb2.append((CharSequence)obj2).toString());
        TextStringBuilder sb3 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test3", (Object)sb3.append((CharSequence)obj3).toString());
        TextStringBuilder sb4 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test4", (Object)sb4.append(obj4).toString());
        TextStringBuilder sb5 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb5.append(obj0, 0, 0).toString());
    }

    @Test
    public void testAppendln() {
        TextStringBuilder sb1 = new TextStringBuilder();
        int ch = 99;
        org.junit.jupiter.api.Assertions.assertEquals((Object)("c" + System.lineSeparator()), (Object)sb1.appendln('c').toString());
    }

    @Test
    public void testAppendStringBuilderNull() {
        TextStringBuilder sb1 = new TextStringBuilder();
        StringBuilder b = null;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb1.append(b).toString());
        TextStringBuilder sb2 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb2.append(b, 0, 0).toString());
    }

    @Test
    public void testAppendTakingTwoIntsWithIndexOutOfBoundsThrowsStringIndexOutOfBoundsExceptionTwo() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> {
            Charset charset = Charset.defaultCharset();
            ByteBuffer byteBuffer = charset.encode("asdf");
            CharBuffer charBuffer = charset.decode(byteBuffer);
            new TextStringBuilder().append(charBuffer, 933, 654);
        });
    }

    @Test
    public void testAppendTakingTwoIntsWithZeroThrowsStringIndexOutOfBoundsException() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> {
            Charset charset = Charset.defaultCharset();
            ByteBuffer byteBuffer = charset.encode("end < start");
            CharBuffer charBuffer = charset.decode(byteBuffer);
            new TextStringBuilder(630).append(charBuffer, 0, 630);
        });
    }

    @Test
    public void testAppendToAppendable() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        StringWriter writer = new StringWriter();
        writer.append("Test");
        sb.appendTo(new Appendable(){

            @Override
            public Appendable append(char c) throws IOException {
                return this;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                return this;
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                return this;
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test", (Object)writer.toString());
    }

    @Test
    public void testAppendToCharBuffer() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        String text = "Test ";
        CharBuffer buffer = CharBuffer.allocate(sb.size() + "Test ".length());
        buffer.put("Test ");
        sb.appendTo((Appendable)buffer);
        buffer.flip();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    @Test
    public void testAppendToStringBuffer() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        StringBuffer buffer = new StringBuffer("Test ");
        sb.appendTo((Appendable)buffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)buffer.toString());
    }

    @Test
    public void testAppendToStringBuilder() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        StringBuilder builder = new StringBuilder("Test ");
        sb.appendTo((Appendable)builder);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)builder.toString());
    }

    @Test
    public void testAppendToWriter() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("1234567890");
        StringWriter writer = new StringWriter();
        writer.append("Test ");
        sb.appendTo((Appendable)writer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 1234567890", (Object)writer.toString());
    }

    @Test
    public void testAsBuilder() {
        TextStringBuilder sb = new TextStringBuilder().appendAll((Object[])new String[]{"Lorem", " ", "ipsum", " ", "dolor"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)sb.toString(), (Object)sb.build());
    }

    @Test
    public void testAsReader() throws Exception {
        char[] array2;
        TextStringBuilder sb = new TextStringBuilder("some text");
        try (Reader reader = sb.asReader();){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
            char[] buf = new char[40];
            org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)reader.read(buf));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"some text", (Object)new String(buf, 0, 9));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)reader.read());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.ready());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)reader.skip(2L));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)reader.skip(-1L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.markSupported());
        }
        reader = sb.asReader();
        var3_3 = null;
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)115, (int)reader.read());
            reader.mark(-1);
            array2 = new char[3];
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)reader.read(array2, 0, 3));
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array2[0]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'m', (char)array2[1]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'e', (char)array2[2]);
            reader.reset();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.read(array2, 1, 1));
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array2[0]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)array2[1]);
            org.junit.jupiter.api.Assertions.assertEquals((char)'e', (char)array2[2]);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)reader.skip(2L));
            org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)reader.read());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
            reader.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.ready());
        }
        catch (Throwable array2) {
            var3_3 = array2;
            throw array2;
        }
        finally {
            if (reader != null) {
                if (var3_3 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable array2) {
                        var3_3.addSuppressed(array2);
                    }
                } else {
                    reader.close();
                }
            }
        }
        reader = sb.asReader();
        var3_3 = null;
        try {
            array2 = new char[3];
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(array2, -1, 0));
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(array2, 0, -1));
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(array2, 100, 1));
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(array2, 0, 100));
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(array2, Integer.MAX_VALUE, Integer.MAX_VALUE));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.read(array2, 0, 0));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array2[0]);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array2[1]);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)array2[2]);
            reader.skip(9L);
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)reader.read(array2, 0, 1));
            reader.reset();
            char[] array2 = new char[30];
            org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)reader.read(array2, 0, 30));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var3_3 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testAsTokenizer() throws Exception {
        TextStringBuilder b = new TextStringBuilder();
        b.append("a b ");
        StringTokenizer t = b.asTokenizer();
        String[] tokens1 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tokens1.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens1[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens1[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)t.size());
        b.append("c d ");
        String[] tokens2 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tokens2.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens2[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens2[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)t.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)t.next());
        t.reset();
        String[] tokens3 = t.getTokenArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)tokens3.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)tokens3[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)tokens3[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c", (Object)tokens3[2]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", (Object)tokens3[3]);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)t.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"c", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", (Object)t.next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c d ", (Object)t.getContent());
    }

    @Test
    public void testAsWriter() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("base");
        try (Writer writer = sb.asWriter();){
            writer.write(108);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"basel", (Object)sb.toString());
            writer.write(new char[]{'i', 'n'});
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baselin", (Object)sb.toString());
            writer.write(new char[]{'n', 'e', 'r'}, 1, 2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner", (Object)sb.toString());
            writer.write(" rout");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner rout", (Object)sb.toString());
            writer.write("ping that server", 1, 3);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.flush();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing", (Object)sb.toString());
            writer.write(" hi");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"baseliner routing hi", (Object)sb.toString());
            sb.setLength(4);
            writer.write(100);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"based", (Object)sb.toString());
        }
    }

    @Test
    public void testCapacity() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)sb.getBuffer().length, (int)sb.capacity());
        sb.append("HelloWorldHelloWorldHelloWorldHelloWorld");
        org.junit.jupiter.api.Assertions.assertEquals((int)sb.getBuffer().length, (int)sb.capacity());
    }

    @Test
    public void testCapacityAndLength() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.ensureCapacity(32);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("foo");
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.clear();
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("123456789012345678901234567890123");
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() > 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.ensureCapacity(16);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() > 16 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setLength(-1));
        sb.setLength(33);
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)33, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(16);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 16 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890123456", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(32);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234567890123456\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.setLength(0);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testChaining() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setNewLineText(null));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setNullText(null));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setLength(1));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.setCharAt(0, 'a'));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.ensureCapacity(0));
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.minimizeCapacity());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.clear());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.reverse());
        org.junit.jupiter.api.Assertions.assertSame((Object)sb, (Object)sb.trim());
    }

    @Test
    public void testCharAt() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(-1));
        sb.append("foo");
        org.junit.jupiter.api.Assertions.assertEquals((char)'f', (char)sb.charAt(0));
        org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)sb.charAt(1));
        org.junit.jupiter.api.Assertions.assertEquals((char)'o', (char)sb.charAt(2));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(-1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.charAt(3));
    }

    @Test
    public void testClear() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("Hello");
        sb.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        org.junit.jupiter.api.Assertions.assertTrue((sb.getBuffer().length >= 5 ? 1 : 0) != 0);
    }

    @Test
    public void testConstructorCharSequence() {
        CharBuffer str = CharBuffer.wrap("A");
        int length = str.length();
        TextStringBuilder sb = new TextStringBuilder((CharSequence)str);
        org.junit.jupiter.api.Assertions.assertEquals((int)(32 + length), (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)length, (int)sb.toCharArray().length);
    }

    @Test
    public void testConstructorDefault() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.toCharArray().length);
    }

    @Test
    public void testConstructors() {
        TextStringBuilder sb0 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb0.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb0.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb0.size());
        TextStringBuilder sb1 = new TextStringBuilder(32);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb1.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb1.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb1.size());
        TextStringBuilder sb2 = new TextStringBuilder(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb2.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb2.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb2.size());
        TextStringBuilder sb3 = new TextStringBuilder(-1);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb3.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb3.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb3.size());
        TextStringBuilder sb4 = new TextStringBuilder(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb4.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb4.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb4.size());
        TextStringBuilder sb5 = new TextStringBuilder((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb5.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb5.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb5.size());
        TextStringBuilder sb6 = new TextStringBuilder("");
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)sb6.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb6.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb6.size());
        TextStringBuilder sb7 = new TextStringBuilder("foo");
        org.junit.jupiter.api.Assertions.assertEquals((int)35, (int)sb7.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb7.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb7.size());
    }

    @Test
    public void testConstructorString() {
        String str = "A";
        int length = "A".length();
        TextStringBuilder sb = new TextStringBuilder("A");
        org.junit.jupiter.api.Assertions.assertEquals((int)(32 + length), (int)sb.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)length, (int)sb.toCharArray().length);
    }

    @Test
    public void testContains_char() {
        TextStringBuilder sb = new TextStringBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('a'));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('o'));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains('z'));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains('1'));
    }

    @Test
    public void testContains_String() {
        TextStringBuilder sb = new TextStringBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("pq"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains("z"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains("zyx"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains((String)null));
    }

    @Test
    public void testContains_StringMatcher() {
        TextStringBuilder sb = new TextStringBuilder("abcdefghijklmnopqrstuvwxyz");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StringMatcherFactory.INSTANCE.charMatcher('a')));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StringMatcherFactory.INSTANCE.stringMatcher("pq")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(StringMatcherFactory.INSTANCE.charMatcher('z')));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains(StringMatcherFactory.INSTANCE.stringMatcher("zy")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains((StringMatcher)null));
        sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains(A_NUMBER_MATCHER));
        sb.append("B A1 C");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.contains(A_NUMBER_MATCHER));
    }

    @Test
    public void testDeleteAll_char() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.deleteAll('X');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll('a');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll('c');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteAll('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.deleteAll((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("X");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteAll("a");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.deleteAll("c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbb", (Object)sb.toString());
        sb.deleteAll("b");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.deleteAll("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"acba", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteAll("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteAll_StringMatcher() {
        TextStringBuilder sb = new TextStringBuilder("A0xA1A2yA3");
        sb.deleteAll((StringMatcher)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xy", (Object)sb.toString());
        sb = new TextStringBuilder("Ax1");
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteAll(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteCharAt() {
        String str = "abc";
        TextStringBuilder sb1 = new TextStringBuilder("abc");
        sb1.deleteCharAt(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb1.toString());
        TextStringBuilder sb2 = new TextStringBuilder("abc");
        sb2.deleteCharAt("abc".length() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab", (Object)sb2.toString());
        TextStringBuilder sb3 = new TextStringBuilder("abc");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb3.deleteCharAt("abc".length()));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb3.deleteCharAt(1000));
    }

    @Test
    public void testDeleteCharAtWithNegative() {
        Assertions.assertThatExceptionOfType(StringIndexOutOfBoundsException.class).isThrownBy(() -> new TextStringBuilder().deleteCharAt(-1258));
    }

    @Test
    public void testDeleteFirst_char() {
        TextStringBuilder sb = new TextStringBuilder("abcba");
        sb.deleteFirst('X');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcba", (Object)sb.toString());
        sb.deleteFirst('a');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcba", (Object)sb.toString());
        sb.deleteFirst('c');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bba", (Object)sb.toString());
        sb.deleteFirst('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ba", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteFirst('b');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.deleteFirst((String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("X");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.deleteFirst("a");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.deleteFirst("c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bbccba", (Object)sb.toString());
        sb.deleteFirst("b");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bccba", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.deleteFirst("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abccba", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteFirst("bc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteFirst_StringMatcher() {
        TextStringBuilder sb = new TextStringBuilder("A0xA1A2yA3");
        sb.deleteFirst((StringMatcher)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A0xA1A2yA3", (Object)sb.toString());
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xA1A2yA3", (Object)sb.toString());
        sb = new TextStringBuilder("Ax1");
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ax1", (Object)sb.toString());
        sb = new TextStringBuilder("");
        sb.deleteFirst(A_NUMBER_MATCHER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testDeleteIntInt() {
        TextStringBuilder sb = new TextStringBuilder("abc");
        sb.delete(0, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb.toString());
        sb.delete(1, 2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)sb.toString());
        sb.delete(0, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.delete(0, 1000);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.delete(1, 2));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.delete(-1, 1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> new TextStringBuilder("anything").delete(2, 1));
    }

    @Test
    public void testDrainChar() {
        String str = "abc";
        TextStringBuilder sb1 = new TextStringBuilder("abc");
        org.junit.jupiter.api.Assertions.assertEquals((char)'a', (char)sb1.drainChar(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb1.toString());
        TextStringBuilder sb2 = new TextStringBuilder("abc");
        org.junit.jupiter.api.Assertions.assertEquals((char)'c', (char)sb2.drainChar("abc".length() - 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab", (Object)sb2.toString());
        TextStringBuilder sb3 = new TextStringBuilder("abc");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb3.drainChar("abc".length()));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb3.drainChar(1000));
    }

    @Test
    public void testDrainCharsIntIntCharArrayInt() {
        String data = "junit";
        char[] array = new char["junit".length()];
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.drainChars(0, 5, array, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.drainChars(0, 5, new char[0], 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.drainChars(5, 5, array, 1));
        sb.append("junit");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.drainChars(5, 5, array, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)sb.drainChars(0, 5, array, 0));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])array);
        char[] b = new char[5];
        sb.set((CharSequence)"junit");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.drainChars(0, 2, b, 3));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\u0000', '\u0000', 'j', 'u'}, (char[])b);
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.drainChars(-1, 0, b, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.drainChars(0, -1, array, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.drainChars(4, 2, array, 0));
        sb.set((CharSequence)"junit");
        org.junit.jupiter.api.Assertions.assertEquals((int)"junit".length(), (int)sb.drainChars(0, sb.length() + 1, array, 0));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])array);
        sb.set((CharSequence)"junit");
        org.junit.jupiter.api.Assertions.assertEquals((int)"junit".length(), (int)sb.drainChars(0, sb.length() + 10, array, 0));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])array);
        sb.set((CharSequence)"junit");
        int targetIndex = 1;
        Arrays.fill(array, '-');
        org.junit.jupiter.api.Assertions.assertEquals((int)("junit".length() - targetIndex), (int)sb.drainChars(0, sb.length() + 10, array, targetIndex));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"-juni".toCharArray(), (char[])array);
        sb.set((CharSequence)"junit");
        Arrays.fill(array, '-');
        org.junit.jupiter.api.Assertions.assertEquals((int)("junit".length() - targetIndex), (int)sb.drainChars(0, sb.length() + 1, array, targetIndex));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"-juni".toCharArray(), (char[])array);
        sb.set((CharSequence)"junit");
        targetIndex = 2;
        Arrays.fill(array, '-');
        org.junit.jupiter.api.Assertions.assertEquals((int)("junit".length() - targetIndex), (int)sb.drainChars(0, sb.length() + 1, array, targetIndex));
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"--jun".toCharArray(), (char[])array);
    }

    @Test
    public void testEndsWith() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("a"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("c"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith(""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith(null));
        sb.append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("c"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("bc"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.endsWith("abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("cba"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("abcd"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith(" abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.endsWith("abc "));
    }

    @Test
    public void testEnsureCapacity() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.ensureCapacity(2);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 2 ? 1 : 0) != 0);
        sb.ensureCapacity(-1);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 0 ? 1 : 0) != 0);
        sb.append("HelloWorld");
        sb.ensureCapacity(40);
        org.junit.jupiter.api.Assertions.assertTrue((sb.capacity() >= 40 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        TextStringBuilder sb1 = new TextStringBuilder();
        TextStringBuilder sb2 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equals(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals((Object)sb2));
        sb1.append("abc");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals((Object)sb2));
        sb2.append("ABC");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals((Object)sb2));
        sb2.set((CharSequence)"abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equals((Object)sb2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals((Object)1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equals((Object)"abc"));
    }

    @Test
    public void testEqualsIgnoreCase() {
        TextStringBuilder sb1 = new TextStringBuilder();
        TextStringBuilder sb2 = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb1.append("abc");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.append("ABC");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        sb2.set((CharSequence)"abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb2.equalsIgnoreCase(sb2));
        sb2.set((CharSequence)"aBc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb1.equalsIgnoreCase(sb2));
        Locale turkish = Locale.forLanguageTag("tr");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new TextStringBuilder("title").equalsIgnoreCase(new TextStringBuilder("title".toLowerCase(turkish))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new TextStringBuilder("title").equalsIgnoreCase(new TextStringBuilder("TITLE".toLowerCase(turkish))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new TextStringBuilder("TITLE").equalsIgnoreCase(new TextStringBuilder("TITLE".toLowerCase(turkish))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new TextStringBuilder("TITLE").equalsIgnoreCase(new TextStringBuilder("title".toLowerCase(turkish))));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new TextStringBuilder("TITLE").equalsIgnoreCase(new TextStringBuilder("TITLE".toUpperCase(turkish))));
    }

    @Test
    public void testGetChars() {
        TextStringBuilder sb = new TextStringBuilder();
        char[] input = new char[10];
        char[] a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[10], (char[])a);
        sb.append("junit");
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'j', 'u', 'n', 'i', 't', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, (char[])a);
        a = sb.getChars(null);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)input, (Object)a);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a);
        input = new char[5];
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertSame((Object)input, (Object)a);
        input = new char[4];
        a = sb.getChars(input);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)input, (Object)a);
    }

    @Test
    public void testGetCharsIntIntCharArrayInt() {
        TextStringBuilder sb = new TextStringBuilder();
        char[] array1 = new char[1];
        sb.getChars(0, 0, array1, 0);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[1], (char[])array1);
        sb.set((CharSequence)"junit");
        sb.getChars(0, 1, array1, 0);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'j'}, (char[])array1);
        char[] array = new char[5];
        sb.getChars(0, 5, array, 0);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'j', 'u', 'n', 'i', 't'}, (char[])array);
        char[] b = new char[5];
        sb.getChars(0, 2, b, 3);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\u0000', '\u0000', 'j', 'u'}, (char[])b);
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.getChars(-1, 0, b, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.getChars(0, -1, array, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.getChars(0, 20, array, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.getChars(4, 2, array, 0));
    }

    @Test
    public void testGetSetNewLineText() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNewLineText());
        sb.setNewLineText("#");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"#", (Object)sb.getNewLineText());
        sb.setNewLineText("");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.getNewLineText());
        sb.setNewLineText((String)null);
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNewLineText());
    }

    @Test
    public void testGetSetNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
        sb.setNullText("null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"null", (Object)sb.getNullText());
        sb.setNullText("");
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
        sb.setNullText("NULL");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"NULL", (Object)sb.getNullText());
        sb.setNullText((String)null);
        org.junit.jupiter.api.Assertions.assertNull((Object)sb.getNullText());
    }

    @Test
    public void testHashCode() {
        TextStringBuilder sb = new TextStringBuilder();
        int hc1a = sb.hashCode();
        int hc1b = sb.hashCode();
        int emptyHc = Arrays.hashCode(sb.getBuffer());
        org.junit.jupiter.api.Assertions.assertEquals((int)emptyHc, (int)hc1a);
        org.junit.jupiter.api.Assertions.assertEquals((int)hc1a, (int)hc1b);
        sb.append("abc");
        int hc2a = sb.hashCode();
        int hc2b = sb.hashCode();
        org.junit.jupiter.api.Assertions.assertTrue((hc2a != emptyHc ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)hc2a, (int)hc2b);
    }

    @Test
    public void testIndexOf_char() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(97), (int)sb.indexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(98), (int)sb.indexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z'));
    }

    @Test
    public void testIndexOf_char_int() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a', -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf('a', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('a', 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('a', 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(97, 1), (int)sb.indexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf(98, 2), (int)sb.indexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z', 2));
        sb = new TextStringBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf('z', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('z', 3));
    }

    @Test
    public void testIndexOf_String() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("a"), (int)sb.indexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ab"), (int)sb.indexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("b"), (int)sb.indexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ba"), (int)sb.indexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("z"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((String)null));
    }

    @Test
    public void testIndexOf_String_int() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a", -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("a", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("a", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("a", 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("abcdef", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf("", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("a", 1), (int)sb.indexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ab", 1), (int)sb.indexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("b", 2), (int)sb.indexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf("ba", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".indexOf("ba", 2), (int)sb.indexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("z", 2));
        sb = new TextStringBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf("za", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("za", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((String)null, 2));
    }

    @Test
    public void testIndexOf_StringMatcher() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StringMatcher)null));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a')));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a')));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b')));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('d')));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.noneMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StringMatcher)null));
        sb.append(" A1 junction");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testIndexOf_StringMatcher_int() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StringMatcher)null, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 0));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(StringMatcherFactory.INSTANCE.noneMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf((StringMatcher)null, 0));
        sb.append(" A1 junction with A2");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 22));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 23));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testIndexOfLang294() {
        TextStringBuilder sb = new TextStringBuilder("onetwothree");
        sb.deleteFirst("three");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf("three"));
    }

    @Test
    public void testIsEmpty() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isEmpty());
        sb.clear();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isEmpty());
    }

    @Test
    public void testIsNotEmpty() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isNotEmpty());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.isNotEmpty());
        sb.clear();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.isNotEmpty());
    }

    @Test
    public void testLang294() {
        TextStringBuilder sb = new TextStringBuilder("\n%BLAH%\nDo more stuff\neven more stuff\n%BLAH%\n");
        sb.deleteAll("\n%BLAH%");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\nDo more stuff\neven more stuff\n", (Object)sb.toString());
    }

    @Test
    public void testLang295() {
        TextStringBuilder sb = new TextStringBuilder("onetwothree");
        sb.deleteFirst("three");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.contains('h'), (String)"The contains(char) method is looking beyond the end of the string");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.indexOf('h'), (String)"The indexOf(char) method is looking beyond the end of the string");
    }

    @Test
    public void testLang412Left() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadLeft(null, 10, '*');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"**********", (Object)sb.toString(), (String)"Failed to invoke appendFixedWidthPadLeft correctly");
    }

    @Test
    public void testLang412Right() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadRight(null, 10, '*');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"**********", (Object)sb.toString(), (String)"Failed to invoke appendFixedWidthPadRight correctly");
    }

    @Test
    public void testLastIndexOf_char() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(97), (int)sb.lastIndexOf('a'));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(98), (int)sb.lastIndexOf('b'));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z'));
    }

    @Test
    public void testLastIndexOf_char_int() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('a', -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf('a', 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(97, 1), (int)sb.lastIndexOf('a', 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf(98, 2), (int)sb.lastIndexOf('b', 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z', 2));
        sb = new TextStringBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf('z', sb.length()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf('z', 1));
    }

    @Test
    public void testLastIndexOf_String() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("a"), (int)sb.lastIndexOf("a"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ab"), (int)sb.lastIndexOf("ab"));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("b"), (int)sb.lastIndexOf("b"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ba"), (int)sb.lastIndexOf("ba"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("z"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((String)null));
    }

    @Test
    public void testLastIndexOf_String_int() {
        TextStringBuilder sb = new TextStringBuilder("abab");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("a", -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("a", 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("a", 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("abcdef", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("", 3), (int)sb.lastIndexOf("", 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("", 1), (int)sb.lastIndexOf("", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("a", 1), (int)sb.lastIndexOf("a", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ab", 1), (int)sb.lastIndexOf("ab", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("b", 2), (int)sb.lastIndexOf("b", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)"abab".lastIndexOf("ba", 2), (int)sb.lastIndexOf("ba", 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("z", 2));
        sb = new TextStringBuilder("xyzabc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf("za", sb.length()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf("za", 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((String)null, 2));
    }

    @Test
    public void testLastIndexOf_StringMatcher() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StringMatcher)null));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a')));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a')));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b')));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('d')));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.noneMatcher()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StringMatcher)null));
        sb.append(" A1 junction");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER));
    }

    @Test
    public void testLastIndexOf_StringMatcher_int() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StringMatcher)null, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), -1));
        sb.append("ab bd");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('a'), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), -1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.charMatcher('b'), 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), -2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.spaceMatcher(), 20));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(StringMatcherFactory.INSTANCE.noneMatcher(), 0));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf((StringMatcher)null, 0));
        sb.append(" A1 junction with A2");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 22));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 23));
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 24));
    }

    @Test
    public void testLeftString() {
        TextStringBuilder sb = new TextStringBuilder("left right");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left", (Object)sb.leftString(4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.leftString(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.leftString(-5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left right", (Object)sb.leftString(15));
    }

    @Test
    public void testLength() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.length());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)sb.length());
    }

    @Test
    public void testMidString() {
        TextStringBuilder sb = new TextStringBuilder("hello goodbye hello");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.midString(6, 7));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(-5, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.midString(0, -1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.midString(20, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.midString(14, 22));
    }

    @Test
    public void testMinimizeCapacity() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.capacity());
        sb.append("HelloWorld");
        sb.minimizeCapacity();
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)sb.capacity());
    }

    @Test
    public void testReadFromCharBuffer() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            TextStringBuilder sb = new TextStringBuilder();
            int len = sb.readFrom(CharBuffer.wrap(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromCharBufferAppendsToEnd() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("Test");
        sb.readFrom(CharBuffer.wrap(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReadable() throws Exception {
        String s = "";
        for (int i = 0; i < 100; ++i) {
            TextStringBuilder sb = new TextStringBuilder();
            int len = sb.readFrom((Readable)new MockReadable(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReadableAppendsToEnd() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("Test");
        sb.readFrom((Readable)new MockReadable(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReader() throws Exception {
        String s = "1";
        for (int i = 0; i < 100; ++i) {
            TextStringBuilder sb = new TextStringBuilder();
            int len = sb.readFrom((Reader)new StringReader(s));
            org.junit.jupiter.api.Assertions.assertEquals((int)s.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)sb.toString());
            s = s + Integer.toString(i);
        }
    }

    @Test
    public void testReadFromReaderAppendsToEnd() throws Exception {
        TextStringBuilder sb = new TextStringBuilder("Test");
        sb.readFrom((Reader)new StringReader(" 123"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test 123", (Object)sb.toString());
    }

    @Test
    public void testReadFromReaderEmpty() throws Exception {
        TextStringBuilder sb = new TextStringBuilder();
        int len = sb.readFrom((Reader)new StringReader(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)len);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReadFromReaderInt() throws Exception {
        String str = "";
        for (int i = 0; i < 100; ++i) {
            TextStringBuilder sb = new TextStringBuilder();
            int len = sb.readFrom((Reader)new StringReader(str), str.length());
            org.junit.jupiter.api.Assertions.assertEquals((int)str.length(), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((Object)str, (Object)sb.toString());
            str = str + Integer.toString(i);
        }
        String source = "abc";
        int sourceLen = "abc".length();
        int target = -1;
        TextStringBuilder sb = new TextStringBuilder();
        int count = sb.readFrom((Reader)new StringReader(""), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, 0), (Object)sb.toString());
        target = -1;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, 0), (Object)sb.toString());
        target = 0;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, target), (Object)sb.toString());
        target = 1;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, target), (Object)sb.toString());
        target = 2;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, target), (Object)sb.toString());
        target = 3;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)target, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, target), (Object)sb.toString());
        target = 4;
        sb = new TextStringBuilder();
        count = sb.readFrom((Reader)new StringReader("abc"), target);
        org.junit.jupiter.api.Assertions.assertEquals((int)sourceLen, (int)count);
        org.junit.jupiter.api.Assertions.assertEquals((int)sourceLen, (int)sb.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc".substring(0, sourceLen), (Object)sb.toString());
    }

    @Test
    public void testReadFromReaderIntEmpty() throws Exception {
        TextStringBuilder sb = new TextStringBuilder();
        int len = sb.readFrom((Reader)new StringReader(""), 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)len);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReplace_int_int_String() {
        TextStringBuilder sb = new TextStringBuilder("abc");
        sb.replace(0, 1, "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbc", (Object)sb.toString());
        sb.replace(0, 1, "aaa");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaabc", (Object)sb.toString());
        sb.replace(0, 3, "");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bc", (Object)sb.toString());
        sb.replace(1, 2, (String)null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)sb.toString());
        sb.replace(1, 1000, "text");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"btext", (Object)sb.toString());
        sb.replace(0, 1000, "text");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"text", (Object)sb.toString());
        TextStringBuilder builder = new TextStringBuilder("atext");
        builder.replace(1, 1, "ny");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"anytext", (Object)builder.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(2, 1, "anything"));
        builder.clear();
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(1, 2, "anything"));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(-1, 1, "anything"));
    }

    @Test
    public void testReplace_StringMatcher_String_int_int_int_VaryCount() {
        TextStringBuilder sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, 5);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
    }

    @Test
    public void testReplace_StringMatcher_String_int_int_int_VaryEndIndex() {
        TextStringBuilder sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 0, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 2, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 3, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 4, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-xaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 5, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 6, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x-aayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 7, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 8, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 9, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--yaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 10, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, 1000, -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        TextStringBuilder builder = new TextStringBuilder("aaxaaaayaa");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 2, 1, -1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)builder.toString());
    }

    @Test
    public void testReplace_StringMatcher_String_int_int_int_VaryMatcher() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replace((StringMatcher)null, "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replace(StringMatcherFactory.INSTANCE.charMatcher('a'), "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbcbccbx", (Object)sb.toString());
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "x", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxcxx", (Object)sb.toString());
        sb = new TextStringBuilder("A1-A2A3-A4");
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testReplace_StringMatcher_String_int_int_int_VaryReplace() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "cb", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "-", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab-c-a", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "+++", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ab+++c+++a", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abca", (Object)sb.toString());
        sb = new TextStringBuilder("abcbccba");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("cb"), null, 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abca", (Object)sb.toString());
    }

    @Test
    public void testReplace_StringMatcher_String_int_int_int_VaryStartIndex() {
        TextStringBuilder sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 0, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-x--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 1, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 2, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 3, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aax--y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 4, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxa-ay-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 5, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaa-y-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 6, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 7, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 8, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaay-", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 9, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        sb = new TextStringBuilder("aaxaaaayaa");
        sb.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 10, sb.length(), -1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)sb.toString());
        TextStringBuilder builder = new TextStringBuilder("aaxaaaayaa");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", 11, builder.length(), -1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)builder.toString());
        builder.set((CharSequence)"aaxaaaayaa");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> builder.replace(StringMatcherFactory.INSTANCE.stringMatcher("aa"), "-", -1, builder.length(), -1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aaxaaaayaa", (Object)builder.toString());
    }

    @Test
    public void testReplaceAll_char_char() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceAll('x', 'y');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll('a', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll('b', 'e');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dececced", (Object)sb.toString());
        sb.replaceAll('c', 'f');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defeffed", (Object)sb.toString());
        sb.replaceAll('d', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defeffed", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_String_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceAll((String)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((String)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("", "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("x", "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll("a", "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll("d", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll("cb", "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new TextStringBuilder("abcba");
        sb.replaceAll("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new TextStringBuilder("bb");
        sb.replaceAll("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxxbx", (Object)sb.toString());
    }

    @Test
    public void testReplaceAll_StringMatcher_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceAll((StringMatcher)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll((StringMatcher)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.noneMatcher(), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.noneMatcher(), "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.charMatcher('x'), "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.charMatcher('a'), "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccbd", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.charMatcher('d'), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccb", (Object)sb.toString());
        sb.replaceAll(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-c-", (Object)sb.toString());
        sb = new TextStringBuilder("abcba");
        sb.replaceAll(StringMatcherFactory.INSTANCE.charMatcher('b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcxbxa", (Object)sb.toString());
        sb = new TextStringBuilder("bb");
        sb.replaceAll(StringMatcherFactory.INSTANCE.charMatcher('b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxxbx", (Object)sb.toString());
        sb = new TextStringBuilder("A1-A2A3-A4");
        sb.replaceAll(A_NUMBER_MATCHER, "***");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-******-***", (Object)sb.toString());
        sb = new TextStringBuilder("Dear X, hello X.");
        sb.replaceAll(StringMatcherFactory.INSTANCE.stringMatcher("X"), "012345678901234567");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Dear 012345678901234567, hello 012345678901234567.", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_char_char() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceFirst('x', 'y');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst('a', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst('b', 'e');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"decbccba", (Object)sb.toString());
        sb.replaceFirst('c', 'f');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defbccba", (Object)sb.toString());
        sb.replaceFirst('d', 'd');
        org.junit.jupiter.api.Assertions.assertEquals((Object)"defbccba", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_String_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceFirst((String)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((String)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("", "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("x", "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst("a", "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst("d", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst("cb", "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new TextStringBuilder("abcba");
        sb.replaceFirst("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new TextStringBuilder("bb");
        sb.replaceFirst("b", "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxb", (Object)sb.toString());
    }

    @Test
    public void testReplaceFirst_StringMatcher_String() {
        TextStringBuilder sb = new TextStringBuilder("abcbccba");
        sb.replaceFirst((StringMatcher)null, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst((StringMatcher)null, "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.noneMatcher(), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.noneMatcher(), "anything");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.charMatcher('x'), "y");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.charMatcher('a'), "d");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.charMatcher('d'), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bcbccba", (Object)sb.toString());
        sb.replaceFirst(StringMatcherFactory.INSTANCE.stringMatcher("cb"), "-");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b-ccba", (Object)sb.toString());
        sb = new TextStringBuilder("abcba");
        sb.replaceFirst(StringMatcherFactory.INSTANCE.charMatcher('b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"axbxcba", (Object)sb.toString());
        sb = new TextStringBuilder("bb");
        sb.replaceFirst(StringMatcherFactory.INSTANCE.charMatcher('b'), "xbx");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"xbxb", (Object)sb.toString());
        sb = new TextStringBuilder("A1-A2A3-A4");
        sb.replaceFirst(A_NUMBER_MATCHER, "***");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"***-A2A3-A4", (Object)sb.toString());
    }

    @Test
    public void testReverse() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.clear().append(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eurt", (Object)sb.reverse().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)sb.reverse().toString());
    }

    @Test
    public void testRightString() {
        TextStringBuilder sb = new TextStringBuilder("left right");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"right", (Object)sb.rightString(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.rightString(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.rightString(-5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"left right", (Object)sb.rightString(15));
    }

    @Test
    public void testSetCharAt() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(0, 'f'));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(-1, 'f'));
        sb.append("foo");
        sb.setCharAt(0, 'b');
        sb.setCharAt(1, 'a');
        sb.setCharAt(2, 'r');
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setCharAt(3, '!'));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)sb.toString());
    }

    @Test
    public void testSetLength() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("Hello");
        sb.setLength(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He", (Object)sb.toString());
        sb.setLength(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"He\u0000", (Object)sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.setLength(-1));
    }

    @Test
    public void testSize() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.size());
        sb.append("Hello");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)sb.size());
    }

    @Test
    public void testStartsWith() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith("a"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith(null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith(""));
        sb.append("abc");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("ab"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sb.startsWith("abc"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sb.startsWith("cba"));
    }

    @Test
    public void testSubSequenceIntInt() {
        TextStringBuilder sb = new TextStringBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(2, -1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(2, sb.length() + 1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.subSequence(3, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.subSequence(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".subSequence(0, 6), (Object)sb.subSequence(0, 6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.subSequence(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".subSequence(6, 13), (Object)sb.subSequence(6, 13));
    }

    @Test
    public void testSubstringInt() {
        TextStringBuilder sb = new TextStringBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(6), (Object)sb.substring(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye", (Object)sb.substring(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(0), (Object)sb.substring(0));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(-1));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(15));
    }

    @Test
    public void testSubstringIntInt() {
        TextStringBuilder sb = new TextStringBuilder("hello goodbye");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)sb.substring(0, 5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(0, 6), (Object)sb.substring(0, 6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello goodbye".substring(6, 13), (Object)sb.substring(6, 13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goodbye", (Object)sb.substring(6, 20));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.substring(15, 20));
    }

    @Test
    public void testToCharArray() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.toCharArray().length);
        char[] a = sb.toCharArray();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)a, (String)"toCharArray() result is null");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)a.length, (String)"toCharArray() result is too large");
        sb.append("junit");
        a = sb.toCharArray();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length, (String)"toCharArray() result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a, (String)"toCharArray() result does not match");
    }

    @Test
    public void testToCharArrayIntInt() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)sb.toCharArray(0, 0).length);
        sb.append("junit");
        char[] a = sb.toCharArray(0, 20);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"junit".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"juni".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)a.length, (String)"toCharArray(int,int) result incorrect length");
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])"juni".toCharArray(), (char[])a, (String)"toCharArray(int,int) result does not match");
        a = sb.toCharArray(0, 1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)a, (String)"toCharArray(int,int) result is null");
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.toCharArray(-1, 5));
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.toCharArray(6, 5));
    }

    @Test
    public void testToString() {
        TextStringBuilder sb = new TextStringBuilder("abc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)sb.toString());
    }

    @Test
    public void testToStringBuffer() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StringBuffer().toString(), (Object)sb.toStringBuffer().toString());
        sb.append("junit");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StringBuffer("junit").toString(), (Object)sb.toStringBuffer().toString());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testToStringBuilder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.genStringConcat(StringBuilderRewriter.java:193)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.testAppendChain(StringBuilderRewriter.java:180)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:43)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter.rewriteExpression(StringBuilderRewriter.java:36)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:786)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testTrim() {
        TextStringBuilder sb = new TextStringBuilder();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.reverse().toString());
        sb.set((CharSequence)" \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sb.trim().toString());
        sb.set((CharSequence)" \u0000 a b c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.set((CharSequence)"a b c \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.set((CharSequence)" \u0000 a b c \u0000 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
        sb.set((CharSequence)"a b c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a b c", (Object)sb.trim().toString());
    }

    @Test
    public void testWrap_CharArray() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> TextStringBuilder.wrap(null));
        TextStringBuilder initEmpty = TextStringBuilder.wrap((char[])ArrayUtils.EMPTY_CHAR_ARRAY);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)initEmpty.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)initEmpty.length());
        initEmpty.append('a');
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)initEmpty.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)initEmpty.length());
        char[] test = "abc".toCharArray();
        TextStringBuilder builder = TextStringBuilder.wrap((char[])test);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])test, (char[])builder.getBuffer());
        org.junit.jupiter.api.Assertions.assertEquals((int)test.length, (int)builder.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)test.length, (int)builder.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.isReallocated());
        builder.ensureCapacity(builder.capacity() * 2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Arrays.equals(test, builder.getBuffer()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.isReallocated());
    }

    private void testWrap_CharArray_Int(String test, int expectedLen) {
        char[] input = "abc".toCharArray();
        TextStringBuilder builder = TextStringBuilder.wrap((char[])input, (int)expectedLen);
        org.junit.jupiter.api.Assertions.assertArrayEquals((char[])input, (char[])builder.getBuffer());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedLen, (int)builder.length());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedLen, (int)builder.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.isReallocated());
        builder.ensureCapacity(builder.capacity() * 2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Arrays.equals(input, builder.getBuffer()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.isReallocated());
    }

    @Test
    public void testWrap_CharArray_Int_0() {
        this.testWrap_CharArray_Int("abc", 0);
    }

    @Test
    public void testWrap_CharArray_Int_1() {
        this.testWrap_CharArray_Int("abc", 1);
    }

    @Test
    public void testWrap_CharArray_Int_2() {
        this.testWrap_CharArray_Int("abc", 2);
    }

    @Test
    public void testWrap_CharArray_Int_3() {
        this.testWrap_CharArray_Int("abc", 3);
    }

    @Test
    public void testWrap_CharArray_Int_Empty_0() {
        TextStringBuilder initEmpty = TextStringBuilder.wrap((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)0);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)initEmpty.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)initEmpty.length());
        initEmpty.append('a');
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)initEmpty.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)initEmpty.length());
    }

    @Test
    public void testWrap_CharArray_Int_Exceptions() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> TextStringBuilder.wrap(null, (int)0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> TextStringBuilder.wrap((char[])"abc".toCharArray(), (int)-1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> TextStringBuilder.wrap((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1));
    }

    private static class MockReadable
    implements Readable {
        private final CharBuffer src;

        MockReadable(String src) {
            this.src = CharBuffer.wrap(src);
        }

        @Override
        public int read(CharBuffer cb) throws IOException {
            return this.src.read(cb);
        }
    }
}

