/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LongestCommonSubsequenceDistanceTest {
    private static LongestCommonSubsequenceDistance subject;

    @BeforeAll
    public static void setup() {
        subject = new LongestCommonSubsequenceDistance();
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistance() {
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"")).isEqualTo(4);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"right")).isEqualTo(5);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(1);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(6);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(11);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo(7);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo(4);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo(9);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo(3);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"right")).isEqualTo(7);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo(9);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo(0);
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply(null, (CharSequence)"right"));
    }
}

