/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.UnicodeEscaper;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnicodeEscaperTest {
    @Test
    public void testBelow() {
        UnicodeEscaper ue = UnicodeEscaper.below((int)70);
        String input = "ADFGZ";
        String result = ue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the below method", new Object[0])).isEqualTo("\\u0041\\u0044FGZ");
    }

    @Test
    public void testBetween() {
        UnicodeEscaper ue = UnicodeEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = ue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the between method", new Object[0])).isEqualTo("AD\\u0046\\u0047Z");
    }

    @Test
    public void testAbove() {
        UnicodeEscaper ue = UnicodeEscaper.above((int)70);
        String input = "ADFGZ";
        String result = ue.translate((CharSequence)"ADFGZ");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to escape Unicode characters via the above method", new Object[0])).isEqualTo("ADF\\u0047\\u005A");
    }
}

