/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Status;
import org.apache.commons.transaction.memory.HashMapFactory;
import org.apache.commons.transaction.memory.HashSetFactory;
import org.apache.commons.transaction.memory.MapFactory;
import org.apache.commons.transaction.memory.SetFactory;

public class TransactionalMapWrapper
implements Map,
Status {
    protected Map wrapped;
    protected MapFactory mapFactory;
    protected SetFactory setFactory;
    private ThreadLocal activeTx = new ThreadLocal();

    public TransactionalMapWrapper(Map wrapped) {
        this(wrapped, new HashMapFactory(), new HashSetFactory());
    }

    public TransactionalMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory) {
        this.wrapped = Collections.synchronizedMap(wrapped);
        this.mapFactory = mapFactory;
        this.setFactory = setFactory;
    }

    public boolean isReadOnly() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        return txContext.readOnly;
    }

    public boolean isTransactionMarkedForRollback() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        return txContext.status == 1;
    }

    public void markTransactionForRollback() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        txContext.status = 1;
    }

    public TxContext suspendTransaction() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        txContext.suspended = true;
        this.setActiveTx(null);
        return txContext;
    }

    public void resumeTransaction(TxContext suspendedTx) {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        if (suspendedTx == null) {
            throw new IllegalStateException("No transaction to resume!");
        }
        if (!suspendedTx.suspended) {
            throw new IllegalStateException("Transaction to resume needs to be suspended!");
        }
        suspendedTx.suspended = false;
        this.setActiveTx(suspendedTx);
    }

    public int getTransactionState() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return 6;
        }
        return txContext.status;
    }

    public void startTransaction() {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        this.setActiveTx(new TxContext());
    }

    public void rollbackTransaction() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        txContext.dispose();
        this.setActiveTx(null);
    }

    public void commitTransaction() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        if (txContext.status == 1) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " is marked for rollback!");
        }
        txContext.merge();
        txContext.dispose();
        this.setActiveTx(null);
    }

    public void clear() {
        TxContext txContext = this.getActiveTx();
        if (txContext != null) {
            txContext.clear();
        } else {
            this.wrapped.clear();
        }
    }

    public int size() {
        TxContext txContext = this.getActiveTx();
        if (txContext != null) {
            return txContext.size();
        }
        return this.wrapped.size();
    }

    public boolean isEmpty() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.isEmpty();
        }
        return txContext.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.containsValue(value);
        }
        return this.values().contains(value);
    }

    public Collection values() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.values();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public void putAll(Map map) {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            this.wrapped.putAll(map);
        } else {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                txContext.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Set entrySet() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.entrySet();
        }
        HashSet<HashEntry> entrySet = new HashSet<HashEntry>();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.get(key);
            if (value == null) continue;
            entrySet.add(new HashEntry(key, value));
        }
        return entrySet;
    }

    public Set keySet() {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.keySet();
        }
        return txContext.keys();
    }

    public Object get(Object key) {
        TxContext txContext = this.getActiveTx();
        if (txContext != null) {
            return txContext.get(key);
        }
        return this.wrapped.get(key);
    }

    public Object remove(Object key) {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.remove(key);
        }
        Object oldValue = this.get(key);
        txContext.remove(key);
        return oldValue;
    }

    public Object put(Object key, Object value) {
        TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            return this.wrapped.put(key, value);
        }
        Object oldValue = this.get(key);
        txContext.put(key, value);
        return oldValue;
    }

    protected TxContext getActiveTx() {
        return (TxContext)this.activeTx.get();
    }

    protected void setActiveTx(TxContext txContext) {
        this.activeTx.set(txContext);
    }

    public class TxContext {
        protected Set deletes;
        protected Map changes;
        protected Map adds;
        protected int status;
        protected boolean cleared;
        protected boolean readOnly;
        protected boolean suspended = false;

        protected TxContext() {
            this.deletes = TransactionalMapWrapper.this.setFactory.createSet();
            this.changes = TransactionalMapWrapper.this.mapFactory.createMap();
            this.adds = TransactionalMapWrapper.this.mapFactory.createMap();
            this.status = 0;
            this.cleared = false;
            this.readOnly = true;
        }

        protected Set keys() {
            HashSet keySet = new HashSet();
            if (!this.cleared) {
                keySet.addAll(TransactionalMapWrapper.this.wrapped.keySet());
            }
            keySet.addAll(this.adds.keySet());
            return keySet;
        }

        protected Object get(Object key) {
            if (this.deletes.contains(key)) {
                return null;
            }
            Object changed = this.changes.get(key);
            if (changed != null) {
                return changed;
            }
            Object added = this.adds.get(key);
            if (added != null) {
                return added;
            }
            if (this.cleared) {
                return null;
            }
            return TransactionalMapWrapper.this.wrapped.get(key);
        }

        protected void put(Object key, Object value) {
            try {
                this.readOnly = false;
                this.deletes.remove(key);
                if (TransactionalMapWrapper.this.wrapped.get(key) != null) {
                    this.changes.put(key, value);
                } else {
                    this.adds.put(key, value);
                }
            }
            catch (RuntimeException e) {
                this.status = 1;
                throw e;
            }
            catch (Error e) {
                this.status = 1;
                throw e;
            }
        }

        protected void remove(Object key) {
            try {
                this.readOnly = false;
                this.changes.remove(key);
                this.adds.remove(key);
                if (TransactionalMapWrapper.this.wrapped.containsKey(key) && !this.cleared) {
                    this.deletes.add(key);
                }
            }
            catch (RuntimeException e) {
                this.status = 1;
                throw e;
            }
            catch (Error e) {
                this.status = 1;
                throw e;
            }
        }

        protected int size() {
            int size = this.cleared ? 0 : TransactionalMapWrapper.this.wrapped.size();
            size -= this.deletes.size();
            return size += this.adds.size();
        }

        protected void clear() {
            this.readOnly = false;
            this.cleared = true;
            this.deletes.clear();
            this.changes.clear();
            this.adds.clear();
        }

        protected boolean isEmpty() {
            return this.size() == 0;
        }

        protected void merge() {
            if (!this.readOnly) {
                if (this.cleared) {
                    TransactionalMapWrapper.this.wrapped.clear();
                }
                TransactionalMapWrapper.this.wrapped.putAll(this.changes);
                TransactionalMapWrapper.this.wrapped.putAll(this.adds);
                Iterator it = this.deletes.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    TransactionalMapWrapper.this.wrapped.remove(key);
                }
            }
        }

        protected void dispose() {
            TransactionalMapWrapper.this.setFactory.disposeSet(this.deletes);
            this.deletes = null;
            TransactionalMapWrapper.this.mapFactory.disposeMap(this.changes);
            this.changes = null;
            TransactionalMapWrapper.this.mapFactory.disposeMap(this.adds);
            this.adds = null;
            this.status = 6;
        }
    }

    protected static class HashEntry
    implements Map.Entry {
        protected Object key;
        protected Object value;

        protected HashEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object old = this.value;
            this.value = value;
            return old;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }
}

