/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.locking.MultiLevelLock2;
import org.apache.commons.transaction.util.LoggerFacade;

public class GenericLock
implements MultiLevelLock2 {
    protected Object resourceId;
    protected Map owners = Collections.synchronizedMap(new HashMap());
    protected List waitingOwners = Collections.synchronizedList(new ArrayList());
    private int maxLockLevel;
    protected LoggerFacade logger;
    protected int waiters = 0;

    public GenericLock(Object resourceId, int maxLockLevel, LoggerFacade logger) {
        if (maxLockLevel < 1) {
            throw new IllegalArgumentException("The maximum lock level must be at least 1 (" + maxLockLevel + " was specified)");
        }
        this.resourceId = resourceId;
        this.maxLockLevel = maxLockLevel;
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (o instanceof GenericLock) {
            return ((GenericLock)o).resourceId.equals(this.resourceId);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }

    public boolean test(Object ownerId, int targetLockLevel, int compatibility) {
        boolean success = this.tryLock(ownerId, targetLockLevel, compatibility, false, true);
        return success;
    }

    public boolean has(Object ownerId, int lockLevel) {
        int level = this.getLockLevel(ownerId);
        return lockLevel <= level;
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, boolean reentrant, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, targetLockLevel, wait, reentrant ? 1 : 0, timeoutMSecs);
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, int compatibility, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, targetLockLevel, wait, compatibility, false, timeoutMSecs);
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean preferred, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, targetLockLevel, true, 1, preferred, timeoutMSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, int compatibility, boolean preferred, long timeoutMSecs) throws InterruptedException {
        if (this.logger.isFinerEnabled()) {
            this.logger.logFiner(ownerId.toString() + " trying to acquire lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
        }
        if (this.tryLock(ownerId, targetLockLevel, compatibility, preferred)) {
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner(ownerId.toString() + " actually acquired lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            }
            return true;
        }
        if (!wait) {
            return false;
        }
        long started = System.currentTimeMillis();
        long remaining = timeoutMSecs;
        while (remaining > 0L) {
            block17: {
                if (this.logger.isFinerEnabled()) {
                    this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " for msecs " + timeoutMSecs + " at " + System.currentTimeMillis());
                }
                LockOwner waitingOwner = new LockOwner(ownerId, targetLockLevel, compatibility, preferred);
                try {
                    this.registerWaiter(waitingOwner);
                    if (preferred) {
                        LockOwner oldLock = null;
                        try {
                            oldLock = (LockOwner)this.owners.get(ownerId);
                            this.setLockLevel(ownerId, null, targetLockLevel, compatibility, preferred);
                            this.wait(remaining);
                            break block17;
                        }
                        finally {
                            if (oldLock != null) {
                                this.owners.put(ownerId, oldLock);
                            } else {
                                this.owners.remove(ownerId);
                            }
                        }
                    }
                    this.wait(remaining);
                }
                finally {
                    this.unregisterWaiter(waitingOwner);
                }
            }
            if (this.tryLock(ownerId, targetLockLevel, compatibility, preferred)) {
                if (this.logger.isFinerEnabled()) {
                    this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " eventually got the lock at " + System.currentTimeMillis());
                }
                return true;
            }
            remaining = timeoutMSecs - (System.currentTimeMillis() - started);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWaiter(LockOwner waitingOwner) {
        List list = this.waitingOwners;
        synchronized (list) {
            this.unregisterWaiter(waitingOwner);
            ++this.waiters;
            this.waitingOwners.add(waitingOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterWaiter(LockOwner waitingOwner) {
        List list = this.waitingOwners;
        synchronized (list) {
            if (this.waitingOwners.remove(waitingOwner)) {
                --this.waiters;
            }
        }
    }

    public synchronized boolean release(Object ownerId) {
        if (this.owners.remove(ownerId) != null) {
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner(ownerId.toString() + " releasing lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    public int getLockLevel(Object ownerId) {
        LockOwner owner = (LockOwner)this.owners.get(ownerId);
        if (owner == null) {
            return 0;
        }
        return owner.lockLevel;
    }

    public Object getResourceId() {
        return this.resourceId;
    }

    public int getLevelMinLock() {
        return 0;
    }

    public int getLevelMaxLock() {
        return this.maxLockLevel;
    }

    public Object getOwner() {
        LockOwner owner = this.getMaxLevelOwner();
        if (owner == null) {
            return null;
        }
        return owner.ownerId;
    }

    public synchronized String toString() {
        LockOwner owner;
        StringBuffer buf = new StringBuffer();
        buf.append(this.resourceId.toString()).append(":\n");
        Iterator<Object> it = this.owners.values().iterator();
        while (it.hasNext()) {
            owner = (LockOwner)it.next();
            buf.append("- ").append(owner.toString()).append("\n");
        }
        if (this.waiters != 0) {
            buf.append(this.waiters).append(" waiting:\n");
            it = this.waitingOwners.iterator();
            while (it.hasNext()) {
                owner = (LockOwner)it.next();
                buf.append("- ").append(owner.toString()).append("\n");
            }
        }
        return buf.toString();
    }

    protected synchronized LockOwner getMaxLevelOwner() {
        return this.getMaxLevelOwner(null, -1, false);
    }

    protected synchronized LockOwner getMaxLevelOwner(LockOwner reentrantOwner, boolean preferred) {
        return this.getMaxLevelOwner(reentrantOwner, -1, preferred);
    }

    protected synchronized LockOwner getMaxLevelOwner(int supportLockLevel, boolean preferred) {
        return this.getMaxLevelOwner(null, supportLockLevel, preferred);
    }

    protected synchronized LockOwner getMaxLevelOwner(LockOwner reentrantOwner, int supportLockLevel, boolean preferred) {
        LockOwner maxOwner = null;
        Iterator it = this.owners.values().iterator();
        while (it.hasNext()) {
            LockOwner owner = (LockOwner)it.next();
            if (owner.lockLevel == supportLockLevel || owner.equals(reentrantOwner) || maxOwner != null && maxOwner.lockLevel >= owner.lockLevel || preferred && owner.intention) continue;
            maxOwner = owner;
        }
        return maxOwner;
    }

    protected synchronized void setLockLevel(Object ownerId, LockOwner lock, int targetLockLevel, int compatibility, boolean intention) {
        if (lock != null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.logFinest(ownerId.toString() + " upgrading lock for " + this.resourceId.toString() + " to level " + targetLockLevel + " at " + System.currentTimeMillis());
            }
        } else if (this.logger.isFinestEnabled()) {
            this.logger.logFinest(ownerId.toString() + " getting new lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
        }
        this.owners.put(ownerId, new LockOwner(ownerId, targetLockLevel, compatibility, intention));
    }

    protected boolean tryLock(Object ownerId, int targetLockLevel, int compatibility, boolean preferred) {
        return this.tryLock(ownerId, targetLockLevel, compatibility, preferred, false);
    }

    protected synchronized boolean tryLock(Object ownerId, int targetLockLevel, int compatibility, boolean preferred, boolean tryOnly) {
        LockOwner highestOwner;
        LockOwner myLock = (LockOwner)this.owners.get(ownerId);
        if (compatibility == 1) {
            if (myLock != null && targetLockLevel <= myLock.lockLevel) {
                return true;
            }
            highestOwner = this.getMaxLevelOwner(myLock, preferred);
        } else if (compatibility == 2) {
            highestOwner = this.getMaxLevelOwner(targetLockLevel, preferred);
        } else if (compatibility == 3) {
            if (myLock != null && targetLockLevel <= myLock.lockLevel) {
                return true;
            }
            highestOwner = this.getMaxLevelOwner(myLock, targetLockLevel, preferred);
        } else {
            highestOwner = this.getMaxLevelOwner();
        }
        int currentLockLevel = highestOwner != null ? highestOwner.lockLevel : this.getLevelMinLock();
        if (this.isCompatible(targetLockLevel, currentLockLevel)) {
            if (!tryOnly) {
                this.setLockLevel(ownerId, myLock, targetLockLevel, compatibility, false);
            }
            return true;
        }
        return false;
    }

    protected boolean isCompatible(int targetLockLevel, int currentLockLevel) {
        return targetLockLevel <= this.getLevelMaxLock() - currentLockLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getConflictingOwners(Object ownerId, int targetLockLevel, int compatibility) {
        ArrayList ownersCopy;
        LockOwner myLock = (LockOwner)this.owners.get(ownerId);
        if (myLock != null && targetLockLevel <= myLock.lockLevel) {
            return null;
        }
        LockOwner testLock = new LockOwner(ownerId, targetLockLevel, compatibility, false);
        Map map = this.owners;
        synchronized (map) {
            ownersCopy = new ArrayList(this.owners.values());
        }
        return this.getConflictingOwners(testLock, ownersCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getConflictingWaiters(Object ownerId) {
        LockOwner owner = (LockOwner)this.owners.get(ownerId);
        if (owner != null) {
            ArrayList waiterCopy;
            List list = this.waitingOwners;
            synchronized (list) {
                waiterCopy = new ArrayList(this.waitingOwners);
            }
            Set conflicts = this.getConflictingOwners(owner, waiterCopy);
            return conflicts;
        }
        return null;
    }

    protected Set getConflictingOwners(LockOwner myOwner, Collection ownersToTest) {
        if (myOwner == null) {
            return null;
        }
        HashSet<Object> conflicts = new HashSet<Object>();
        Iterator it = ownersToTest.iterator();
        while (it.hasNext()) {
            LockOwner owner = (LockOwner)it.next();
            if ((myOwner.compatibility == 1 || myOwner.compatibility == 3) && owner.ownerId.equals(myOwner.ownerId)) continue;
            int onwerLockLevel = owner.lockLevel;
            if (myOwner.compatibility == 2 || myOwner.compatibility == 3 && myOwner.lockLevel == onwerLockLevel || this.isCompatible(myOwner.lockLevel, onwerLockLevel)) continue;
            conflicts.add(owner.ownerId);
        }
        return conflicts.isEmpty() ? null : conflicts;
    }

    protected static class LockOwner {
        public final Object ownerId;
        public final int lockLevel;
        public final boolean intention;
        public final int compatibility;

        public LockOwner(Object ownerId, int lockLevel, int compatibility, boolean intention) {
            this.ownerId = ownerId;
            this.lockLevel = lockLevel;
            this.intention = intention;
            this.compatibility = compatibility;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.ownerId.toString()).append(": level ").append(this.lockLevel).append(", complevel ").append(this.compatibility).append(this.intention ? ", intention/preferred" : "");
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof LockOwner) {
                return ((LockOwner)o).ownerId.equals(this.ownerId);
            }
            return false;
        }

        public int hashCode() {
            return this.ownerId.hashCode();
        }
    }
}

