/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.jacc.HTTPMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.security.jacc.WebUserDataPermissionCollection;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission {
    private transient int cachedHashCode = 0;
    private transient URLPatternSpec urlPatternSpec;
    private transient HTTPMethodSpec httpMethodSpec;

    public WebUserDataPermission(HttpServletRequest request) {
        super(request.getServletPath());
        this.urlPatternSpec = new URLPatternSpec(request.getServletPath());
        this.httpMethodSpec = new HTTPMethodSpec(request.getMethod());
    }

    public WebUserDataPermission(String name, String actions) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.httpMethodSpec = new HTTPMethodSpec(actions, true);
    }

    public WebUserDataPermission(String urlPattern, String[] HTTPMethods, String transportType) {
        super(urlPattern);
        this.urlPatternSpec = new URLPatternSpec(urlPattern);
        this.httpMethodSpec = new HTTPMethodSpec(HTTPMethods, transportType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission other = (WebUserDataPermission)o;
        return this.urlPatternSpec.equals(other.urlPatternSpec) && this.httpMethodSpec.equals(other.httpMethodSpec);
    }

    public String getActions() {
        return this.httpMethodSpec.getActions();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.urlPatternSpec.hashCode() ^ this.httpMethodSpec.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission other = (WebUserDataPermission)permission;
        return this.urlPatternSpec.implies(other.urlPatternSpec) && this.httpMethodSpec.implies(other.httpMethodSpec);
    }

    public PermissionCollection newPermissionCollection() {
        return new WebUserDataPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException {
        this.urlPatternSpec = new URLPatternSpec(in.readUTF());
        this.httpMethodSpec = new HTTPMethodSpec(in.readUTF());
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.urlPatternSpec.getPatternSpec());
        out.writeUTF(this.httpMethodSpec.getActions());
    }
}

