/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.transaction.util.LoggerFacade;

public class Jdk14Logger
implements LoggerFacade {
    protected Logger logger;

    public Jdk14Logger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFacade createLogger(String name) {
        return new Jdk14Logger(Logger.getLogger(name));
    }

    public void logInfo(String message) {
        this.logger.info(message);
    }

    public void logFine(String message) {
        this.logger.fine(message);
    }

    public boolean isFineEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void logFiner(String message) {
        this.logger.finer(message);
    }

    public boolean isFinerEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public void logFinest(String message) {
        this.logger.finest(message);
    }

    public boolean isFinestEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void logWarning(String message) {
        this.logger.warning(message);
    }

    public void logWarning(String message, Throwable t) {
        this.logger.log(Level.WARNING, message, t);
    }

    public void logSevere(String message) {
        this.logger.severe(message);
    }

    public void logSevere(String message, Throwable t) {
        this.logger.log(Level.SEVERE, message, t);
    }
}

