/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.memory.ConflictException;
import org.apache.commons.transaction.memory.HashMapFactory;
import org.apache.commons.transaction.memory.HashSetFactory;
import org.apache.commons.transaction.memory.MapFactory;
import org.apache.commons.transaction.memory.SetFactory;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;

public class OptimisticMapWrapper
extends TransactionalMapWrapper {
    protected Set activeTransactions = Collections.synchronizedSet(new HashSet());

    public OptimisticMapWrapper(Map wrapped) {
        this(wrapped, new HashMapFactory(), new HashSetFactory());
    }

    public OptimisticMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory) {
        super(wrapped, mapFactory, setFactory);
    }

    public void startTransaction() {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        CopyingTxContext context = new CopyingTxContext();
        this.activeTransactions.add(context);
        this.setActiveTx(context);
    }

    public void rollbackTransaction() {
        TransactionalMapWrapper.TxContext txContext = this.getActiveTx();
        super.rollbackTransaction();
        this.activeTransactions.remove(txContext);
    }

    public void commitTransaction() throws ConflictException {
        this.commitTransaction(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(boolean force) throws ConflictException {
        Object conflictKey;
        TransactionalMapWrapper.TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        if (txContext.status == 1) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " is marked for rollback!");
        }
        if (!force && (conflictKey = this.checkForConflicts()) != null) {
            throw new ConflictException(conflictKey);
        }
        OptimisticMapWrapper optimisticMapWrapper = this;
        synchronized (optimisticMapWrapper) {
            this.activeTransactions.remove(txContext);
            this.copyChangesToConcurrentTransactions();
            super.commitTransaction();
        }
    }

    public Object checkForConflicts() {
        CopyingTxContext txContext = (CopyingTxContext)this.getActiveTx();
        Set keys = txContext.changedKeys();
        Set externalKeys = txContext.externalChangedKeys();
        Iterator it2 = keys.iterator();
        while (it2.hasNext()) {
            Object key = it2.next();
            if (!externalKeys.contains(key)) continue;
            return key;
        }
        return null;
    }

    protected void copyChangesToConcurrentTransactions() {
        CopyingTxContext thisTxContext = (CopyingTxContext)this.getActiveTx();
        Iterator it = this.activeTransactions.iterator();
        while (it.hasNext()) {
            Object value;
            CopyingTxContext otherTxContext = (CopyingTxContext)it.next();
            if (otherTxContext.cleared) continue;
            if (thisTxContext.cleared) {
                otherTxContext.externalChanges.putAll(this.wrapped);
                continue;
            }
            Iterator it2 = thisTxContext.changes.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                value = this.wrapped.get(entry.getKey());
                if (value != null) {
                    otherTxContext.externalChanges.put(entry.getKey(), value);
                    continue;
                }
                otherTxContext.externalDeletes.add(entry.getKey());
            }
            it2 = thisTxContext.deletes.iterator();
            while (it2.hasNext()) {
                Map.Entry key = it2.next();
                value = this.wrapped.get(key);
                otherTxContext.externalChanges.put(key, value);
            }
        }
    }

    public class CopyingTxContext
    extends TransactionalMapWrapper.TxContext {
        protected Map externalChanges;
        protected Map externalAdds;
        protected Set externalDeletes;

        protected CopyingTxContext() {
            super(OptimisticMapWrapper.this);
            this.externalChanges = OptimisticMapWrapper.this.mapFactory.createMap();
            this.externalDeletes = OptimisticMapWrapper.this.setFactory.createSet();
            this.externalAdds = OptimisticMapWrapper.this.mapFactory.createMap();
        }

        protected Set externalChangedKeys() {
            HashSet keySet = new HashSet();
            keySet.addAll(this.externalDeletes);
            keySet.addAll(this.externalChanges.keySet());
            keySet.addAll(this.externalAdds.keySet());
            return keySet;
        }

        protected Set changedKeys() {
            HashSet keySet = new HashSet();
            keySet.addAll(this.deletes);
            keySet.addAll(this.changes.keySet());
            keySet.addAll(this.adds.keySet());
            return keySet;
        }

        protected Set keys() {
            Set keySet = super.keys();
            keySet.removeAll(this.externalDeletes);
            keySet.addAll(this.externalAdds.keySet());
            return keySet;
        }

        protected Object get(Object key) {
            if (this.deletes.contains(key)) {
                return null;
            }
            Object changed = this.changes.get(key);
            if (changed != null) {
                return changed;
            }
            Object added = this.adds.get(key);
            if (added != null) {
                return added;
            }
            if (this.cleared) {
                return null;
            }
            if (this.externalDeletes.contains(key)) {
                return null;
            }
            changed = this.externalChanges.get(key);
            if (changed != null) {
                return changed;
            }
            added = this.externalAdds.get(key);
            if (added != null) {
                return added;
            }
            return OptimisticMapWrapper.this.wrapped.get(key);
        }

        protected int size() {
            int size = super.size();
            size -= this.externalDeletes.size();
            return size += this.externalAdds.size();
        }

        protected void clear() {
            super.clear();
            this.externalDeletes.clear();
            this.externalChanges.clear();
            this.externalAdds.clear();
        }

        protected void dispose() {
            super.dispose();
            OptimisticMapWrapper.this.setFactory.disposeSet(this.externalDeletes);
            this.externalDeletes = null;
            OptimisticMapWrapper.this.mapFactory.disposeMap(this.externalChanges);
            this.externalChanges = null;
            OptimisticMapWrapper.this.mapFactory.disposeMap(this.externalAdds);
            this.externalAdds = null;
        }

        protected void finalize() throws Throwable {
            OptimisticMapWrapper.this.activeTransactions.remove(this);
            super.finalize();
        }
    }
}

