/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.locking.ReadWriteLock;
import org.apache.commons.transaction.memory.ConflictException;
import org.apache.commons.transaction.memory.HashMapFactory;
import org.apache.commons.transaction.memory.HashSetFactory;
import org.apache.commons.transaction.memory.MapFactory;
import org.apache.commons.transaction.memory.SetFactory;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.PrintWriterLogger;

public class OptimisticMapWrapper
extends TransactionalMapWrapper {
    protected static final int COMMIT_TIMEOUT = 60000;
    protected static final int ACCESS_TIMEOUT = 30000;
    protected Set activeTransactions = Collections.synchronizedSet(new HashSet());
    protected LoggerFacade logger;
    protected ReadWriteLock commitLock;
    static /* synthetic */ Class class$org$apache$commons$transaction$memory$OptimisticMapWrapper;

    public OptimisticMapWrapper(Map wrapped) {
        this(wrapped, new HashMapFactory(), new HashSetFactory());
    }

    public OptimisticMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory) {
        this(wrapped, mapFactory, setFactory, new PrintWriterLogger(new PrintWriter(System.out), (class$org$apache$commons$transaction$memory$OptimisticMapWrapper == null ? (class$org$apache$commons$transaction$memory$OptimisticMapWrapper = OptimisticMapWrapper.class$("org.apache.commons.transaction.memory.OptimisticMapWrapper")) : class$org$apache$commons$transaction$memory$OptimisticMapWrapper).getName(), false));
    }

    public OptimisticMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory, LoggerFacade logger) {
        super(wrapped, mapFactory, setFactory);
        this.logger = logger;
        this.commitLock = new ReadWriteLock("COMMIT", logger);
    }

    public void startTransaction() {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        CopyingTxContext context = new CopyingTxContext();
        this.activeTransactions.add(context);
        this.setActiveTx(context);
    }

    public void rollbackTransaction() {
        TransactionalMapWrapper.TxContext txContext = this.getActiveTx();
        super.rollbackTransaction();
        this.activeTransactions.remove(txContext);
    }

    public void commitTransaction() throws ConflictException {
        this.commitTransaction(false);
    }

    public void commitTransaction(boolean force) throws ConflictException {
        TransactionalMapWrapper.TxContext txContext = this.getActiveTx();
        if (txContext == null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " not associated with a transaction!");
        }
        if (txContext.status == 1) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " is marked for rollback!");
        }
        try {
            Object conflictKey;
            this.commitLock.acquireWrite(txContext, 60000L);
            if (!force && (conflictKey = this.checkForConflicts()) != null) {
                throw new ConflictException(conflictKey);
            }
            this.activeTransactions.remove(txContext);
            this.copyChangesToConcurrentTransactions();
            super.commitTransaction();
        }
        catch (InterruptedException e) {
            throw new ConflictException((Object)e);
        }
        finally {
            this.commitLock.release(txContext);
        }
    }

    public Object checkForConflicts() {
        CopyingTxContext txContext = (CopyingTxContext)this.getActiveTx();
        Set keys = txContext.changedKeys();
        Set externalKeys = txContext.externalChangedKeys();
        Iterator it2 = keys.iterator();
        while (it2.hasNext()) {
            Object key = it2.next();
            if (!externalKeys.contains(key)) continue;
            return key;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyChangesToConcurrentTransactions() {
        CopyingTxContext thisTxContext = (CopyingTxContext)this.getActiveTx();
        Set set = this.activeTransactions;
        synchronized (set) {
            Iterator it = this.activeTransactions.iterator();
            while (it.hasNext()) {
                Object value;
                CopyingTxContext otherTxContext = (CopyingTxContext)it.next();
                if (otherTxContext.cleared) continue;
                if (thisTxContext.cleared) {
                    otherTxContext.externalChanges.putAll(this.wrapped);
                    continue;
                }
                Iterator it2 = thisTxContext.changes.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    value = this.wrapped.get(entry.getKey());
                    if (value != null) {
                        otherTxContext.externalChanges.put(entry.getKey(), value);
                        continue;
                    }
                    otherTxContext.externalDeletes.add(entry.getKey());
                }
                it2 = thisTxContext.deletes.iterator();
                while (it2.hasNext()) {
                    Map.Entry key = it2.next();
                    value = this.wrapped.get(key);
                    otherTxContext.externalChanges.put(key, value);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CopyingTxContext
    extends TransactionalMapWrapper.TxContext {
        protected Map externalChanges;
        protected Map externalAdds;
        protected Set externalDeletes;

        protected CopyingTxContext() {
            super(OptimisticMapWrapper.this);
            this.externalChanges = OptimisticMapWrapper.this.mapFactory.createMap();
            this.externalDeletes = OptimisticMapWrapper.this.setFactory.createSet();
            this.externalAdds = OptimisticMapWrapper.this.mapFactory.createMap();
        }

        protected Set externalChangedKeys() {
            HashSet keySet = new HashSet();
            keySet.addAll(this.externalDeletes);
            keySet.addAll(this.externalChanges.keySet());
            keySet.addAll(this.externalAdds.keySet());
            return keySet;
        }

        protected Set changedKeys() {
            HashSet keySet = new HashSet();
            keySet.addAll(this.deletes);
            keySet.addAll(this.changes.keySet());
            keySet.addAll(this.adds.keySet());
            return keySet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set keys() {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                Set keySet = super.keys();
                keySet.removeAll(this.externalDeletes);
                keySet.addAll(this.externalAdds.keySet());
                Set set = keySet;
                return set;
            }
            catch (InterruptedException e) {
                Set set = null;
                return set;
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object get(Object key) {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                if (this.deletes.contains(key)) {
                    Object var2_2 = null;
                    return var2_2;
                }
                Object changed = this.changes.get(key);
                if (changed != null) {
                    Object v = changed;
                    return v;
                }
                Object added = this.adds.get(key);
                if (added != null) {
                    Object v = added;
                    return v;
                }
                if (this.cleared) {
                    Object var4_8 = null;
                    return var4_8;
                }
                if (this.externalDeletes.contains(key)) {
                    Object var4_9 = null;
                    return var4_9;
                }
                changed = this.externalChanges.get(key);
                if (changed != null) {
                    Object v = changed;
                    return v;
                }
                added = this.externalAdds.get(key);
                if (added != null) {
                    Object v = added;
                    return v;
                }
                Object v = OptimisticMapWrapper.this.wrapped.get(key);
                return v;
            }
            catch (InterruptedException e) {
                Object var3_6 = null;
                return var3_6;
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void put(Object key, Object value) {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                super.put(key, value);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(Object key) {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                super.remove(key);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int size() {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                int size = super.size();
                size -= this.externalDeletes.size();
                int n = size += this.externalAdds.size();
                return n;
            }
            catch (InterruptedException e) {
                int n = -1;
                return n;
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clear() {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                super.clear();
                this.externalDeletes.clear();
                this.externalChanges.clear();
                this.externalAdds.clear();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void merge() {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                super.merge();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispose() {
            try {
                OptimisticMapWrapper.this.commitLock.acquireRead(this, 30000L);
                super.dispose();
                OptimisticMapWrapper.this.setFactory.disposeSet(this.externalDeletes);
                this.externalDeletes = null;
                OptimisticMapWrapper.this.mapFactory.disposeMap(this.externalChanges);
                this.externalChanges = null;
                OptimisticMapWrapper.this.mapFactory.disposeMap(this.externalAdds);
                this.externalAdds = null;
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OptimisticMapWrapper.this.commitLock.release(this);
            }
        }

        protected void finalize() throws Throwable {
            OptimisticMapWrapper.this.activeTransactions.remove(this);
            super.finalize();
        }
    }
}

