/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.IBANCheckDigit;

public class IBANCheckDigitTest
extends AbstractCheckDigitTest {
    public IBANCheckDigitTest(String name) {
        super(name);
        this.checkDigitLth = 2;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.routine = IBANCheckDigit.IBAN_CHECK_DIGIT;
        this.valid = new String[]{"AD1200012030200359100100", "AT611904300234573201", "BE62510007547061", "BE68539007547034", "CH3900700115201849173", "CH9300762011623852957", "CY17002001280000001200527600", "CZ6508000000192000145399", "DE89370400440532013000", "DK5000400440116243", "EE382200221020145685", "ES8023100001180000012345", "FI2112345600000785", "FR1420041010050500013M02606", "GB29NWBK60161331926819", "GI75NWBK000000007099453", "GR1601101250000000012300695", "HU42117730161111101800000000", "IE29AIBK93115212345678", "IS140159260076545510730339", "IT60X0542811101000000123456", "LT121000011101001000", "LU280019400644750000", "LV80BANK0000435195001", "MT84MALT011000012345MTLCAST001S", "NL39RABO0300065264", "NL91ABNA0417164300", "NO9386011117947", "PL27114020040000300201355387", "PL60102010260000042270201111", "PT50000201231234567890154", "SE3550000000054910000003", "SI56191000000123438", "SK3112000000198742637541", "AA0200000000053", "AA9700000000089", "AA9800000000071", "ZZ02ZZZZZZZZZZZZZZZZZZZZZZZZZ04", "ZZ97ZZZZZZZZZZZZZZZZZZZZZZZZZ40", "ZZ98ZZZZZZZZZZZZZZZZZZZZZZZZZ22"};
        this.invalid = new String[]{"510007+47061BE63", "IE01AIBK93118702569045", "AA0000000000089", "AA9900000000053"};
        this.zeroSum = null;
        this.missingMessage = "Invalid Code length=0";
    }

    @Override
    public void testZeroSum() {
    }

    @Override
    protected String[] createInvalidCodes(String[] codes) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < codes.length; ++i) {
            String code = this.removeCheckDigit(codes[i]);
            String check = this.checkDigit(codes[i]);
            for (int j = 2; j <= 98; ++j) {
                String curr;
                String string = curr = j > 9 ? "" + j : "0" + j;
                if (curr.equals(check)) continue;
                list.add(code.substring(0, 2) + curr + code.substring(4));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    protected String removeCheckDigit(String code) {
        return code.substring(0, 2) + "00" + code.substring(4);
    }

    @Override
    protected String checkDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return "";
        }
        return code.substring(2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOther() throws Exception {
        BufferedReader rdr = null;
        try {
            String line;
            rdr = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("IBANtests.txt"), "ASCII"));
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 0) continue;
                if (line.startsWith("-")) {
                    line = line.substring(1);
                    Assert.assertFalse((String)line, (boolean)this.routine.isValid(line.replaceAll(" ", "")));
                    continue;
                }
                Assert.assertTrue((String)line, (boolean)this.routine.isValid(line.replaceAll(" ", "")));
            }
        }
        finally {
            if (rdr != null) {
                rdr.close();
            }
        }
    }
}

