/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.util;

import junit.framework.TestCase;
import org.apache.commons.validator.util.Flags;

public class FlagsTest
extends TestCase {
    private static final long LONG_FLAG = 1L;
    private static final long LONG_FLAG_2 = 2L;
    private static final int INT_FLAG = 4;

    public FlagsTest(String name) {
        super(name);
    }

    public void testHashCode() {
        Flags f = new Flags(45L);
        FlagsTest.assertEquals((int)f.hashCode(), (int)45);
    }

    public void testGetFlags() {
        Flags f = new Flags(45L);
        FlagsTest.assertEquals((long)f.getFlags(), (long)45L);
    }

    public void testIsOnOff() {
        Flags f = new Flags();
        f.turnOn(1L);
        f.turnOn(4L);
        FlagsTest.assertTrue((boolean)f.isOn(1L));
        FlagsTest.assertTrue((!f.isOff(1L) ? 1 : 0) != 0);
        FlagsTest.assertTrue((boolean)f.isOn(4L));
        FlagsTest.assertTrue((!f.isOff(4L) ? 1 : 0) != 0);
        FlagsTest.assertTrue((boolean)f.isOff(2L));
    }

    public void testTurnOnOff() {
    }

    public void testTurnOff() {
    }

    public void testTurnOffAll() {
        Flags f = new Flags(98432L);
        f.turnOffAll();
        FlagsTest.assertEquals((long)0L, (long)f.getFlags());
    }

    public void testClear() {
        Flags f = new Flags(98432L);
        f.clear();
        FlagsTest.assertEquals((long)0L, (long)f.getFlags());
    }

    public void testTurnOnAll() {
        Flags f = new Flags();
        f.turnOnAll();
        FlagsTest.assertEquals((long)-1L, (long)f.getFlags());
    }

    public void testIsOn_isFalseWhenNotAllFlagsInArgumentAreOn() {
        Flags first = new Flags(1L);
        long firstAndSecond = 3L;
        FlagsTest.assertFalse((boolean)first.isOn(firstAndSecond));
    }

    public void testIsOn_isTrueWhenHighOrderBitIsSetAndQueried() {
        Flags allOn = new Flags(-1L);
        long highOrderBit = Long.MIN_VALUE;
        FlagsTest.assertTrue((boolean)allOn.isOn(highOrderBit));
    }

    public void testClone() {
    }

    public void testEqualsObject() {
    }

    public void testToString() {
        Flags f = new Flags();
        String s = f.toString();
        FlagsTest.assertEquals((int)64, (int)s.length());
        f.turnOn(4L);
        s = f.toString();
        FlagsTest.assertEquals((int)64, (int)s.length());
        FlagsTest.assertEquals((String)"0000000000000000000000000000000000000000000000000000000000000100", (String)s);
    }
}

