/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class MultipleTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "nameForm";
    protected static String ACTION = "required";

    public MultipleTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("MultipleTests-config.xml");
    }

    protected void tearDown() {
    }

    public void testBothBlank() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        MultipleTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        MultipleTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleTest.assertNotNull((String)"Last Name ValidatorResult should not be null.", (Object)lastNameResult);
        MultipleTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        MultipleTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleTest.assertTrue((String)"Last Name ValidatorResults should not contain the 'int' action.", (!lastNameResult.containsAction("int") ? 1 : 0) != 0);
    }

    public void testRequiredFirstNameBlankLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        MultipleTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        MultipleTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleTest.assertNotNull((String)"Last Name ValidatorResult should not be null.", (Object)lastNameResult);
        MultipleTest.assertTrue((String)"Last Name ValidatorResult should contain the 'int' action.", (boolean)lastNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Last Name ValidatorResult for the 'int' action should have failed.", (!lastNameResult.isValid("int") ? 1 : 0) != 0);
    }

    public void testRequiredLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Test");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        MultipleTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        MultipleTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        MultipleTest.assertNotNull((String)"Last Name ValidatorResult should not be null.", (Object)lastNameResult);
        MultipleTest.assertTrue((String)"Last Name ValidatorResult should contain the 'int' action.", (boolean)lastNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Last Name ValidatorResult for the 'int' action should have failed.", (!lastNameResult.isValid("int") ? 1 : 0) != 0);
    }

    public void testRequiredLastNameLong() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("12345678");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        MultipleTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        MultipleTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        MultipleTest.assertNotNull((String)"Last Name ValidatorResult should not be null.", (Object)lastNameResult);
        MultipleTest.assertTrue((String)"Last Name ValidatorResult should contain the 'int' action.", (boolean)lastNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Last Name ValidatorResult for the 'int' action should have passed.", (boolean)lastNameResult.isValid("int"));
    }

    public void testFailingFirstDependentValidator() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        MultipleTest.assertNotNull((String)"Middle Name ValidatorResult should not be null.", (Object)middleNameResult);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'required' action.", (boolean)middleNameResult.containsAction("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'required' action should have failed", (!middleNameResult.isValid("required") ? 1 : 0) != 0);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should not contain the 'int' action.", (!middleNameResult.containsAction("int") ? 1 : 0) != 0);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should not contain the 'positive' action.", (!middleNameResult.containsAction("positive") ? 1 : 0) != 0);
    }

    public void testFailingNextDependentValidator() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("TEST");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        MultipleTest.assertNotNull((String)"Middle Name ValidatorResult should not be null.", (Object)middleNameResult);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'required' action.", (boolean)middleNameResult.containsAction("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'required' action should have passed", (boolean)middleNameResult.isValid("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'int' action.", (boolean)middleNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'int' action should have failed", (!middleNameResult.isValid("int") ? 1 : 0) != 0);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should not contain the 'positive' action.", (!middleNameResult.containsAction("positive") ? 1 : 0) != 0);
    }

    public void testPassingDependentsFailingMain() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("-2534");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        MultipleTest.assertNotNull((String)"Middle Name ValidatorResult should not be null.", (Object)middleNameResult);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'required' action.", (boolean)middleNameResult.containsAction("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'required' action should have passed", (boolean)middleNameResult.isValid("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'int' action.", (boolean)middleNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'int' action should have passed", (boolean)middleNameResult.isValid("int"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'positive' action.", (boolean)middleNameResult.containsAction("positive"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'positive' action should have failed", (!middleNameResult.isValid("positive") ? 1 : 0) != 0);
    }

    public void testPassingDependentsPassingMain() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("2534");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        MultipleTest.assertNotNull((String)"Middle Name ValidatorResult should not be null.", (Object)middleNameResult);
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'required' action.", (boolean)middleNameResult.containsAction("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'required' action should have passed", (boolean)middleNameResult.isValid("required"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'int' action.", (boolean)middleNameResult.containsAction("int"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'int' action should have passed", (boolean)middleNameResult.isValid("int"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult should contain the 'positive' action.", (boolean)middleNameResult.containsAction("positive"));
        MultipleTest.assertTrue((String)"Middle Name ValidatorResult for the 'positive' action should have passed", (boolean)middleNameResult.isValid("positive"));
    }
}

