/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.routines.InetAddressValidator;

public class InetAddressValidatorTest
extends TestCase {
    private InetAddressValidator validator;

    public InetAddressValidatorTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.validator = new InetAddressValidator();
    }

    public void testInetAddressesFromTheWild() {
        InetAddressValidatorTest.assertTrue((String)"www.apache.org IP should be valid", (boolean)this.validator.isValid("140.211.11.130"));
        InetAddressValidatorTest.assertTrue((String)"www.l.google.com IP should be valid", (boolean)this.validator.isValid("72.14.253.103"));
        InetAddressValidatorTest.assertTrue((String)"fsf.org IP should be valid", (boolean)this.validator.isValid("199.232.41.5"));
        InetAddressValidatorTest.assertTrue((String)"appscs.ign.com IP should be valid", (boolean)this.validator.isValid("216.35.123.87"));
    }

    public void testVALIDATOR_335() {
        InetAddressValidatorTest.assertTrue((String)"2001:0438:FFFE:0000:0000:0000:0000:0A35 should be valid", (boolean)this.validator.isValid("2001:0438:FFFE:0000:0000:0000:0000:0A35"));
    }

    public void testInetAddressesByClass() {
        InetAddressValidatorTest.assertTrue((String)"class A IP should be valid", (boolean)this.validator.isValid("24.25.231.12"));
        InetAddressValidatorTest.assertFalse((String)"illegal class A IP should be invalid", (boolean)this.validator.isValid("2.41.32.324"));
        InetAddressValidatorTest.assertTrue((String)"class B IP should be valid", (boolean)this.validator.isValid("135.14.44.12"));
        InetAddressValidatorTest.assertFalse((String)"illegal class B IP should be invalid", (boolean)this.validator.isValid("154.123.441.123"));
        InetAddressValidatorTest.assertTrue((String)"class C IP should be valid", (boolean)this.validator.isValid("213.25.224.32"));
        InetAddressValidatorTest.assertFalse((String)"illegal class C IP should be invalid", (boolean)this.validator.isValid("201.543.23.11"));
        InetAddressValidatorTest.assertTrue((String)"class D IP should be valid", (boolean)this.validator.isValid("229.35.159.6"));
        InetAddressValidatorTest.assertFalse((String)"illegal class D IP should be invalid", (boolean)this.validator.isValid("231.54.11.987"));
        InetAddressValidatorTest.assertTrue((String)"class E IP should be valid", (boolean)this.validator.isValid("248.85.24.92"));
        InetAddressValidatorTest.assertFalse((String)"illegal class E IP should be invalid", (boolean)this.validator.isValid("250.21.323.48"));
    }

    public void testReservedInetAddresses() {
        InetAddressValidatorTest.assertTrue((String)"localhost IP should be valid", (boolean)this.validator.isValid("127.0.0.1"));
        InetAddressValidatorTest.assertTrue((String)"broadcast IP should be valid", (boolean)this.validator.isValid("255.255.255.255"));
    }

    public void testBrokenInetAddresses() {
        InetAddressValidatorTest.assertFalse((String)"IP with characters should be invalid", (boolean)this.validator.isValid("124.14.32.abc"));
        InetAddressValidatorTest.assertFalse((String)"IP with leading zeroes should be invalid", (boolean)this.validator.isValid("124.14.32.01"));
        InetAddressValidatorTest.assertFalse((String)"IP with three groups should be invalid", (boolean)this.validator.isValid("23.64.12"));
        InetAddressValidatorTest.assertFalse((String)"IP with five groups should be invalid", (boolean)this.validator.isValid("26.34.23.77.234"));
    }

    public void testIPv6() {
        InetAddressValidatorTest.assertFalse((String)"IPV6 empty string should be invalid", (boolean)this.validator.isValidInet6Address(""));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::1 should be valid", (boolean)this.validator.isValidInet6Address("::1"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 :: should be valid", (boolean)this.validator.isValidInet6Address("::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:0:0:1 should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0:1"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:DB8:0:0:8:800:200C:417A should be valid", (boolean)this.validator.isValidInet6Address("2001:DB8:0:0:8:800:200C:417A"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 FF01:0:0:0:0:0:0:101 should be valid", (boolean)this.validator.isValidInet6Address("FF01:0:0:0:0:0:0:101"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:DB8::8:800:200C:417A should be valid", (boolean)this.validator.isValidInet6Address("2001:DB8::8:800:200C:417A"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 FF01::101 should be valid", (boolean)this.validator.isValidInet6Address("FF01::101"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:DB8:0:0:8:800:200C:417A:221 should be invalid", (boolean)this.validator.isValidInet6Address("2001:DB8:0:0:8:800:200C:417A:221"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 FF01::101::2 should be invalid", (boolean)this.validator.isValidInet6Address("FF01::101::2"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80::217:f2ff:fe07:ed62 should be valid", (boolean)this.validator.isValidInet6Address("fe80::217:f2ff:fe07:ed62"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0000:1234:0000:0000:C1C0:ABCD:0876 should be valid", (boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:0000:C1C0:ABCD:0876"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 3ffe:0b00:0000:0000:0001:0000:0000:000a should be valid", (boolean)this.validator.isValidInet6Address("3ffe:0b00:0000:0000:0001:0000:0000:000a"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 FF02:0000:0000:0000:0000:0000:0000:0001 should be valid", (boolean)this.validator.isValidInet6Address("FF02:0000:0000:0000:0000:0000:0000:0001"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0000:0000:0000:0000:0000:0000:0000:0001 should be valid", (boolean)this.validator.isValidInet6Address("0000:0000:0000:0000:0000:0000:0000:0001"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0000:0000:0000:0000:0000:0000:0000:0000 should be valid", (boolean)this.validator.isValidInet6Address("0000:0000:0000:0000:0000:0000:0000:0000"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 02001:0000:1234:0000:0000:C1C0:ABCD:0876 should be invalid", (boolean)this.validator.isValidInet6Address("02001:0000:1234:0000:0000:C1C0:ABCD:0876"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:0000:1234:0000:00001:C1C0:ABCD:0876 should be invalid", (boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:00001:C1C0:ABCD:0876"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:0000:1234:0000:0000:C1C0:ABCD:0876 0 should be invalid", (boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:0000:C1C0:ABCD:0876 0"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:0000:1234: 0000:0000:C1C0:ABCD:0876 should be invalid", (boolean)this.validator.isValidInet6Address("2001:0000:1234: 0000:0000:C1C0:ABCD:0876"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 3ffe:0b00:0000:0001:0000:0000:000a should be invalid", (boolean)this.validator.isValidInet6Address("3ffe:0b00:0000:0001:0000:0000:000a"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 FF02:0000:0000:0000:0000:0000:0000:0000:0001 should be invalid", (boolean)this.validator.isValidInet6Address("FF02:0000:0000:0000:0000:0000:0000:0000:0001"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 3ffe:b00::1::a should be invalid", (boolean)this.validator.isValidInet6Address("3ffe:b00::1::a"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1111:2222:3333:4444:5555:6666:: should be invalid", (boolean)this.validator.isValidInet6Address("::1111:2222:3333:4444:5555:6666::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2::10 should be valid", (boolean)this.validator.isValidInet6Address("2::10"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ff02::1 should be valid", (boolean)this.validator.isValidInet6Address("ff02::1"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80:: should be valid", (boolean)this.validator.isValidInet6Address("fe80::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2002:: should be valid", (boolean)this.validator.isValidInet6Address("2002::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:db8:: should be valid", (boolean)this.validator.isValidInet6Address("2001:db8::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:1234:: should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:1234::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5:6:7:8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5:6::8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5:6::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5::8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4::8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3::8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2::8 should be valid", (boolean)this.validator.isValidInet6Address("1:2::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::8 should be valid", (boolean)this.validator.isValidInet6Address("1::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::2:3:4:5:6:7 should be valid", (boolean)this.validator.isValidInet6Address("1::2:3:4:5:6:7"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::2:3:4:5:6 should be valid", (boolean)this.validator.isValidInet6Address("1::2:3:4:5:6"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::2:3:4:5 should be valid", (boolean)this.validator.isValidInet6Address("1::2:3:4:5"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::2:3:4 should be valid", (boolean)this.validator.isValidInet6Address("1::2:3:4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::2:3 should be valid", (boolean)this.validator.isValidInet6Address("1::2:3"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3:4:5:6:7:8 should be valid", (boolean)this.validator.isValidInet6Address("::2:3:4:5:6:7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3:4:5:6:7 should be valid", (boolean)this.validator.isValidInet6Address("::2:3:4:5:6:7"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3:4:5:6 should be valid", (boolean)this.validator.isValidInet6Address("::2:3:4:5:6"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3:4:5 should be valid", (boolean)this.validator.isValidInet6Address("::2:3:4:5"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3:4 should be valid", (boolean)this.validator.isValidInet6Address("::2:3:4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2:3 should be valid", (boolean)this.validator.isValidInet6Address("::2:3"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::8 should be valid", (boolean)this.validator.isValidInet6Address("::8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5:6:: should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5:6::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5:: should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:: should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:: should be valid", (boolean)this.validator.isValidInet6Address("1:2:3::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:: should be valid", (boolean)this.validator.isValidInet6Address("1:2::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:: should be valid", (boolean)this.validator.isValidInet6Address("1::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5::7:8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5::7:8"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1:2:3::4:5::7:8 should be invalid", (boolean)this.validator.isValidInet6Address("1:2:3::4:5::7:8"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 12345::6:7:8 should be invalid", (boolean)this.validator.isValidInet6Address("12345::6:7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4::7:8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4::7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3::7:8 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3::7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2::7:8 should be valid", (boolean)this.validator.isValidInet6Address("1:2::7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::7:8 should be valid", (boolean)this.validator.isValidInet6Address("1::7:8"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5:6:1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4:5::1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5::1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4::1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4::1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3::1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3::1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2::1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2::1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1::1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3:4::5:1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3:4::5:1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2:3::5:1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2:3::5:1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1:2::5:1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1:2::5:1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::5:1.2.3.4 should be valid", (boolean)this.validator.isValidInet6Address("1::5:1.2.3.4"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1::5:11.22.33.44 should be valid", (boolean)this.validator.isValidInet6Address("1::5:11.22.33.44"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:400.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:400.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:260.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:260.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:256.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:256.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.256.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.256.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.256.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.256.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.3.256 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.3.256"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:300.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:300.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.300.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.300.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.300.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.300.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.3.300 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.3.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:900.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:900.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.900.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.900.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.900.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.900.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:1.2.3.900 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:1.2.3.900"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:300.300.300.300 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:300.300.300.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::5:3000.30.30.30 should be invalid", (boolean)this.validator.isValidInet6Address("1::5:3000.30.30.30"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::400.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::400.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::260.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::260.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::256.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::256.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.256.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.256.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.256.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.256.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.3.256 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.3.256"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::300.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::300.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.300.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.300.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.300.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.300.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.3.300 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.3.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::900.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::900.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.900.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.900.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.900.4 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.900.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::1.2.3.900 should be invalid", (boolean)this.validator.isValidInet6Address("1::1.2.3.900"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::300.300.300.300 should be invalid", (boolean)this.validator.isValidInet6Address("1::300.300.300.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::3000.30.30.30 should be invalid", (boolean)this.validator.isValidInet6Address("1::3000.30.30.30"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::400.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::400.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::260.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::260.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::256.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::256.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.256.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.256.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.256.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.256.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.3.256 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.3.256"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::300.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::300.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.300.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.300.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.300.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.300.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.3.300 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.3.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::900.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::900.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.900.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.900.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.900.4 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.900.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.3.900 should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.3.900"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::300.300.300.300 should be invalid", (boolean)this.validator.isValidInet6Address("::300.300.300.300"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::3000.30.30.30 should be invalid", (boolean)this.validator.isValidInet6Address("::3000.30.30.30"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80::217:f2ff:254.7.237.98 should be valid", (boolean)this.validator.isValidInet6Address("fe80::217:f2ff:254.7.237.98"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:192.168.1.26 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:192.168.1.26"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:1:1:1:1:1:255Z255X255Y255 should be invalid", (boolean)this.validator.isValidInet6Address("2001:1:1:1:1:1:255Z255X255Y255"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::ffff:192x168.1.26 should be invalid", (boolean)this.validator.isValidInet6Address("::ffff:192x168.1.26"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:192.168.1.1 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:192.168.1.1"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:0:13.1.68.3 should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:13.1.68.3"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:FFFF:129.144.52.38 should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:FFFF:129.144.52.38"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::13.1.68.3 should be valid", (boolean)this.validator.isValidInet6Address("::13.1.68.3"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::FFFF:129.144.52.38 should be valid", (boolean)this.validator.isValidInet6Address("::FFFF:129.144.52.38"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80:0:0:0:204:61ff:254.157.241.86 should be valid", (boolean)this.validator.isValidInet6Address("fe80:0:0:0:204:61ff:254.157.241.86"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80::204:61ff:254.157.241.86 should be valid", (boolean)this.validator.isValidInet6Address("fe80::204:61ff:254.157.241.86"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:12.34.56.78 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:12.34.56.78"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::ffff:2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::ffff:2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::ffff:257.1.2.3 should be invalid", (boolean)this.validator.isValidInet6Address("::ffff:257.1.2.3"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4:1111:2222:3333:4444::5555 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222:3333:4444::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4:1111:2222:3333::5555 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222:3333::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4:1111:2222::5555 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4:1111::5555 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4:1111::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4::5555 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4:: should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 fe80:0000:0000:0000:0204:61ff:254.157.241.086 should be invalid", (boolean)this.validator.isValidInet6Address("fe80:0000:0000:0000:0204:61ff:254.157.241.086"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:192.0.2.128 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:192.0.2.128"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:00.00.00.00 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:00.00.00.00"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:000.000.000.000 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:000.000.000.000"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:256.256.256.256 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:256.256.256.256"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80:0000:0000:0000:0204:61ff:fe9d:f156 should be valid", (boolean)this.validator.isValidInet6Address("fe80:0000:0000:0000:0204:61ff:fe9d:f156"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80:0:0:0:204:61ff:fe9d:f156 should be valid", (boolean)this.validator.isValidInet6Address("fe80:0:0:0:204:61ff:fe9d:f156"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 fe80::204:61ff:fe9d:f156 should be valid", (boolean)this.validator.isValidInet6Address("fe80::204:61ff:fe9d:f156"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 : should be invalid", (boolean)this.validator.isValidInet6Address(":"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:c000:280 should be valid", (boolean)this.validator.isValidInet6Address("::ffff:c000:280"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::5555: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::5555: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::5555: should be invalid", (boolean)this.validator.isValidInet6Address("1111::5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::5555: should be invalid", (boolean)this.validator.isValidInet6Address("::5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::: should be invalid", (boolean)this.validator.isValidInet6Address(":::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111: should be invalid", (boolean)this.validator.isValidInet6Address("1111:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::5555 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::5555 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::5555 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::5555 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::5555 should be invalid", (boolean)this.validator.isValidInet6Address(":::5555"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:85a3:0000:0000:8a2e:0370:7334 should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:85a3:0000:0000:8a2e:0370:7334"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:db8:85a3:0:0:8a2e:370:7334 should be valid", (boolean)this.validator.isValidInet6Address("2001:db8:85a3:0:0:8a2e:370:7334"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:db8:85a3::8a2e:370:7334 should be valid", (boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:370:7334"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:0000:0000:0000:0000:1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:0000:0000:0000:0000:1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:0000:0000:0000::1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:0000:0000:0000::1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:0:0:0:0:1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:0:0:0:0:1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:0:0::1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:0:0::1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8::1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8::1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:db8::1428:57ab should be valid", (boolean)this.validator.isValidInet6Address("2001:db8::1428:57ab"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::ffff:0c22:384e should be valid", (boolean)this.validator.isValidInet6Address("::ffff:0c22:384e"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:1234:0000:0000:0000:0000:0000 should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:1234:0000:0000:0000:0000:0000"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:0db8:1234:ffff:ffff:ffff:ffff:ffff should be valid", (boolean)this.validator.isValidInet6Address("2001:0db8:1234:ffff:ffff:ffff:ffff:ffff"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 2001:db8:a::123 should be valid", (boolean)this.validator.isValidInet6Address("2001:db8:a::123"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 123 should be invalid", (boolean)this.validator.isValidInet6Address("123"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ldkfj should be invalid", (boolean)this.validator.isValidInet6Address("ldkfj"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001::FFD3::57ab should be invalid", (boolean)this.validator.isValidInet6Address("2001::FFD3::57ab"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:db8:85a3::8a2e:37023:7334 should be invalid", (boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:37023:7334"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 2001:db8:85a3::8a2e:370k:7334 should be invalid", (boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:370k:7334"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1:2:3:4:5:6:7:8:9 should be invalid", (boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:7:8:9"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1::2::3 should be invalid", (boolean)this.validator.isValidInet6Address("1::2::3"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1:::3:4:5 should be invalid", (boolean)this.validator.isValidInet6Address("1:::3:4:5"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1:2:3::4:5:6:7:8:9 should be invalid", (boolean)this.validator.isValidInet6Address("1:2:3::4:5:6:7:8:9"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:6666:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:: should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:: should be valid", (boolean)this.validator.isValidInet6Address("1111::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:6666::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::8888 should be valid", (boolean)this.validator.isValidInet6Address("::8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444::6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::3333:4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::3333:4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888 should be valid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444:5555::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("::123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333:4444::6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111::6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("::6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222:3333::5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111::5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("::5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111:2222::4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("::4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 1111::3333:4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::2222:3333:4444:5555:6666:123.123.123.123 should be valid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:123.123.123.123"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0:0:0:0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0:0:0:0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0:0:0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0:0:0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0:0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0:0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:0 should be valid", (boolean)this.validator.isValidInet6Address("::0:0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0 should be valid", (boolean)this.validator.isValidInet6Address("::0"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0:0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:0:: should be valid", (boolean)this.validator.isValidInet6Address("0:0::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:: should be valid", (boolean)this.validator.isValidInet6Address("0::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX should be invalid", (boolean)this.validator.isValidInet6Address("XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:9999 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:9999"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888:9999 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888:9999"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111 should be invalid", (boolean)this.validator.isValidInet6Address("1111"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 11112222:3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("11112222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:22223333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:22223333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:33334444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:33334444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:44445555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:44445555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:55556666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:55556666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:66667777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:66667777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:77778888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:77778888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :8888 should be invalid", (boolean)this.validator.isValidInet6Address(":8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :2222:3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::2222:3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:::3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:::3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:::4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:::8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222::4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("::2222::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555:7777::8888 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:7777::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555:7777:8888:: should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:7777:8888::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444:5555::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444:5555:6666::8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444:5555:6666:7777:: should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444:5555::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444:5555:6666::8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444:5555:6666:7777:: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555:6666::8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555:6666:7777:: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::6666::8888 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::6666:7777:: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555::7777:: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555:6666:7777:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:1.2.3.4.5 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:1.2.3.4.5"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 11112222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("11112222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:22223333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:22223333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:33334444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:33334444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:44445555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:44445555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:55556666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:55556666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:66661.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:66661.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:255255.255.255 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255255.255.255"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:255.255255.255 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255.255255.255"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:255.255.255255 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255.255.255255"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :2222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":2222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::2222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:::3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:::3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:::4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:::4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222::4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::2222::4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444:5555::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444:5555::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::. should be invalid", (boolean)this.validator.isValidInet6Address("::."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::.. should be invalid", (boolean)this.validator.isValidInet6Address("::.."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::... should be invalid", (boolean)this.validator.isValidInet6Address("::..."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1... should be invalid", (boolean)this.validator.isValidInet6Address("::1..."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.. should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::1.2.3. should be invalid", (boolean)this.validator.isValidInet6Address("::1.2.3."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::.2.. should be invalid", (boolean)this.validator.isValidInet6Address("::.2.."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::.2.3. should be invalid", (boolean)this.validator.isValidInet6Address("::.2.3."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::..3. should be invalid", (boolean)this.validator.isValidInet6Address("::..3."));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::..3.4 should be invalid", (boolean)this.validator.isValidInet6Address("::..3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::...4 should be invalid", (boolean)this.validator.isValidInet6Address("::...4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666:7777:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:7777::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:: should be invalid", (boolean)this.validator.isValidInet6Address(":1111::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::2222:3333:4444:5555:6666:7777:8888 should be invalid", (boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:7777:8888"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444:5555::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333:4444::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222:3333::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111:2222::4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111:2222::4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :1111::3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":1111::3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 :::2222:3333:4444:5555:6666:1.2.3.4 should be invalid", (boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:1.2.3.4"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666:7777::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::: should be invalid", (boolean)this.validator.isValidInet6Address("1111:::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555:6666::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::8888: should be invalid", (boolean)this.validator.isValidInet6Address("::8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444:5555::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333:4444::6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222:3333::5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111:2222::4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 1111::3333:4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::3333:4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::3333:4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888: should be invalid", (boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888:"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 0:a:b:c:d:e:f:: should be valid", (boolean)this.validator.isValidInet6Address("0:a:b:c:d:e:f::"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 ::0:a:b:c:d:e:f should be valid", (boolean)this.validator.isValidInet6Address("::0:a:b:c:d:e:f"));
        InetAddressValidatorTest.assertTrue((String)"IPV6 a:b:c:d:e:f:0:: should be valid", (boolean)this.validator.isValidInet6Address("a:b:c:d:e:f:0::"));
        InetAddressValidatorTest.assertFalse((String)"IPV6 ':10.0.0.1 should be invalid", (boolean)this.validator.isValidInet6Address("':10.0.0.1"));
    }
}

