/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class ParameterTest
extends AbstractCommonTest {
    private static final String FORM_KEY = "nameForm";
    private String firstName;
    private String middleName;
    private String lastName;

    public ParameterTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("ParameterTest-config.xml");
        this.firstName = "foo";
        this.middleName = "123";
        this.lastName = "456";
    }

    protected void tearDown() {
    }

    public void testAllValid() {
        NameBean bean = this.createNameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)bean);
        validator.setParameter("java.util.Locale", (Object)Locale.getDefault());
        try {
            validator.validate();
        }
        catch (Exception e) {
            ParameterTest.fail((String)("Validator.validate() threw " + e));
        }
        this.assertParameterValue(validator, "java.lang.Object", Object.class);
        this.assertParameterValue(validator, "org.apache.commons.validator.Field", Field.class);
        this.assertParameterValue(validator, "org.apache.commons.validator.Form", Form.class);
        this.assertParameterValue(validator, "java.util.Locale", Locale.class);
        this.assertParameterValue(validator, "org.apache.commons.validator.ValidatorAction", ValidatorAction.class);
        this.assertParameterValue(validator, "org.apache.commons.validator.Validator", Validator.class);
        this.assertParameterValue(validator, "org.apache.commons.validator.ValidatorResults", ValidatorResults.class);
    }

    private void assertParameterValue(Validator validator, String name, Class<?> type) {
        Object value = validator.getParameterValue(name);
        ParameterTest.assertNotNull((String)("Expected '" + type.getName() + "' but was null"), (Object)value);
        ParameterTest.assertTrue((String)("Expected '" + type.getName() + "' but was '" + value.getClass().getName() + "'"), (boolean)type.isInstance(value));
    }

    private NameBean createNameBean() {
        NameBean name = new NameBean();
        name.setFirstName(this.firstName);
        name.setMiddleName(this.middleName);
        name.setLastName(this.lastName);
        return name;
    }
}

