/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.routines.CodeValidator;
import org.apache.commons.validator.routines.CreditCardValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.checkdigit.LuhnCheckDigit;

public class CreditCardValidatorTest
extends TestCase {
    private static final String VALID_VISA = "4417123456789113";
    private static final String ERROR_VISA = "4417123456789112";
    private static final String VALID_SHORT_VISA = "4222222222222";
    private static final String ERROR_SHORT_VISA = "4222222222229";
    private static final String VALID_AMEX = "378282246310005";
    private static final String ERROR_AMEX = "378282246310001";
    private static final String VALID_MASTERCARD = "5105105105105100";
    private static final String ERROR_MASTERCARD = "5105105105105105";
    private static final String VALID_DISCOVER = "6011000990139424";
    private static final String ERROR_DISCOVER = "6011000990139421";
    private static final String VALID_DISCOVER65 = "6534567890123458";
    private static final String ERROR_DISCOVER65 = "6534567890123450";
    private static final String VALID_DINERS = "30569309025904";
    private static final String ERROR_DINERS = "30569309025901";
    private static final String VALID_VPAY = "4370000000000061";
    private static final String VALID_VPAY2 = "4370000000000012";
    private static final String ERROR_VPAY = "4370000000000069";

    public CreditCardValidatorTest(String name) {
        super(name);
    }

    public void testIsValid() {
        CreditCardValidator ccv = new CreditCardValidator();
        CreditCardValidatorTest.assertNull((Object)ccv.validate(null));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(null));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(""));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("123456789012"));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("12345678901234567890"));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("4417q23456w89113"));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_DISCOVER65));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_SHORT_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_AMEX));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER65));
        ccv = new CreditCardValidator(1L);
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_VISA));
    }

    public void testAddAllowedCardType() {
        CreditCardValidator ccv = new CreditCardValidator(0L);
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_DINERS));
    }

    public void testArrayConstructor() {
        CreditCardValidator ccv = new CreditCardValidator(new CodeValidator[]{CreditCardValidator.VISA_VALIDATOR, CreditCardValidator.AMEX_VALIDATOR});
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_SHORT_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_AMEX));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER));
        try {
            new CreditCardValidator((CodeValidator[])null);
            CreditCardValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAmexValidator() {
        CodeValidator validator = CreditCardValidator.AMEX_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertFalse((String)"Length 12", (boolean)regex.isValid("343456789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 13", (boolean)regex.isValid("3434567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 14", (boolean)regex.isValid("34345678901234"));
        CreditCardValidatorTest.assertTrue((String)"Length 15", (boolean)regex.isValid("343456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Length 16", (boolean)regex.isValid("3434567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 17", (boolean)regex.isValid("34345678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 18", (boolean)regex.isValid("343456789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 33", (boolean)regex.isValid("333456789012345"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 34", (boolean)regex.isValid("343456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 35", (boolean)regex.isValid("353456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 36", (boolean)regex.isValid("363456789012345"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 37", (boolean)regex.isValid("373456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 38", (boolean)regex.isValid("383456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 41", (boolean)regex.isValid("413456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char", (boolean)regex.isValid("3434567x9012345"));
        CreditCardValidatorTest.assertTrue((String)"Valid regex", (boolean)regex.isValid(ERROR_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_AMEX));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_AMEX));
        CreditCardValidatorTest.assertEquals((Object)VALID_AMEX, (Object)validator.validate(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid-A", (boolean)validator.isValid("371449635398431"));
        CreditCardValidatorTest.assertTrue((String)"Valid-B", (boolean)validator.isValid("340000000000009"));
        CreditCardValidatorTest.assertTrue((String)"Valid-C", (boolean)validator.isValid("370000000000002"));
        CreditCardValidatorTest.assertTrue((String)"Valid-D", (boolean)validator.isValid("378734493671000"));
    }

    public void testAmexOption() {
        CreditCardValidator validator = new CreditCardValidator(1L);
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_AMEX));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_AMEX));
        CreditCardValidatorTest.assertEquals((Object)VALID_AMEX, (Object)validator.validate(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testDinersValidator() {
        CodeValidator validator = CreditCardValidator.DINERS_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertFalse((String)"Length 12-300", (boolean)regex.isValid("300456789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 12-36", (boolean)regex.isValid("363456789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 13-300", (boolean)regex.isValid("3004567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 13-36", (boolean)regex.isValid("3634567890123"));
        CreditCardValidatorTest.assertTrue((String)"Length 14-300", (boolean)regex.isValid("30045678901234"));
        CreditCardValidatorTest.assertTrue((String)"Length 14-36", (boolean)regex.isValid("36345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Length 15-300", (boolean)regex.isValid("300456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Length 15-36", (boolean)regex.isValid("363456789012345"));
        CreditCardValidatorTest.assertFalse((String)"Length 16-300", (boolean)regex.isValid("3004567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 16-36", (boolean)regex.isValid("3634567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 17-300", (boolean)regex.isValid("30045678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 17-36", (boolean)regex.isValid("36345678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 18-300", (boolean)regex.isValid("300456789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Length 18-36", (boolean)regex.isValid("363456789012345678"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 300", (boolean)regex.isValid("30045678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 301", (boolean)regex.isValid("30145678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 302", (boolean)regex.isValid("30245678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 303", (boolean)regex.isValid("30345678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 304", (boolean)regex.isValid("30445678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 305", (boolean)regex.isValid("30545678901234"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 306", (boolean)regex.isValid("30645678901234"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 3094", (boolean)regex.isValid("30945678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 3095", (boolean)regex.isValid("30955678901234"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 3096", (boolean)regex.isValid("30965678901234"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 35", (boolean)regex.isValid("35345678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 36", (boolean)regex.isValid("36345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 37", (boolean)regex.isValid("37345678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 38", (boolean)regex.isValid("38345678901234"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 39", (boolean)regex.isValid("39345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char-A", (boolean)regex.isValid("3004567x901234"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char-B", (boolean)regex.isValid("3634567x901234"));
        CreditCardValidatorTest.assertTrue((String)"Valid regex", (boolean)regex.isValid(ERROR_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_DINERS));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_DINERS));
        CreditCardValidatorTest.assertEquals((Object)VALID_DINERS, (Object)validator.validate(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid-A", (boolean)validator.isValid("30000000000004"));
        CreditCardValidatorTest.assertTrue((String)"Valid-B", (boolean)validator.isValid("30123456789019"));
        CreditCardValidatorTest.assertTrue((String)"Valid-C", (boolean)validator.isValid("36432685260294"));
    }

    public void testDinersOption() {
        CreditCardValidator validator = new CreditCardValidator(16L);
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_DINERS));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_DINERS));
        CreditCardValidatorTest.assertEquals((Object)VALID_DINERS, (Object)validator.validate(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testDiscoverValidator() {
        CodeValidator validator = CreditCardValidator.DISCOVER_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertFalse((String)"Length 12-6011", (boolean)regex.isValid("601156789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 12-65", (boolean)regex.isValid("653456789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 13-6011", (boolean)regex.isValid("6011567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 13-65", (boolean)regex.isValid("6534567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 14-6011", (boolean)regex.isValid("60115678901234"));
        CreditCardValidatorTest.assertFalse((String)"Length 14-65", (boolean)regex.isValid("65345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Length 15-6011", (boolean)regex.isValid("601156789012345"));
        CreditCardValidatorTest.assertFalse((String)"Length 15-65", (boolean)regex.isValid("653456789012345"));
        CreditCardValidatorTest.assertTrue((String)"Length 16-6011", (boolean)regex.isValid("6011567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Length 16-644", (boolean)regex.isValid("6444567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Length 16-648", (boolean)regex.isValid("6484567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Length 16-65", (boolean)regex.isValid("6534567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 17-6011", (boolean)regex.isValid("60115678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 17-65", (boolean)regex.isValid("65345678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 18-6011", (boolean)regex.isValid("601156789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Length 18-65", (boolean)regex.isValid("653456789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 640", (boolean)regex.isValid("6404567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 641", (boolean)regex.isValid("6414567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 642", (boolean)regex.isValid("6424567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 643", (boolean)regex.isValid("6434567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 6010", (boolean)regex.isValid("6010567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 6012", (boolean)regex.isValid("6012567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char", (boolean)regex.isValid("6011567x90123456"));
        CreditCardValidatorTest.assertTrue((String)"Valid regex", (boolean)regex.isValid(ERROR_DISCOVER));
        CreditCardValidatorTest.assertTrue((String)"Valid regex65", (boolean)regex.isValid(ERROR_DISCOVER65));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Invalid65", (boolean)validator.isValid(ERROR_DISCOVER65));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_DISCOVER));
        CreditCardValidatorTest.assertEquals((Object)VALID_DISCOVER, (Object)validator.validate(VALID_DISCOVER));
        CreditCardValidatorTest.assertEquals((Object)VALID_DISCOVER65, (Object)validator.validate(VALID_DISCOVER65));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertTrue((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertTrue((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER65));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid-A", (boolean)validator.isValid("6011111111111117"));
        CreditCardValidatorTest.assertTrue((String)"Valid-B", (boolean)validator.isValid("6011000000000004"));
        CreditCardValidatorTest.assertTrue((String)"Valid-C", (boolean)validator.isValid("6011000000000012"));
    }

    public void testDiscoverOption() {
        CreditCardValidator validator = new CreditCardValidator(8L);
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Invalid65", (boolean)validator.isValid(ERROR_DISCOVER65));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_DISCOVER));
        CreditCardValidatorTest.assertEquals((Object)VALID_DISCOVER, (Object)validator.validate(VALID_DISCOVER));
        CreditCardValidatorTest.assertEquals((Object)VALID_DISCOVER65, (Object)validator.validate(VALID_DISCOVER65));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertTrue((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertTrue((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER65));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testMastercardValidator() {
        CodeValidator validator = CreditCardValidator.MASTERCARD_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertFalse((String)"Length 12", (boolean)regex.isValid("513456789012"));
        CreditCardValidatorTest.assertFalse((String)"Length 13", (boolean)regex.isValid("5134567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 14", (boolean)regex.isValid("51345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Length 15", (boolean)regex.isValid("513456789012345"));
        CreditCardValidatorTest.assertTrue((String)"Length 16", (boolean)regex.isValid("5134567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 17", (boolean)regex.isValid("51345678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 18", (boolean)regex.isValid("513456789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 41", (boolean)regex.isValid("4134567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 50", (boolean)regex.isValid("5034567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 51", (boolean)regex.isValid("5134567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 52", (boolean)regex.isValid("5234567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 53", (boolean)regex.isValid("5334567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 54", (boolean)regex.isValid("5434567890123456"));
        CreditCardValidatorTest.assertTrue((String)"Prefix 55", (boolean)regex.isValid("5534567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 56", (boolean)regex.isValid("5634567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Prefix 61", (boolean)regex.isValid("6134567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char", (boolean)regex.isValid("5134567x90123456"));
        CreditCardValidatorTest.assertTrue((String)"Valid regex", (boolean)regex.isValid(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertEquals((Object)VALID_MASTERCARD, (Object)validator.validate(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertTrue((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid-A", (boolean)validator.isValid("5500000000000004"));
        CreditCardValidatorTest.assertTrue((String)"Valid-B", (boolean)validator.isValid("5424000000000015"));
        CreditCardValidatorTest.assertTrue((String)"Valid-C", (boolean)validator.isValid("5301250070000191"));
        CreditCardValidatorTest.assertTrue((String)"Valid-D", (boolean)validator.isValid("5123456789012346"));
        CreditCardValidatorTest.assertTrue((String)"Valid-E", (boolean)validator.isValid("5555555555554444"));
        RegexValidator rev = validator.getRegexValidator();
        String PAD = "0000000000";
        CreditCardValidatorTest.assertFalse((String)"222099", (boolean)rev.isValid("2220990000000000"));
        for (int i = 222100; i <= 272099; ++i) {
            String j = Integer.toString(i) + "0000000000";
            CreditCardValidatorTest.assertTrue((String)j, (boolean)rev.isValid(j));
        }
        CreditCardValidatorTest.assertFalse((String)"272100", (boolean)rev.isValid("2721000000000000"));
    }

    public void testMastercardOption() {
        CreditCardValidator validator = new CreditCardValidator(4L);
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_MASTERCARD));
        CreditCardValidatorTest.assertEquals((Object)VALID_MASTERCARD, (Object)validator.validate(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertTrue((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testVisaValidator() {
        CodeValidator validator = CreditCardValidator.VISA_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertFalse((String)"Length 12", (boolean)regex.isValid("423456789012"));
        CreditCardValidatorTest.assertTrue((String)"Length 13", (boolean)regex.isValid("4234567890123"));
        CreditCardValidatorTest.assertFalse((String)"Length 14", (boolean)regex.isValid("42345678901234"));
        CreditCardValidatorTest.assertFalse((String)"Length 15", (boolean)regex.isValid("423456789012345"));
        CreditCardValidatorTest.assertTrue((String)"Length 16", (boolean)regex.isValid("4234567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Length 17", (boolean)regex.isValid("42345678901234567"));
        CreditCardValidatorTest.assertFalse((String)"Length 18", (boolean)regex.isValid("423456789012345678"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Pref-A", (boolean)regex.isValid("3234567890123"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Pref-B", (boolean)regex.isValid("3234567890123456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char-A", (boolean)regex.isValid("4234567x90123"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Char-B", (boolean)regex.isValid("4234567x90123456"));
        CreditCardValidatorTest.assertTrue((String)"Valid regex", (boolean)regex.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid regex-S", (boolean)regex.isValid(ERROR_SHORT_VISA));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertFalse((String)"Invalid-S", (boolean)validator.isValid(ERROR_SHORT_VISA));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_VISA));
        CreditCardValidatorTest.assertEquals((Object)VALID_VISA, (Object)validator.validate(VALID_VISA));
        CreditCardValidatorTest.assertEquals((Object)VALID_SHORT_VISA, (Object)validator.validate(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertTrue((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((String)"Valid-A", (boolean)validator.isValid("4111111111111111"));
        CreditCardValidatorTest.assertTrue((String)"Valid-C", (boolean)validator.isValid("4543059999999982"));
        CreditCardValidatorTest.assertTrue((String)"Valid-B", (boolean)validator.isValid("4462000000000003"));
        CreditCardValidatorTest.assertTrue((String)"Valid-D", (boolean)validator.isValid("4508750000000009"));
        CreditCardValidatorTest.assertTrue((String)"Valid-E", (boolean)validator.isValid("4012888888881881"));
    }

    public void testVisaOption() {
        CreditCardValidator validator = new CreditCardValidator(2L);
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_VISA));
        CreditCardValidatorTest.assertFalse((String)"Invalid-S", (boolean)validator.isValid(ERROR_SHORT_VISA));
        CreditCardValidatorTest.assertNull((String)"validate()", (Object)validator.validate(ERROR_VISA));
        CreditCardValidatorTest.assertEquals((Object)VALID_VISA, (Object)validator.validate(VALID_VISA));
        CreditCardValidatorTest.assertEquals((Object)VALID_SHORT_VISA, (Object)validator.validate(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertTrue((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testVPayOption() {
        CreditCardValidator validator = new CreditCardValidator(32L);
        CreditCardValidatorTest.assertTrue((String)"Valid", (boolean)validator.isValid(VALID_VPAY));
        CreditCardValidatorTest.assertTrue((String)"Valid", (boolean)validator.isValid(VALID_VPAY2));
        CreditCardValidatorTest.assertFalse((String)"Invalid", (boolean)validator.isValid(ERROR_VPAY));
        CreditCardValidatorTest.assertEquals((Object)VALID_VPAY, (Object)validator.validate(VALID_VPAY));
        CreditCardValidatorTest.assertEquals((Object)VALID_VPAY2, (Object)validator.validate(VALID_VPAY2));
        CreditCardValidatorTest.assertFalse((String)"Amex", (boolean)validator.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((String)"Diners", (boolean)validator.isValid(VALID_DINERS));
        CreditCardValidatorTest.assertFalse((String)"Discover", (boolean)validator.isValid(VALID_DISCOVER));
        CreditCardValidatorTest.assertFalse((String)"Mastercard", (boolean)validator.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertTrue((String)"Visa", (boolean)validator.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((String)"Visa Short", (boolean)validator.isValid(VALID_SHORT_VISA));
    }

    public void testMastercardUsingSeparators() {
        String MASTERCARD_REGEX_SEP = "^(5[1-5]\\d{2})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})$";
        CodeValidator validator = new CodeValidator(MASTERCARD_REGEX_SEP, LuhnCheckDigit.LUHN_CHECK_DIGIT);
        RegexValidator regex = validator.getRegexValidator();
        CreditCardValidatorTest.assertEquals((String)"Number", (String)"5134567890123456", (String)regex.validate("5134567890123456"));
        CreditCardValidatorTest.assertEquals((String)"Hyphen", (String)"5134567890123456", (String)regex.validate("5134-5678-9012-3456"));
        CreditCardValidatorTest.assertEquals((String)"Space", (String)"5134567890123456", (String)regex.validate("5134 5678 9012 3456"));
        CreditCardValidatorTest.assertEquals((String)"MixedA", (String)"5134567890123456", (String)regex.validate("5134-5678 9012-3456"));
        CreditCardValidatorTest.assertEquals((String)"MixedB", (String)"5134567890123456", (String)regex.validate("5134 5678-9012 3456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Separator A", (boolean)regex.isValid("5134.5678.9012.3456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Separator B", (boolean)regex.isValid("5134_5678_9012_3456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Grouping A", (boolean)regex.isValid("513-45678-9012-3456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Grouping B", (boolean)regex.isValid("5134-567-89012-3456"));
        CreditCardValidatorTest.assertFalse((String)"Invalid Grouping C", (boolean)regex.isValid("5134-5678-901-23456"));
        CreditCardValidatorTest.assertEquals((String)"Valid-A", (Object)"5500000000000004", (Object)validator.validate("5500-0000-0000-0004"));
        CreditCardValidatorTest.assertEquals((String)"Valid-B", (Object)"5424000000000015", (Object)validator.validate("5424 0000 0000 0015"));
        CreditCardValidatorTest.assertEquals((String)"Valid-C", (Object)"5301250070000191", (Object)validator.validate("5301-250070000191"));
        CreditCardValidatorTest.assertEquals((String)"Valid-D", (Object)"5123456789012346", (Object)validator.validate("5123456789012346"));
    }
}

