/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.routines.EmailValidator;

public class EmailValidatorTest
extends TestCase {
    protected static String FORM_KEY = "emailForm";
    protected static String ACTION = "email";
    private EmailValidator validator;
    private static final ResultPair[] testEmailFromPerl = new ResultPair[]{new ResultPair("abigail@example.com", true), new ResultPair("abigail@example.com ", true), new ResultPair(" abigail@example.com", true), new ResultPair("abigail @example.com ", true), new ResultPair("*@example.net", true), new ResultPair("\"\\\"\"@foo.bar", true), new ResultPair("fred&barny@example.com", true), new ResultPair("---@example.com", true), new ResultPair("foo-bar@example.net", true), new ResultPair("\"127.0.0.1\"@[127.0.0.1]", true), new ResultPair("Abigail <abigail@example.com>", true), new ResultPair("Abigail<abigail@example.com>", true), new ResultPair("Abigail<@a,@b,@c:abigail@example.com>", true), new ResultPair("\"This is a phrase\"<abigail@example.com>", true), new ResultPair("\"Abigail \"<abigail@example.com>", true), new ResultPair("\"Joe & J. Harvey\" <example @Org>", true), new ResultPair("Abigail <abigail @ example.com>", true), new ResultPair("Abigail made this <  abigail   @   example  .    com    >", true), new ResultPair("Abigail(the bitch)@example.com", true), new ResultPair("Abigail <abigail @ example . (bar) com >", true), new ResultPair("Abigail < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail (foo) (((baz)(nested) (comment)) ! ) < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail <abigail(fo\\(o)@example.com>", true), new ResultPair("Abigail <abigail(fo\\)o)@example.com> ", true), new ResultPair("(foo) abigail@example.com", true), new ResultPair("abigail@example.com (foo)", true), new ResultPair("\"Abi\\\"gail\" <abigail@example.com>", true), new ResultPair("abigail@[example.com]", true), new ResultPair("abigail@[exa\\[ple.com]", true), new ResultPair("abigail@[exa\\]ple.com]", true), new ResultPair("\":sysmail\"@  Some-Group. Some-Org", true), new ResultPair("Muhammed.(I am  the greatest) Ali @(the)Vegas.WBA", true), new ResultPair("mailbox.sub1.sub2@this-domain", true), new ResultPair("sub-net.mailbox@sub-domain.domain", true), new ResultPair("name:;", true), new ResultPair("':;", true), new ResultPair("name:   ;", true), new ResultPair("Alfred Neuman <Neuman@BBN-TENEXA>", true), new ResultPair("Neuman@BBN-TENEXA", true), new ResultPair("\"George, Ted\" <Shared@Group.Arpanet>", true), new ResultPair("Wilt . (the  Stilt) Chamberlain@NBA.US", true), new ResultPair("Cruisers:  Port@Portugal, Jones@SEA;", true), new ResultPair("$@[]", true), new ResultPair("*()@[]", true), new ResultPair("\"quoted ( brackets\" ( a comment )@example.com", true), new ResultPair("\"Joe & J. Harvey\"\\x0D\\x0A     <ddd\\@ Org>", true), new ResultPair("\"Joe &\\x0D\\x0A J. Harvey\" <ddd \\@ Org>", true), new ResultPair("Gourmets:  Pompous Person <WhoZiWhatZit\\@Cordon-Bleu>,\\x0D\\x0A        Childs\\@WGBH.Boston, \"Galloping Gourmet\"\\@\\x0D\\x0A        ANT.Down-Under (Australian National Television),\\x0D\\x0A        Cheapie\\@Discount-Liquors;", true), new ResultPair("   Just a string", false), new ResultPair("string", false), new ResultPair("(comment)", false), new ResultPair("()@example.com", false), new ResultPair("fred(&)barny@example.com", false), new ResultPair("fred\\ barny@example.com", false), new ResultPair("Abigail <abi gail @ example.com>", false), new ResultPair("Abigail <abigail(fo(o)@example.com>", false), new ResultPair("Abigail <abigail(fo)o)@example.com>", false), new ResultPair("\"Abi\"gail\" <abigail@example.com>", false), new ResultPair("abigail@[exa]ple.com]", false), new ResultPair("abigail@[exa[ple.com]", false), new ResultPair("abigail@[exaple].com]", false), new ResultPair("abigail@", false), new ResultPair("@example.com", false), new ResultPair("phrase: abigail@example.com abigail@example.com ;", false), new ResultPair("invalid\ufffdchar@example.com", false)};

    public EmailValidatorTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.validator = EmailValidator.getInstance();
    }

    protected void tearDown() {
    }

    public void testEmail() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
    }

    public void testEmailWithNumericAddress() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("someone@[216.109.118.76]"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("someone@yahoo.com"));
    }

    public void testEmailExtension() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("jsmith@apache.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("jsmith@apache.net"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("jsmith@apache.info"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("jsmith@apache."));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("jsmith@apache.c"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("someone@yahoo.museum"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("someone@yahoo.mu-seum"));
    }

    public void testEmailWithDash() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("andy.noble@data-workshop.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.-com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.c-om"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.co-m"));
    }

    public void testEmailWithDotEnd() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy.noble@data-workshop.com."));
    }

    public void testEmailWithBogusCharacter() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy.noble@\u008fdata-workshop.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("andy.o'reilly@data-workshop.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("andy@o'reilly.data-workshop.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("foo+bar@i.am.not.in.us.example.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("foo+bar@example+3.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("test@%*.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("test@^&#.com"));
    }

    public void testVALIDATOR_315() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("me@at&t.net"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("me@att.net"));
    }

    public void testVALIDATOR_278() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("someone@-test.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("someone@test-.com"));
    }

    public void testValidator235() {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.6") < 0) {
            System.out.println("Cannot run Unicode IDN tests");
            return;
        }
        EmailValidatorTest.assertTrue((String)"xn--d1abbgf6aiiy.xn--p1ai should validate", (boolean)this.validator.isValid("someone@xn--d1abbgf6aiiy.xn--p1ai"));
        EmailValidatorTest.assertTrue((String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate", (boolean)this.validator.isValid("someone@\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"));
        EmailValidatorTest.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)this.validator.isValid("someone@www.b\u00fccher.ch"));
        EmailValidatorTest.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)this.validator.isValid("someone@www.\ufffd.ch"));
        EmailValidatorTest.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)this.validator.isValid("someone@www.b\u00fccher.ch"));
        EmailValidatorTest.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)this.validator.isValid("someone@www.\ufffd.ch"));
    }

    public void testEmailWithCommas() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow@apa,che.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow@apache.o,rg"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow@apache,org"));
    }

    public void testEmailWithSpaces() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow @apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow@ apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid(" joeblow@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joeblow@apache.org "));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe blow@apache.org "));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joeblow@apa che.org "));
    }

    public void testEmailWithControlChars() {
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            EmailValidatorTest.assertFalse((String)("Test control char " + c), (boolean)this.validator.isValid("foo" + c + "bar@domain.com"));
        }
        EmailValidatorTest.assertFalse((String)"Test control char 127", (boolean)this.validator.isValid("foo\u007fbar@domain.com"));
    }

    public void testEmailLocalhost() {
        EmailValidator noLocal = EmailValidator.getInstance((boolean)false);
        EmailValidator allowLocal = EmailValidator.getInstance((boolean)true);
        EmailValidatorTest.assertEquals((Object)this.validator, (Object)noLocal);
        EmailValidatorTest.assertTrue((String)"@localhost.localdomain should be accepted but wasn't", (boolean)allowLocal.isValid("joe@localhost.localdomain"));
        EmailValidatorTest.assertTrue((String)"@localhost should be accepted but wasn't", (boolean)allowLocal.isValid("joe@localhost"));
        EmailValidatorTest.assertFalse((String)"@localhost.localdomain should be accepted but wasn't", (boolean)noLocal.isValid("joe@localhost.localdomain"));
        EmailValidatorTest.assertFalse((String)"@localhost should be accepted but wasn't", (boolean)noLocal.isValid("joe@localhost"));
    }

    public void testEmailWithSlashes() {
        EmailValidatorTest.assertTrue((String)"/ and ! valid in username", (boolean)this.validator.isValid("joe!/blow@apache.org"));
        EmailValidatorTest.assertFalse((String)"/ not valid in domain", (boolean)this.validator.isValid("joe@ap/ache.org"));
        EmailValidatorTest.assertFalse((String)"! not valid in domain", (boolean)this.validator.isValid("joe@apac!he.org"));
    }

    public void testEmailUserName() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe1blow@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe$blow@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe-@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe_@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe+@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe!@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe*@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe'@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe%45@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe?@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe&@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe=@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("+joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("!joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("*joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("'joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("%joe45@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("?joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("&joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("=joe@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("+@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("!@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("*@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("'@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("%@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("?@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("&@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("=@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe.@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid(".joe@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid(".@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("joe.ok@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe..ok@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("..@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe(@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe)@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe,@apache.org"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("joe;@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe.\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\".joe\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe+\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe!\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe*\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe'\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe(\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe)\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe,\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe%45\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe;\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe?\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe&\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"joe=\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"..\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\"john\\\"doe\"@apache.org"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john@example.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john5@example.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("\\>escape\\\\special\\^characters\\<@example.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("Abc\\@def@example.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("Abc@def@example.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("space\\ monkey@example.com"));
    }

    public void _testEmailFromPerl() {
        for (int index = 0; index < testEmailFromPerl.length; ++index) {
            String item = EmailValidatorTest.testEmailFromPerl[index].item;
            if (EmailValidatorTest.testEmailFromPerl[index].valid) {
                EmailValidatorTest.assertTrue((String)("Should be OK: " + item), (boolean)this.validator.isValid(item));
                continue;
            }
            EmailValidatorTest.assertFalse((String)("Should fail: " + item), (boolean)this.validator.isValid(item));
        }
    }

    public void testValidator293() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("abc-@abc.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("abc_@abc.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("abc-def@abc.com"));
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("abc_def@abc.com"));
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("abc@abc_def.com"));
    }

    public void testValidator365() {
        EmailValidatorTest.assertFalse((boolean)this.validator.isValid("Loremipsumdolorsitametconsecteturadipiscingelit.Nullavitaeligulamattisrhoncusnuncegestasmattisleo.Donecnonsapieninmagnatristiquedictumaacturpis.Fusceorciduifacilisisutsapieneuconsequatpharetralectus.Quisqueenimestpulvinarutquamvitaeportamattisex.Nullamquismaurisplaceratconvallisjustoquisportamauris.Innullalacusconvalliseufringillautvenenatissitametdiam.Maecenasluctusligulascelerisquepulvinarfeugiat.Sedmolestienullaaliquetorciluctusidpharetranislfinibus.Suspendissemalesuadatinciduntduisitametportaarcusollicitudinnec.Donecetmassamagna.Curabitururnadiampretiumveldignissimporttitorfringillaeuneque.Duisantetelluspharetraidtinciduntinterdummolestiesitametfelis.Utquisquamsitametantesagittisdapibusacnonodio.Namrutrummolestiediamidmattis.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Morbiposueresedmetusacconsectetur.Etiamquisipsumvitaejustotempusmaximus.Sedultriciesplaceratvolutpat.Integerlacuslectusmaximusacornarequissagittissitametjusto.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Maecenasindictumpurussedrutrumex.Nullafacilisi.Integerfinibusfinibusmietpharetranislfaucibusvel.Maecenasegetdolorlacinialobortisjustovelullamcorpersem.Vivamusaliquetpurusidvariusornaresapienrisusrutrumnisitinciduntmollissemnequeidmetus.Etiamquiseleifendpurus.Nuncfelisnuncscelerisqueiddignissimnecfinibusalibero.Nuncsemperenimnequesitamethendreritpurusfacilisisac.Maurisdapibussemperfelisdignissimgravida.Aeneanultricesblanditnequealiquamfinibusodioscelerisqueac.Aliquamnecmassaeumaurisfaucibusfringilla.Etiamconsequatligulanisisitametaliquamnibhtemporquis.Nuncinterdumdignissimnullaatsodalesarcusagittiseu.Proinpharetrametusneclacuspulvinarsedvolutpatliberoornare.Sedligulanislpulvinarnonlectuseublanditfacilisisante.Sedmollisnislalacusauctorsuscipit.Inhachabitasseplateadictumst.Phasellussitametvelittemporvenenatisfeliseuegestasrisus.Aliquameteratsitametnibhcommodofinibus.Morbiefficiturodiovelpulvinariaculis.Aeneantemporipsummassaaconsecteturturpisfaucibusultrices.Praesentsodalesmaurisquisportafermentum.Etiamnisinislvenenatisvelauctorutullamcorperinjusto.Proinvelligulaerat.Phasellusvestibulumgravidamassanonfeugiat.Maecenaspharetraeuismodmetusegetefficitur.Suspendisseamet@gmail.com"));
    }

    public void testEmailAtTLD() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        EmailValidatorTest.assertTrue((boolean)val.isValid("test@com"));
    }

    public void testValidator359() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        EmailValidatorTest.assertFalse((boolean)val.isValid("test@.com"));
    }

    public void testValidator374() {
        EmailValidatorTest.assertTrue((boolean)this.validator.isValid("abc@school.school"));
    }
}

