/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.IntegerValidator;

public class IntegerValidatorTest
extends AbstractNumberValidatorTest {
    public IntegerValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new IntegerValidator(false, 0);
        this.strictValidator = new IntegerValidator();
        this.testPattern = "#,###";
        this.max = new Integer(Integer.MAX_VALUE);
        this.maxPlusOne = new Long(this.max.longValue() + 1L);
        this.min = new Integer(Integer.MIN_VALUE);
        this.minMinusOne = new Long(this.min.longValue() - 1L);
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new Integer(1234);
        this.testZero = new Integer(0);
        this.validStrict = new String[]{"0", "1234", "1,234"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testIntegerValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Integer expected = new Integer(12345);
        IntegerValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)IntegerValidator.getInstance().validate(defaultVal));
        IntegerValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)IntegerValidator.getInstance().validate(localeVal, locale));
        IntegerValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)IntegerValidator.getInstance().validate(patternVal, pattern));
        IntegerValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)IntegerValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        IntegerValidatorTest.assertTrue((String)"isValid(A) default", (boolean)IntegerValidator.getInstance().isValid(defaultVal));
        IntegerValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)IntegerValidator.getInstance().isValid(localeVal, locale));
        IntegerValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)IntegerValidator.getInstance().isValid(patternVal, pattern));
        IntegerValidatorTest.assertTrue((String)"isValid(A) both", (boolean)IntegerValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        IntegerValidatorTest.assertNull((String)"validate(B) default", (Object)IntegerValidator.getInstance().validate(XXXX));
        IntegerValidatorTest.assertNull((String)"validate(B) locale ", (Object)IntegerValidator.getInstance().validate(XXXX, locale));
        IntegerValidatorTest.assertNull((String)"validate(B) pattern", (Object)IntegerValidator.getInstance().validate(XXXX, pattern));
        IntegerValidatorTest.assertNull((String)"validate(B) both", (Object)IntegerValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        IntegerValidatorTest.assertFalse((String)"isValid(B) default", (boolean)IntegerValidator.getInstance().isValid(XXXX));
        IntegerValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)IntegerValidator.getInstance().isValid(XXXX, locale));
        IntegerValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)IntegerValidator.getInstance().isValid(XXXX, pattern));
        IntegerValidatorTest.assertFalse((String)"isValid(B) both", (boolean)IntegerValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testIntegerRangeMinMax() {
        IntegerValidator validator = (IntegerValidator)this.strictValidator;
        Integer number9 = validator.validate("9", "#");
        Integer number10 = validator.validate("10", "#");
        Integer number11 = validator.validate("11", "#");
        Integer number19 = validator.validate("19", "#");
        Integer number20 = validator.validate("20", "#");
        Integer number21 = validator.validate("21", "#");
        IntegerValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, 10, 20));
        IntegerValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, 10, 20));
        IntegerValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, 10, 20));
        IntegerValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, 10, 20));
        IntegerValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, 10, 20));
        IntegerValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, 10));
        IntegerValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, 10));
        IntegerValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, 10));
        IntegerValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, 20));
        IntegerValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, 20));
        IntegerValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, 20));
    }
}

