/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class UrlValidatorTest
extends TestCase {
    private final boolean printStatus = false;
    private final boolean printIndex = false;
    ResultPair[] testUrlScheme = new ResultPair[]{new ResultPair("http://", true), new ResultPair("ftp://", true), new ResultPair("h3t://", true), new ResultPair("3ht://", false), new ResultPair("http:/", false), new ResultPair("http:", false), new ResultPair("http/", false), new ResultPair("://", false), new ResultPair("", true)};
    ResultPair[] testUrlAuthority = new ResultPair[]{new ResultPair("www.google.com", true), new ResultPair("go.com", true), new ResultPair("go.au", true), new ResultPair("0.0.0.0", true), new ResultPair("255.255.255.255", true), new ResultPair("256.256.256.256", false), new ResultPair("255.com", true), new ResultPair("1.2.3.4.5", false), new ResultPair("1.2.3.4.", false), new ResultPair("1.2.3", false), new ResultPair(".1.2.3.4", false), new ResultPair("go.a", false), new ResultPair("go.a1a", false), new ResultPair("go.cc", true), new ResultPair("go.1aa", false), new ResultPair("aaa.", false), new ResultPair(".aaa", false), new ResultPair("aaa", false), new ResultPair("", false)};
    ResultPair[] testUrlPort = new ResultPair[]{new ResultPair(":80", true), new ResultPair(":65535", true), new ResultPair(":0", true), new ResultPair("", true), new ResultPair(":-1", false), new ResultPair(":65636", true), new ResultPair(":65a", false)};
    ResultPair[] testPath = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/..//file", false), new ResultPair("/test1//file", false)};
    ResultPair[] testUrlPathOptions = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("/#", false), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/t123/file", true), new ResultPair("/$23/file", true), new ResultPair("/../file", false), new ResultPair("/..//file", false), new ResultPair("/test1//file", true), new ResultPair("/#/file", false)};
    ResultPair[] testUrlQuery = new ResultPair[]{new ResultPair("?action=view", true), new ResultPair("?action=edit&mode=up", true), new ResultPair("", true)};
    Object[] testUrlParts = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testPath, this.testUrlQuery};
    Object[] testUrlPartsOptions = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testUrlPathOptions, this.testUrlQuery};
    int[] testPartsIndex = new int[]{0, 0, 0, 0, 0};
    private final String[] schemes = new String[]{"http", "gopher", "g0-To+.", "not_valid"};
    ResultPair[] testScheme = new ResultPair[]{new ResultPair("http", true), new ResultPair("ftp", false), new ResultPair("httpd", false), new ResultPair("gopher", true), new ResultPair("g0-to+.", true), new ResultPair("not_valid", false), new ResultPair("HtTp", true), new ResultPair("telnet", false)};

    public UrlValidatorTest(String testName) {
        super(testName);
    }

    protected void setUp() {
        for (int index = 0; index < this.testPartsIndex.length - 1; ++index) {
            this.testPartsIndex[index] = 0;
        }
    }

    public void testIsValid() {
        this.testIsValid(this.testUrlParts, 1L);
        this.setUp();
        long options = 7L;
        this.testIsValid(this.testUrlPartsOptions, options);
    }

    public void testIsValidScheme() {
        UrlValidator urlVal = new UrlValidator(this.schemes, 0L);
        for (int sIndex = 0; sIndex < this.testScheme.length; ++sIndex) {
            ResultPair testPair = this.testScheme[sIndex];
            boolean result = urlVal.isValidScheme(testPair.item);
            UrlValidatorTest.assertEquals((String)testPair.item, (boolean)testPair.valid, (boolean)result);
        }
    }

    public void testIsValid(Object[] testObjects, long options) {
        UrlValidator urlVal = new UrlValidator(null, null, options);
        UrlValidatorTest.assertTrue((boolean)urlVal.isValid("http://www.google.com"));
        UrlValidatorTest.assertTrue((boolean)urlVal.isValid("http://www.google.com/"));
        int statusPerLine = 60;
        boolean printed = false;
        do {
            StringBuilder testBuffer = new StringBuilder();
            boolean expected = true;
            for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
                int index = this.testPartsIndex[testPartsIndexIndex];
                ResultPair[] part = (ResultPair[])testObjects[testPartsIndexIndex];
                testBuffer.append(part[index].item);
                expected &= part[index].valid;
            }
            String url = testBuffer.toString();
            boolean result = urlVal.isValid(url);
            UrlValidatorTest.assertEquals((String)url, (boolean)expected, (boolean)result);
        } while (UrlValidatorTest.incrementTestPartsIndex(this.testPartsIndex, testObjects));
    }

    public void testValidator202() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 4L);
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.org"));
    }

    public void testValidator204() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://tech.yahoo.com/rc/desktops/102;_ylt=Ao8yevQHlZ4On0O3ZJGXLEQFLZA5"));
    }

    public void testValidator218() {
        UrlValidator validator = new UrlValidator(2L);
        UrlValidatorTest.assertTrue((String)"parentheses should be valid in URLs", (boolean)validator.isValid("http://somewhere.com/pathxyz/file(1).html"));
    }

    public void testValidator235() {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.6") < 0) {
            System.out.println("Cannot run Unicode IDN tests");
            return;
        }
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((String)"xn--d1abbgf6aiiy.xn--p1ai should validate", (boolean)validator.isValid("http://xn--d1abbgf6aiiy.xn--p1ai"));
        UrlValidatorTest.assertTrue((String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate", (boolean)validator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"));
        UrlValidatorTest.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)validator.isValid("http://www.b\u00fccher.ch"));
        UrlValidatorTest.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)validator.isValid("http://www.\ufffd.ch"));
        UrlValidatorTest.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)validator.isValid("ftp://www.b\u00fccher.ch"));
        UrlValidatorTest.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)validator.isValid("ftp://www.\ufffd.ch"));
    }

    public void testValidator248() {
        RegexValidator regex = new RegexValidator(new String[]{"localhost", ".*\\.my-testing"});
        UrlValidator validator = new UrlValidator(regex, 0L);
        UrlValidatorTest.assertTrue((String)"localhost URL should validate", (boolean)validator.isValid("http://localhost/test/index.html"));
        UrlValidatorTest.assertTrue((String)"first.my-testing should validate", (boolean)validator.isValid("http://first.my-testing/test/index.html"));
        UrlValidatorTest.assertTrue((String)"sup3r.my-testing should validate", (boolean)validator.isValid("http://sup3r.my-testing/test/index.html"));
        UrlValidatorTest.assertFalse((String)"broke.my-test should not validate", (boolean)validator.isValid("http://broke.my-test/test/index.html"));
        UrlValidatorTest.assertTrue((String)"www.apache.org should still validate", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
        validator = new UrlValidator(8L);
        UrlValidatorTest.assertTrue((String)"localhost URL should validate", (boolean)validator.isValid("http://localhost/test/index.html"));
        UrlValidatorTest.assertTrue((String)"machinename URL should validate", (boolean)validator.isValid("http://machinename/test/index.html"));
        UrlValidatorTest.assertTrue((String)"www.apache.org should still validate", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
    }

    public void testValidator288() {
        UrlValidator validator = new UrlValidator(8L);
        UrlValidatorTest.assertTrue((String)"hostname should validate", (boolean)validator.isValid("http://hostname"));
        UrlValidatorTest.assertTrue((String)"hostname with path should validate", (boolean)validator.isValid("http://hostname/test/index.html"));
        UrlValidatorTest.assertTrue((String)"localhost URL should validate", (boolean)validator.isValid("http://localhost/test/index.html"));
        UrlValidatorTest.assertFalse((String)"first.my-testing should not validate", (boolean)validator.isValid("http://first.my-testing/test/index.html"));
        UrlValidatorTest.assertFalse((String)"broke.hostname should not validate", (boolean)validator.isValid("http://broke.hostname/test/index.html"));
        UrlValidatorTest.assertTrue((String)"www.apache.org should still validate", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
        validator = new UrlValidator(0L);
        UrlValidatorTest.assertFalse((String)"hostname should no longer validate", (boolean)validator.isValid("http://hostname"));
        UrlValidatorTest.assertFalse((String)"localhost URL should no longer validate", (boolean)validator.isValid("http://localhost/test/index.html"));
        UrlValidatorTest.assertTrue((String)"www.apache.org should still validate", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
    }

    public void testValidator276() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((String)"http://apache.org/ should be allowed by default", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
        UrlValidatorTest.assertFalse((String)"file:///c:/ shouldn't be allowed by default", (boolean)validator.isValid("file:///C:/some.file"));
        UrlValidatorTest.assertFalse((String)"file:///c:\\ shouldn't be allowed by default", (boolean)validator.isValid("file:///C:\\some.file"));
        UrlValidatorTest.assertFalse((String)"file:///etc/ shouldn't be allowed by default", (boolean)validator.isValid("file:///etc/hosts"));
        UrlValidatorTest.assertFalse((String)"file://localhost/etc/ shouldn't be allowed by default", (boolean)validator.isValid("file://localhost/etc/hosts"));
        UrlValidatorTest.assertFalse((String)"file://localhost/c:/ shouldn't be allowed by default", (boolean)validator.isValid("file://localhost/c:/some.file"));
        validator = new UrlValidator(new String[]{"http", "file"}, 8L);
        UrlValidatorTest.assertTrue((String)"http://apache.org/ should be allowed by default", (boolean)validator.isValid("http://www.apache.org/test/index.html"));
        UrlValidatorTest.assertTrue((String)"file:///c:/ should now be allowed", (boolean)validator.isValid("file:///C:/some.file"));
        UrlValidatorTest.assertFalse((String)"file:///c:\\ shouldn't be allowed", (boolean)validator.isValid("file:///C:\\some.file"));
        UrlValidatorTest.assertTrue((String)"file:///etc/ should now be allowed", (boolean)validator.isValid("file:///etc/hosts"));
        UrlValidatorTest.assertTrue((String)"file://localhost/etc/ should now be allowed", (boolean)validator.isValid("file://localhost/etc/hosts"));
        UrlValidatorTest.assertTrue((String)"file://localhost/c:/ should now be allowed", (boolean)validator.isValid("file://localhost/c:/some.file"));
        UrlValidatorTest.assertFalse((String)"file://c:/ shouldn't ever be allowed, needs file:///c:/", (boolean)validator.isValid("file://C:/some.file"));
        UrlValidatorTest.assertFalse((String)"file://c:\\ shouldn't ever be allowed, needs file:///c:/", (boolean)validator.isValid("file://C:\\some.file"));
    }

    public void testValidator309() {
        UrlValidator urlValidator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://sample.ondemand.com/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("hTtP://sample.ondemand.CoM/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("httpS://SAMPLE.ONEMAND.COM/"));
        urlValidator = new UrlValidator(new String[]{"HTTP", "HTTPS"});
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://sample.ondemand.com/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("hTtP://sample.ondemand.CoM/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("httpS://SAMPLE.ONEMAND.COM/"));
    }

    public void testValidator339() {
        UrlValidator urlValidator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.cnn.com/WORLD/?hpt=sitenav"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.cnn.com./WORLD/?hpt=sitenav"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.cnn.com../"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.cnn.invalid/"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.cnn.invalid./"));
    }

    public void testValidator339IDN() {
        UrlValidator urlValidator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444/WORLD/?hpt=sitenav"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444./WORLD/?hpt=sitenav"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444..../"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444.../"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444../"));
    }

    public void testValidator342() {
        UrlValidator urlValidator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://example.rocks/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://example.rocks"));
    }

    static boolean incrementTestPartsIndex(int[] testPartsIndex, Object[] testParts) {
        boolean carry = true;
        boolean maxIndex = true;
        for (int testPartsIndexIndex = testPartsIndex.length - 1; testPartsIndexIndex >= 0; --testPartsIndexIndex) {
            int index = testPartsIndex[testPartsIndexIndex];
            ResultPair[] part = (ResultPair[])testParts[testPartsIndexIndex];
            if (carry) {
                if (index < part.length - 1) {
                    testPartsIndex[testPartsIndexIndex] = ++index;
                    carry = false;
                } else {
                    testPartsIndex[testPartsIndexIndex] = 0;
                    carry = true;
                }
            }
            maxIndex &= index == part.length - 1;
        }
        return !maxIndex;
    }

    private String testPartsIndextoString() {
        StringBuilder carryMsg = new StringBuilder("{");
        for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
            carryMsg.append(this.testPartsIndex[testPartsIndexIndex]);
            if (testPartsIndexIndex < this.testPartsIndex.length - 1) {
                carryMsg.append(',');
                continue;
            }
            carryMsg.append('}');
        }
        return carryMsg.toString();
    }

    public void testValidateUrl() {
        UrlValidatorTest.assertTrue((boolean)true);
    }

    public void testValidator290() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://xn--h1acbxfam.idn.icann.org/"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--lgbbat1ad8j"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--fiqs8s"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--fiqz9s"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--wgbh1c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--j6w193g"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--h2brj9c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgbbh1a71e"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--fpcrj9c3d"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--gecrj9c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--s9brj9c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--xkc2dl3a5ee0h"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--45brj9c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgba3a4f16a"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgbayh7gpa"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgbc0a9azcg"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--ygbi2ammx"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--wgbl6a"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--p1ai"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgberp4a5d4ar"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--90a3ac"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--yfro4i67o"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--clchc0ea0b2g2a9gcd"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--3e0b707e"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--fzc2c9e2c"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--xkc2al3hye2a"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--ogbpf8fl"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--kprw13d"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--kpry57d"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--o3cw4h"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--pgbs0dh"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://test.xn--mgbaam7a8h"));
    }

    public void testValidator361() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://hello.tokyo/"));
    }

    public void testValidator363() {
        UrlValidator urlValidator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/a/b/hello..world"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/a/hello..world"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello.world/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello..world/"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello.world"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello..world"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/..world"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../world"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.example.org/../world"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.example.org/.."));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.example.org/../"));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.example.org/./.."));
        UrlValidatorTest.assertFalse((boolean)urlValidator.isValid("http://www.example.org/././.."));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/..."));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../"));
        UrlValidatorTest.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../.."));
    }

    public void testValidator375() {
        UrlValidator validator = new UrlValidator();
        String url = "http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:80/index.html";
        UrlValidatorTest.assertTrue((String)("IPv6 address URL should validate: " + url), (boolean)validator.isValid(url));
        url = "http://[::1]:80/index.html";
        UrlValidatorTest.assertTrue((String)("IPv6 address URL should validate: " + url), (boolean)validator.isValid(url));
        url = "http://FEDC:BA98:7654:3210:FEDC:BA98:7654:3210:80/index.html";
        UrlValidatorTest.assertFalse((String)("IPv6 address without [] should not validate: " + url), (boolean)validator.isValid(url));
    }

    public void testValidator353() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://www.apache.org:80/path"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://user:pass@www.apache.org:80/path"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://user:@www.apache.org:80/path"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://us%00er:-._~!$&'()*+,;=@www.apache.org:80/path"));
        UrlValidatorTest.assertFalse((boolean)validator.isValid("http://:pass@www.apache.org:80/path"));
        UrlValidatorTest.assertFalse((boolean)validator.isValid("http://:@www.apache.org:80/path"));
        UrlValidatorTest.assertFalse((boolean)validator.isValid("http://user:pa:ss@www.apache.org/path"));
        UrlValidatorTest.assertFalse((boolean)validator.isValid("http://user:pa@ss@www.apache.org/path"));
    }

    public void testValidator382() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)validator.isValid("ftp://username:password@example.com:8042/over/there/index.dtb?type=animal&name=narwhal#nose"));
    }

    public void testValidator380() {
        UrlValidator validator = new UrlValidator();
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://www.apache.org:80/path"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://www.apache.org:8/path"));
        UrlValidatorTest.assertTrue((boolean)validator.isValid("http://www.apache.org:/path"));
    }

    public static void main(String[] argv) {
        UrlValidatorTest fct = new UrlValidatorTest("url test");
        fct.setUp();
        fct.testIsValid();
        fct.testIsValidScheme();
    }
}

