/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import junit.framework.TestCase;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;

public class FieldTest
extends TestCase {
    protected Field field;

    public FieldTest() {
    }

    public FieldTest(String name) {
        super(name);
    }

    public void setUp() {
        this.field = new Field();
    }

    public void tearDown() {
        this.field = null;
    }

    public void testEmptyArgs() {
        FieldTest.assertEquals((String)"Empty Args(1) ", (int)0, (int)this.field.getArgs("required").length);
    }

    public void testDefaultPositionImplied() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        FieldTest.assertEquals((String)"testDefaultPositionImplied(1) ", (int)3, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testDefaultPositionImplied(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testDefaultPositionImplied(3) ", (String)"default-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testDefaultPositionImplied(4) ", (String)"default-position-2", (String)this.field.getArg("required", 2).getKey());
    }

    public void testDefaultUsingPositions() {
        this.field.addArg(this.createArg("default-position-1", 1));
        this.field.addArg(this.createArg("default-position-0", 0));
        this.field.addArg(this.createArg("default-position-2", 2));
        FieldTest.assertEquals((String)"testDefaultUsingPositions(1) ", (int)3, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testDefaultUsingPositions(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testDefaultUsingPositions(3) ", (String)"default-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testDefaultUsingPositions(4) ", (String)"default-position-2", (String)this.field.getArg("required", 2).getKey());
    }

    public void testDefaultOnePosition() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-2", 2));
        this.field.addArg(this.createArg("default-position-3"));
        FieldTest.assertEquals((String)"testDefaultOnePosition(1) ", (int)4, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testDefaultOnePosition(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertNull((String)"testDefaultOnePosition(3) ", (Object)this.field.getArg("required", 1));
        FieldTest.assertEquals((String)"testDefaultOnePosition(4) ", (String)"default-position-2", (String)this.field.getArg("required", 2).getKey());
        FieldTest.assertEquals((String)"testDefaultOnePosition(5) ", (String)"default-position-3", (String)this.field.getArg("required", 3).getKey());
    }

    public void testDefaultSomePositions() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-2", 2));
        this.field.addArg(this.createArg("default-position-3"));
        this.field.addArg(this.createArg("default-position-1", 1));
        FieldTest.assertEquals((String)"testDefaultSomePositions(1) ", (int)4, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testDefaultSomePositions(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testDefaultSomePositions(3) ", (String)"default-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testDefaultSomePositions(4) ", (String)"default-position-2", (String)this.field.getArg("required", 2).getKey());
        FieldTest.assertEquals((String)"testDefaultSomePositions(5) ", (String)"default-position-3", (String)this.field.getArg("required", 3).getKey());
    }

    public void testOverrideUsingPositionA() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        FieldTest.assertEquals((String)"testOverrideUsingPositionA(1) ", (int)3, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testOverrideUsingPositionA(2) ", (String)"required-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionA(3) ", (int)3, (int)this.field.getArgs("mask").length);
        FieldTest.assertEquals((String)"testOverrideUsingPositionA(4) ", (String)"default-position-1", (String)this.field.getArg("mask", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionA(5) ", (String)"default-position-1", (String)this.field.getArg(1).getKey());
    }

    public void testOverrideUsingPositionB() {
        this.field.addArg(this.createArg("required-position-3", "required", 3));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(1) ", (int)4, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(3) ", (String)"required-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(4) ", (String)"default-position-2", (String)this.field.getArg("required", 2).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(5) ", (String)"required-position-3", (String)this.field.getArg("required", 3).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(6) ", (int)4, (int)this.field.getArgs("mask").length);
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(6) ", (String)"default-position-0", (String)this.field.getArg("mask", 0).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(7) ", (String)"default-position-1", (String)this.field.getArg("mask", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideUsingPositionB(8) ", (String)"default-position-2", (String)this.field.getArg("mask", 2).getKey());
        FieldTest.assertNull((String)"testOverrideUsingPositionB(9) ", (Object)this.field.getArg("mask", 3));
    }

    public void testOverridePositionImplied() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("required-position-1", "required"));
        this.field.addArg(this.createArg("required-position-2", "required"));
        this.field.addArg(this.createArg("mask-position-1", "mask"));
        FieldTest.assertEquals((String)"testOverridePositionImplied(1) ", (int)3, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testOverridePositionImplied(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testOverridePositionImplied(3) ", (String)"required-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testOverridePositionImplied(4) ", (String)"required-position-2", (String)this.field.getArg("required", 2).getKey());
        FieldTest.assertEquals((String)"testOverridePositionImplied(5) ", (int)3, (int)this.field.getArgs("mask").length);
        FieldTest.assertEquals((String)"testOverridePositionImplied(6) ", (String)"default-position-0", (String)this.field.getArg("mask", 0).getKey());
        FieldTest.assertEquals((String)"testOverridePositionImplied(7) ", (String)"mask-position-1", (String)this.field.getArg("mask", 1).getKey());
        FieldTest.assertNull((String)"testOverridePositionImplied(8) ", (Object)this.field.getArg("mask", 2));
        FieldTest.assertEquals((String)"testOverridePositionImplied(9) ", (String)"default-position-0", (String)this.field.getArg(0).getKey());
        FieldTest.assertNull((String)"testOverridePositionImplied(10) ", (Object)this.field.getArg(1));
        FieldTest.assertNull((String)"testOverridePositionImplied(11) ", (Object)this.field.getArg(2));
    }

    public void testOverrideSomePosition() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        this.field.addArg(this.createArg("required-position-2", "required"));
        this.field.addArg(this.createArg("mask-position-3", "mask"));
        FieldTest.assertEquals((String)"testOverrideSomePosition(1) ", (int)4, (int)this.field.getArgs("required").length);
        FieldTest.assertEquals((String)"testOverrideSomePosition(2) ", (String)"default-position-0", (String)this.field.getArg("required", 0).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(3) ", (String)"required-position-1", (String)this.field.getArg("required", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(4) ", (String)"required-position-2", (String)this.field.getArg("required", 2).getKey());
        FieldTest.assertNull((String)"testOverrideSomePosition(5) ", (Object)this.field.getArg("required", 3));
        FieldTest.assertEquals((String)"testOverrideSomePosition(6) ", (int)4, (int)this.field.getArgs("mask").length);
        FieldTest.assertEquals((String)"testOverrideSomePosition(7) ", (String)"default-position-0", (String)this.field.getArg("mask", 0).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(8) ", (String)"default-position-1", (String)this.field.getArg("mask", 1).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(9) ", (String)"default-position-2", (String)this.field.getArg("mask", 2).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(10) ", (String)"mask-position-3", (String)this.field.getArg("mask", 3).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(11) ", (String)"default-position-0", (String)this.field.getArg(0).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(12) ", (String)"default-position-1", (String)this.field.getArg(1).getKey());
        FieldTest.assertEquals((String)"testOverrideSomePosition(13) ", (String)"default-position-2", (String)this.field.getArg(2).getKey());
        FieldTest.assertNull((String)"testOverrideSomePosition(14) ", (Object)this.field.getArg(3));
    }

    private Arg createArg(String key) {
        Arg arg = new Arg();
        arg.setKey(key);
        return arg;
    }

    private Arg createArg(String key, int position) {
        Arg arg = this.createArg(key);
        arg.setPosition(position);
        return arg;
    }

    private Arg createArg(String key, String name) {
        Arg arg = this.createArg(key);
        arg.setName(name);
        return arg;
    }

    private Arg createArg(String key, String name, int position) {
        Arg arg = this.createArg(key, name);
        arg.setPosition(position);
        return arg;
    }
}

