/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class RequiredNameTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "nameForm";
    protected static String ACTION = "required";

    public RequiredNameTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("RequiredNameTest-config.xml");
    }

    protected void tearDown() {
    }

    public void testRequired() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredFirstNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredFirstName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredLastNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredLastName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)lastNameResult.isValid(ACTION));
    }

    public void testRequiredName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        RequiredNameTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        RequiredNameTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        RequiredNameTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)lastNameResult.isValid(ACTION));
    }
}

