/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.AbstractCalendarValidatorTest;
import org.apache.commons.validator.routines.DateValidator;

public class DateValidatorTest
extends AbstractCalendarValidatorTest {
    private DateValidator dateValidator;

    public DateValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dateValidator = new DateValidator();
        this.validator = this.dateValidator;
    }

    public void testDateValidatorMethods() {
        Locale.setDefault(Locale.US);
        Locale locale = Locale.GERMAN;
        String pattern = "yyyy-MM-dd";
        String patternVal = "2005-12-31";
        String germanVal = "31 Dez 2005";
        String germanPattern = "dd MMM yyyy";
        String localeVal = "31.12.2005";
        String defaultVal = "12/31/05";
        String XXXX = "XXXX";
        Date expected = DateValidatorTest.createCalendar(null, 20051231, 0).getTime();
        DateValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)DateValidator.getInstance().validate(defaultVal));
        DateValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)DateValidator.getInstance().validate(localeVal, locale));
        DateValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)DateValidator.getInstance().validate(patternVal, pattern));
        DateValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)DateValidator.getInstance().validate(germanVal, germanPattern, Locale.GERMAN));
        DateValidatorTest.assertTrue((String)"isValid(A) default", (boolean)DateValidator.getInstance().isValid(defaultVal));
        DateValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)DateValidator.getInstance().isValid(localeVal, locale));
        DateValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)DateValidator.getInstance().isValid(patternVal, pattern));
        DateValidatorTest.assertTrue((String)"isValid(A) both", (boolean)DateValidator.getInstance().isValid(germanVal, germanPattern, Locale.GERMAN));
        DateValidatorTest.assertNull((String)"validate(B) default", (Object)DateValidator.getInstance().validate(XXXX));
        DateValidatorTest.assertNull((String)"validate(B) locale ", (Object)DateValidator.getInstance().validate(XXXX, locale));
        DateValidatorTest.assertNull((String)"validate(B) pattern", (Object)DateValidator.getInstance().validate(XXXX, pattern));
        DateValidatorTest.assertNull((String)"validate(B) both", (Object)DateValidator.getInstance().validate("31 Dec 2005", germanPattern, Locale.GERMAN));
        DateValidatorTest.assertFalse((String)"isValid(B) default", (boolean)DateValidator.getInstance().isValid(XXXX));
        DateValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)DateValidator.getInstance().isValid(XXXX, locale));
        DateValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)DateValidator.getInstance().isValid(XXXX, pattern));
        DateValidatorTest.assertFalse((String)"isValid(B) both", (boolean)DateValidator.getInstance().isValid("31 Dec 2005", germanPattern, Locale.GERMAN));
        TimeZone zone = TimeZone.getDefault().getRawOffset() == EET.getRawOffset() ? EST : EET;
        Date expectedZone = DateValidatorTest.createCalendar(zone, 20051231, 0).getTime();
        DateValidatorTest.assertFalse((String)("default/zone same " + zone), (expected.getTime() == expectedZone.getTime() ? 1 : 0) != 0);
        DateValidatorTest.assertEquals((String)"validate(C) default", (Object)expectedZone, (Object)DateValidator.getInstance().validate(defaultVal, zone));
        DateValidatorTest.assertEquals((String)"validate(C) locale ", (Object)expectedZone, (Object)DateValidator.getInstance().validate(localeVal, locale, zone));
        DateValidatorTest.assertEquals((String)"validate(C) pattern", (Object)expectedZone, (Object)DateValidator.getInstance().validate(patternVal, pattern, zone));
        DateValidatorTest.assertEquals((String)"validate(C) both", (Object)expectedZone, (Object)DateValidator.getInstance().validate(germanVal, germanPattern, Locale.GERMAN, zone));
    }

    public void testCompare() {
        int sameTime = 124522;
        int testDate = 20050823;
        Date diffHour = DateValidatorTest.createDate(GMT, testDate, 115922);
        Date value = DateValidatorTest.createDate(GMT, testDate, sameTime);
        Date date20050824 = DateValidatorTest.createDate(GMT, 20050824, sameTime);
        Date date20050822 = DateValidatorTest.createDate(GMT, 20050822, sameTime);
        Date date20050830 = DateValidatorTest.createDate(GMT, 20050830, sameTime);
        Date date20050816 = DateValidatorTest.createDate(GMT, 20050816, sameTime);
        Date date20050901 = DateValidatorTest.createDate(GMT, 20050901, sameTime);
        Date date20050801 = DateValidatorTest.createDate(GMT, 20050801, sameTime);
        Date date20050731 = DateValidatorTest.createDate(GMT, 20050731, sameTime);
        Date date20051101 = DateValidatorTest.createDate(GMT, 20051101, sameTime);
        Date date20051001 = DateValidatorTest.createDate(GMT, 20051001, sameTime);
        Date date20050701 = DateValidatorTest.createDate(GMT, 20050701, sameTime);
        Date date20050630 = DateValidatorTest.createDate(GMT, 20050630, sameTime);
        Date date20050110 = DateValidatorTest.createDate(GMT, 20050110, sameTime);
        Date date20060101 = DateValidatorTest.createDate(GMT, 20060101, sameTime);
        Date date20050101 = DateValidatorTest.createDate(GMT, 20050101, sameTime);
        Date date20041231 = DateValidatorTest.createDate(GMT, 20041231, sameTime);
        DateValidatorTest.assertEquals((String)"date LT", (int)-1, (int)this.dateValidator.compareDates(value, date20050824, GMT));
        DateValidatorTest.assertEquals((String)"date EQ", (int)0, (int)this.dateValidator.compareDates(value, diffHour, GMT));
        DateValidatorTest.assertEquals((String)"date GT", (int)1, (int)this.dateValidator.compareDates(value, date20050822, GMT));
        DateValidatorTest.assertEquals((String)"week LT", (int)-1, (int)this.dateValidator.compareWeeks(value, date20050830, GMT));
        DateValidatorTest.assertEquals((String)"week =1", (int)0, (int)this.dateValidator.compareWeeks(value, date20050824, GMT));
        DateValidatorTest.assertEquals((String)"week =2", (int)0, (int)this.dateValidator.compareWeeks(value, date20050822, GMT));
        DateValidatorTest.assertEquals((String)"week =3", (int)0, (int)this.dateValidator.compareWeeks(value, date20050822, GMT));
        DateValidatorTest.assertEquals((String)"week GT", (int)1, (int)this.dateValidator.compareWeeks(value, date20050816, GMT));
        DateValidatorTest.assertEquals((String)"mnth LT", (int)-1, (int)this.dateValidator.compareMonths(value, date20050901, GMT));
        DateValidatorTest.assertEquals((String)"mnth =1", (int)0, (int)this.dateValidator.compareMonths(value, date20050830, GMT));
        DateValidatorTest.assertEquals((String)"mnth =2", (int)0, (int)this.dateValidator.compareMonths(value, date20050801, GMT));
        DateValidatorTest.assertEquals((String)"mnth =3", (int)0, (int)this.dateValidator.compareMonths(value, date20050816, GMT));
        DateValidatorTest.assertEquals((String)"mnth GT", (int)1, (int)this.dateValidator.compareMonths(value, date20050731, GMT));
        DateValidatorTest.assertEquals((String)"qtrA <1", (int)-1, (int)this.dateValidator.compareQuarters(value, date20051101, GMT));
        DateValidatorTest.assertEquals((String)"qtrA <2", (int)-1, (int)this.dateValidator.compareQuarters(value, date20051001, GMT));
        DateValidatorTest.assertEquals((String)"qtrA =1", (int)0, (int)this.dateValidator.compareQuarters(value, date20050901, GMT));
        DateValidatorTest.assertEquals((String)"qtrA =2", (int)0, (int)this.dateValidator.compareQuarters(value, date20050701, GMT));
        DateValidatorTest.assertEquals((String)"qtrA =3", (int)0, (int)this.dateValidator.compareQuarters(value, date20050731, GMT));
        DateValidatorTest.assertEquals((String)"qtrA GT", (int)1, (int)this.dateValidator.compareQuarters(value, date20050630, GMT));
        DateValidatorTest.assertEquals((String)"qtrB LT", (int)-1, (int)this.dateValidator.compareQuarters(value, date20051101, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB =1", (int)0, (int)this.dateValidator.compareQuarters(value, date20051001, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB =2", (int)0, (int)this.dateValidator.compareQuarters(value, date20050901, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB =3", (int)1, (int)this.dateValidator.compareQuarters(value, date20050701, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB =4", (int)1, (int)this.dateValidator.compareQuarters(value, date20050731, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB GT", (int)1, (int)this.dateValidator.compareQuarters(value, date20050630, GMT, 2));
        DateValidatorTest.assertEquals((String)"qtrB prev", (int)1, (int)this.dateValidator.compareQuarters(value, date20050110, GMT, 2));
        DateValidatorTest.assertEquals((String)"year LT", (int)-1, (int)this.dateValidator.compareYears(value, date20060101, GMT));
        DateValidatorTest.assertEquals((String)"year EQ", (int)0, (int)this.dateValidator.compareYears(value, date20050101, GMT));
        DateValidatorTest.assertEquals((String)"year GT", (int)1, (int)this.dateValidator.compareYears(value, date20041231, GMT));
        Date sameDayTwoAm = DateValidatorTest.createDate(GMT, testDate, 20000);
        DateValidatorTest.assertEquals((String)"date LT", (int)-1, (int)this.dateValidator.compareDates(value, date20050824, EST));
        DateValidatorTest.assertEquals((String)"date EQ", (int)0, (int)this.dateValidator.compareDates(value, diffHour, EST));
        DateValidatorTest.assertEquals((String)"date EQ", (int)1, (int)this.dateValidator.compareDates(value, sameDayTwoAm, EST));
        DateValidatorTest.assertEquals((String)"date GT", (int)1, (int)this.dateValidator.compareDates(value, date20050822, EST));
    }
}

